/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.kawa.xml.KAttr;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.NodeType;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.xml.NodeTree;
import gnu.xquery.util.Compare;
import gnu.xquery.util.NamedCollator;
import gnu.xquery.util.NumberValue;

public class SequenceUtils {
    public static final NodeType textOrElement = new NodeType("element-or-text", 3);

    public static boolean isZeroOrOne(Object object2) {
        return !(object2 instanceof Values) || ((Values)object2).isEmpty();
    }

    static Object coerceToZeroOrOne(Object object2, String string, int n) {
        if (SequenceUtils.isZeroOrOne(object2)) {
            return object2;
        }
        throw new WrongType(string, n, object2, "xs:item()?");
    }

    public static Object zeroOrOne(Object object2) {
        return SequenceUtils.coerceToZeroOrOne(object2, "zero-or-one", 1);
    }

    public static Object oneOrMore(Object object2) {
        if (object2 instanceof Values && ((Values)object2).isEmpty()) {
            throw new IllegalArgumentException();
        }
        return object2;
    }

    public static Object exactlyOne(Object object2) {
        if (object2 instanceof Values) {
            throw new IllegalArgumentException();
        }
        return object2;
    }

    public static boolean isEmptySequence(Object object2) {
        return object2 instanceof Values && ((Values)object2).isEmpty();
    }

    public static boolean exists(Object object2) {
        return !(object2 instanceof Values) || !((Values)object2).isEmpty();
    }

    public static void insertBefore$X(Object object2, long l, Object object3, CallContext callContext) {
        Consumer consumer = callContext.consumer;
        boolean bl = false;
        if (l <= 0L) {
            l = 1L;
        }
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = 0;
            long l2 = 0L;
            while (true) {
                int n2;
                if ((n2 = values.nextPos(n)) == 0 && !bl || ++l2 == l) {
                    Values.writeValues(object3, consumer);
                    bl = true;
                }
                if (n2 != 0) {
                    values.consumePosRange(n, n2, consumer);
                    n = n2;
                    continue;
                }
                break;
            }
        } else {
            if (l <= 1L) {
                Values.writeValues(object3, consumer);
            }
            consumer.writeObject(object2);
            if (l > 1L) {
                Values.writeValues(object3, consumer);
            }
        }
    }

    public static void remove$X(Object object2, long l, CallContext callContext) {
        Consumer consumer = callContext.consumer;
        if (object2 instanceof Values) {
            int n;
            Values values = (Values)object2;
            int n2 = 0;
            long l2 = 0L;
            while ((n = values.nextPos(n2)) != 0) {
                if (++l2 != l) {
                    values.consumePosRange(n2, n, consumer);
                }
                n2 = n;
            }
        } else if (l != 1L) {
            consumer.writeObject(object2);
        }
    }

    public static void reverse$X(Object object2, CallContext callContext) {
        Consumer consumer = callContext.consumer;
        if (!(object2 instanceof Values)) {
            consumer.writeObject(object2);
            return;
        }
        Values values = (Values)object2;
        int n = 0;
        int[] nArray = new int[100];
        int n2 = 0;
        do {
            if (n2 >= nArray.length) {
                int[] nArray2 = new int[2 * n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                nArray = nArray2;
            }
            nArray[n2++] = n;
        } while ((n = values.nextPos(n)) != 0);
        int n3 = n2 - 1;
        while (--n3 >= 0) {
            values.consumePosRange(nArray[n3], nArray[n3 + 1], consumer);
        }
    }

    public static void indexOf$X(Object object2, Object object3, NamedCollator namedCollator, CallContext callContext) {
        Consumer consumer = callContext.consumer;
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.startPos();
            int n2 = 1;
            while ((n = values.nextPos(n)) != 0) {
                if (Compare.apply(72, values.getPosPrevious(n), object3, namedCollator)) {
                    consumer.writeInt(n2);
                }
                ++n2;
            }
        } else if (Compare.apply(72, object2, object3, namedCollator)) {
            consumer.writeInt(1);
        }
    }

    public static boolean deepEqualChildren(NodeTree nodeTree, int n, NodeTree nodeTree2, int n2, NamedCollator namedCollator) {
        NodeType nodeType = textOrElement;
        int n3 = nodeTree.firstChildPos(n, nodeType);
        int n4 = nodeTree2.firstChildPos(n2, nodeType);
        while (n3 != 0 && n4 != 0) {
            if (!SequenceUtils.deepEqual(nodeTree, n3, nodeTree2, n4, namedCollator)) {
                return false;
            }
            n3 = nodeTree.nextMatching(n3, nodeType, -1, false);
            n4 = nodeTree2.nextMatching(n4, nodeType, -1, false);
        }
        return n3 == n4;
    }

    public static boolean deepEqual(NodeTree nodeTree, int n, NodeTree nodeTree2, int n2, NamedCollator namedCollator) {
        int n3 = nodeTree.getNextKind(n);
        int n4 = nodeTree2.getNextKind(n2);
        switch (n3) {
            case 33: {
                String string;
                String string2;
                if (n3 != n4) {
                    return false;
                }
                String string3 = nodeTree.posLocalName(n);
                if (string3 != (string2 = nodeTree2.posLocalName(n2))) {
                    return false;
                }
                String string4 = nodeTree.posNamespaceURI(n);
                if (string4 != (string = nodeTree2.posNamespaceURI(n2))) {
                    return false;
                }
                int n5 = nodeTree.firstAttributePos(n);
                int n6 = 0;
                while (n5 != 0 && nodeTree.getNextKind(n5) == 35) {
                    String string5;
                    ++n6;
                    String string6 = nodeTree.posLocalName(n5);
                    String string7 = nodeTree.posNamespaceURI(n5);
                    int n7 = nodeTree2.getAttributeI(n2, string7, string6);
                    if (n7 == 0) {
                        return false;
                    }
                    String string8 = KNode.getNodeValue(nodeTree, n5);
                    if (!SequenceUtils.deepEqualItems(string8, string5 = KNode.getNodeValue(nodeTree2, n7), namedCollator)) {
                        return false;
                    }
                    n5 = nodeTree.nextPos(n5);
                }
                int n8 = nodeTree2.getAttributeCount(n2);
                if (n6 != n8) {
                    return false;
                }
            }
            case 34: {
                return SequenceUtils.deepEqualChildren(nodeTree, n, nodeTree2, n2, namedCollator);
            }
            case 35: {
                if (nodeTree.posLocalName(n) != nodeTree2.posLocalName(n2) || nodeTree.posNamespaceURI(n) != nodeTree2.posNamespaceURI(n2)) {
                    return false;
                }
                return SequenceUtils.deepEqualItems(KAttr.getObjectValue(nodeTree, n), KAttr.getObjectValue(nodeTree2, n2), namedCollator);
            }
            case 37: {
                if (!nodeTree.posTarget(n).equals(nodeTree2.posTarget(n2))) {
                    return false;
                }
                return KNode.getNodeValue(nodeTree, n).equals(KNode.getNodeValue(nodeTree2, n2));
            }
        }
        if (n3 != n4) {
            return false;
        }
        return KNode.getNodeValue(nodeTree, n).equals(KNode.getNodeValue(nodeTree2, n2));
    }

    public static boolean deepEqualItems(Object object2, Object object3, NamedCollator namedCollator) {
        if (NumberValue.isNaN(object2) && NumberValue.isNaN(object3)) {
            return true;
        }
        return Compare.atomicCompare(8, object2, object3, namedCollator);
    }

    public static boolean deepEqual(Object object2, Object object3, NamedCollator namedCollator) {
        if (object2 == object3) {
            return true;
        }
        if (object2 == null || object2 == Values.empty) {
            return object3 == null || object3 == Values.empty;
        }
        if (object3 == null || object3 == Values.empty) {
            return false;
        }
        int n = 1;
        int n2 = 1;
        boolean bl = object2 instanceof Values;
        boolean bl2 = object3 instanceof Values;
        Values values = bl ? (Values)object2 : null;
        Values values2 = bl2 ? (Values)object3 : null;
        boolean bl3 = true;
        while (true) {
            block17: {
                Object object4;
                if (bl) {
                    if (bl3) {
                        n = values.startPos();
                    }
                    n = values.nextPos(n);
                }
                if (bl2) {
                    if (bl3) {
                        n2 = values2.startPos();
                    }
                    n2 = values2.nextPos(n2);
                }
                if (n == 0 || n2 == 0) {
                    return n == n2;
                }
                Object object5 = bl ? values.getPosPrevious(n) : object2;
                Object object6 = object4 = bl2 ? values2.getPosPrevious(n2) : object3;
                if (!(object5 instanceof KNode) && !(object4 instanceof KNode)) {
                    try {
                        if (!SequenceUtils.deepEqualItems(object2, object3, namedCollator)) {
                            return false;
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }
                if (object5 instanceof KNode && object4 instanceof KNode) {
                    KNode kNode = (KNode)object5;
                    KNode kNode2 = (KNode)object4;
                    if (!SequenceUtils.deepEqual((NodeTree)kNode.sequence, kNode.ipos, (NodeTree)kNode2.sequence, kNode2.ipos, namedCollator)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!bl3) continue;
            bl3 = false;
            if (!bl) {
                n = 0;
            }
            if (bl2) continue;
            n2 = 0;
        }
    }
}

