/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Namespace;
import gnu.mapping.PlainLocation;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.UnboundLocationException;
import java.io.PrintWriter;

public abstract class Location {
    public static final String UNBOUND = new String("(unbound)");

    public Symbol getKeySymbol() {
        return null;
    }

    public Object getKeyProperty() {
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        Symbol symbol = this.getKeySymbol();
        stringBuffer.append('[');
        if (symbol != null) {
            stringBuffer.append(symbol);
            Object object2 = this.getKeyProperty();
            if (object2 != null && object2 != this) {
                stringBuffer.append('/');
                stringBuffer.append(object2);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract Object get(Object var1);

    public final Object get() {
        String string = UNBOUND;
        Object object2 = this.get(string);
        if (object2 == string) {
            throw new UnboundLocationException(this);
        }
        return object2;
    }

    public abstract void set(Object var1);

    public void undefine() {
        this.set(UNBOUND);
    }

    public Object setWithSave(Object object2, CallContext callContext) {
        callContext.pushFluid(this);
        Object object3 = this.get(UNBOUND);
        this.set(object2);
        return object3;
    }

    public void setRestore(Object object2, CallContext callContext) {
        this.set(object2);
        callContext.popFluid();
    }

    public boolean isBound() {
        String string = UNBOUND;
        return this.get(string) != string;
    }

    public boolean isConstant() {
        return false;
    }

    public Location getBase() {
        return this;
    }

    public final Object getValue() {
        return this.get(null);
    }

    public final Object setValue(Object object2) {
        Object object3 = this.get(null);
        this.set(object2);
        return object3;
    }

    public boolean entered() {
        return false;
    }

    public void print(PrintWriter printWriter) {
        String string;
        Object object2;
        printWriter.print("#<location ");
        Symbol symbol = this.getKeySymbol();
        if (symbol != null) {
            printWriter.print(symbol);
        }
        if ((object2 = this.get(string = UNBOUND)) != string) {
            printWriter.print(" -> ");
            printWriter.print(object2);
        } else {
            printWriter.print("(unbound)");
        }
        printWriter.print('>');
    }

    public static Location make(Object object2, String string) {
        ThreadLocation threadLocation = new ThreadLocation(string);
        threadLocation.setGlobal(object2);
        return threadLocation;
    }

    public static IndirectableLocation make(String string) {
        Symbol symbol = Namespace.EmptyNamespace.getSymbol(string.intern());
        PlainLocation plainLocation = new PlainLocation(symbol, null);
        plainLocation.base = null;
        plainLocation.value = UNBOUND;
        return plainLocation;
    }

    public static IndirectableLocation make(Symbol symbol) {
        PlainLocation plainLocation = new PlainLocation(symbol, null);
        plainLocation.base = null;
        plainLocation.value = UNBOUND;
        return plainLocation;
    }
}

