/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.SingletonType;
import gnu.lists.ItemPredicate;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OccurrenceType
extends ObjectType
implements Externalizable,
TypeValue {
    Type base;
    int minOccurs;
    int maxOccurs;
    public static final Type emptySequenceType = OccurrenceType.getInstance(SingletonType.instance, 0, 0);
    public static final ClassType typeOccurrenceType = ClassType.make("gnu.kawa.reflect.OccurrenceType");
    static final Method isInstanceMethod = typeOccurrenceType.getDeclaredMethod("isInstance", 1);

    public Type getBase() {
        return this.base;
    }

    public int minOccurs() {
        return this.minOccurs;
    }

    public int maxOccurs() {
        return this.maxOccurs;
    }

    public OccurrenceType(Type type, int n, int n2) {
        this.base = type;
        this.minOccurs = n;
        this.maxOccurs = n2;
    }

    public static Type getInstance(Type type, int n, int n2) {
        if (n == 1 && n2 == 1) {
            return type;
        }
        if (n == 0 && n2 < 0 && (type == SingletonType.instance || type == Type.pointer_type)) {
            return Type.pointer_type;
        }
        return new OccurrenceType(type, n, n2);
    }

    public Type getImplementationType() {
        return Type.pointer_type;
    }

    public int compare(Type type) {
        if (type instanceof OccurrenceType) {
            OccurrenceType occurrenceType = (OccurrenceType)type;
            if (this.minOccurs == occurrenceType.minOccurs && this.maxOccurs == occurrenceType.maxOccurs) {
                return this.base.compare(occurrenceType.getBase());
            }
        }
        return -2;
    }

    public Object coerceFromObject(Object object2) {
        if (!(object2 instanceof Values) && this.minOccurs <= 1 && this.maxOccurs != 0) {
            return this.base.coerceFromObject(object2);
        }
        if (!this.isInstance(object2)) {
            throw new ClassCastException();
        }
        return object2;
    }

    public boolean isInstance(Object object2) {
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.startPos();
            int n2 = 0;
            if (this.base instanceof ItemPredicate) {
                ItemPredicate itemPredicate = (ItemPredicate)((Object)this.base);
                while (true) {
                    boolean bl = itemPredicate.isInstancePos(values, n);
                    if ((n = values.nextPos(n)) == 0) {
                        return n2 >= this.minOccurs && (this.maxOccurs < 0 || n2 <= this.maxOccurs);
                    }
                    if (!bl) {
                        return false;
                    }
                    ++n2;
                }
            }
            while (true) {
                if ((n = values.nextPos(n)) == 0) {
                    return n2 >= this.minOccurs && (this.maxOccurs < 0 || n2 <= this.maxOccurs);
                }
                Object object3 = values.getPosPrevious(n);
                if (!this.base.isInstance(object3)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.minOccurs > 1 || this.maxOccurs == 0) {
            return false;
        }
        return this.base.isInstance(object2);
    }

    public void emitTestIf(Variable variable, Declaration declaration, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (variable != null) {
            codeAttr.emitLoad(variable);
        }
        if (declaration != null) {
            codeAttr.emitDup();
            declaration.compileStore(compilation);
        }
        compilation.compileConstant(this);
        codeAttr.emitSwap();
        codeAttr.emitInvokeVirtual(isInstanceMethod);
        codeAttr.emitIfIntNotZero();
    }

    public void emitIsInstance(Variable variable, Compilation compilation, Target target) {
        InstanceOf.emitIsInstance(this, variable, compilation, target);
    }

    public Procedure getConstructor() {
        return null;
    }

    public static int itemCountRange(Type type) {
        int n;
        if (type instanceof SingletonType) {
            return 4097;
        }
        if (type instanceof OccurrenceType) {
            OccurrenceType occurrenceType = (OccurrenceType)type;
            int n2 = occurrenceType.minOccurs();
            int n3 = occurrenceType.maxOccurs();
            int n4 = OccurrenceType.itemCountRange(occurrenceType.getBase());
            if (n2 == 1 && n3 == 1 || n4 == 0) {
                return n4;
            }
            if (n3 > 1048575) {
                n3 = -1;
            }
            if (n3 == 0) {
                return 0;
            }
            int n5 = n4 & 0xFFF;
            int n6 = n4 >> 12;
            if (n4 != 4097) {
                if (n2 > 4095) {
                    n2 = 4095;
                }
                if ((n2 *= n5) > 4095) {
                    n2 = 4095;
                }
                n3 = n3 < 0 || n6 < 0 ? -1 : (n3 *= n6);
                if (n3 > 1048575) {
                    n3 = -1;
                }
            }
            return n3 << 12 | n2;
        }
        if (type instanceof PrimType) {
            return type.isVoid() ? 0 : 4097;
        }
        if (type instanceof ArrayType) {
            return 4097;
        }
        if (type instanceof ObjectType && (n = type.compare(Compilation.typeValues)) == -3) {
            return 4097;
        }
        return -4096;
    }

    public static char itemCountCode(Type type) {
        int n = OccurrenceType.itemCountRange(type);
        int n2 = n & 0xFFF;
        int n3 = n >> 12;
        return (char)(n3 == 0 ? 48 : (n2 == 0 ? (n3 == 1 ? 63 : 42) : (n2 == 1 && n3 == 1 ? 49 : 43)));
    }

    public static boolean itemCountIsZeroOrOne(Type type) {
        return OccurrenceType.itemCountRange(type) >> 13 == 0;
    }

    public static boolean itemCountIsOne(Type type) {
        return OccurrenceType.itemCountRange(type) == 4097;
    }

    public static Type itemPrimeType(Type type) {
        while (type instanceof OccurrenceType) {
            type = ((OccurrenceType)type).getBase();
        }
        return OccurrenceType.itemCountIsOne(type) ? type : SingletonType.instance;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.base);
        objectOutput.writeInt(this.minOccurs);
        objectOutput.writeInt(this.maxOccurs);
    }

    public String toString() {
        String string = this.base.toString();
        boolean bl = string == null || string.indexOf(32) >= 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('(');
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(')');
        }
        if (this.minOccurs != 1 || this.maxOccurs != 1) {
            if (this.minOccurs == 0 && this.maxOccurs == 1) {
                stringBuffer.append('?');
            } else if (this.minOccurs == 1 && this.maxOccurs == -1) {
                stringBuffer.append('+');
            } else if (this.minOccurs == 0 && this.maxOccurs == -1) {
                stringBuffer.append('*');
            } else {
                stringBuffer.append('{');
                stringBuffer.append(this.minOccurs);
                stringBuffer.append(',');
                if (this.maxOccurs >= 0) {
                    stringBuffer.append(this.maxOccurs);
                } else {
                    stringBuffer.append('*');
                }
                stringBuffer.append('}');
            }
        }
        return stringBuffer.toString();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.base = (Type)objectInput.readObject();
        this.minOccurs = objectInput.readInt();
        this.maxOccurs = objectInput.readInt();
    }
}

