/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.reflect.OccurrenceType;

public class ConsumerTarget
extends Target {
    Variable consumer;
    boolean isContextTarget;

    public ConsumerTarget(Variable variable) {
        this.consumer = variable;
    }

    public Variable getConsumerVariable() {
        return this.consumer;
    }

    public final boolean isContextTarget() {
        return this.isContextTarget;
    }

    public static Target makeContextTarget(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        compilation.loadCallContext();
        codeAttr.emitGetField(Compilation.typeCallContext.getDeclaredField("consumer"));
        Scope scope = codeAttr.getCurrentScope();
        Variable variable = scope.addVariable(codeAttr, Compilation.typeConsumer, "$result");
        codeAttr.emitStore(variable);
        ConsumerTarget consumerTarget = new ConsumerTarget(variable);
        consumerTarget.isContextTarget = true;
        return consumerTarget;
    }

    public static void compileUsingConsumer(Expression expression, Compilation compilation, Target target) {
        if (target instanceof ConsumerTarget || target instanceof IgnoreTarget) {
            expression.compile(compilation, target);
        } else {
            ClassType classType = Compilation.typeValues;
            ConsumerTarget.compileUsingConsumer(expression, compilation, target, classType.getDeclaredMethod("make", 0), classType.getDeclaredMethod("canonicalize", 0));
        }
    }

    public static void compileUsingConsumer(Expression expression, Compilation compilation, Target target, Method method, Method method2) {
        Type type;
        Object object2;
        CodeAttr codeAttr = compilation.getCode();
        Scope scope = codeAttr.pushScope();
        if (method.getName() == "<init>") {
            object2 = method.getDeclaringClass();
            type = object2;
            codeAttr.emitNew((ClassType)object2);
            codeAttr.emitDup(type);
            codeAttr.emitInvoke(method);
        } else {
            type = method.getReturnType();
            codeAttr.emitInvokeStatic(method);
        }
        object2 = scope.addVariable(codeAttr, type, null);
        ConsumerTarget consumerTarget = new ConsumerTarget((Variable)object2);
        codeAttr.emitStore((Variable)object2);
        expression.compile(compilation, consumerTarget);
        codeAttr.emitLoad((Variable)object2);
        if (method2 != null) {
            codeAttr.emitInvoke(method2);
        }
        codeAttr.popScope();
        target.compileFromStack(compilation, method2 == null ? type : method2.getReturnType());
    }

    public void compileFromStack(Compilation compilation, Type type) {
        this.compileFromStack(compilation, type, -1);
    }

    void compileFromStack(Compilation compilation, Type type, int n) {
        Type[] typeArray;
        char c;
        CodeAttr codeAttr = compilation.getCode();
        String string = null;
        Method method = null;
        Type type2 = null;
        boolean bl = false;
        if ((type = type.getImplementationType()) instanceof PrimType) {
            c = type.getSignature().charAt(0);
            switch (c) {
                case 'B': 
                case 'I': 
                case 'S': {
                    string = "writeInt";
                    type2 = Type.intType;
                    break;
                }
                case 'J': {
                    string = "writeLong";
                    type2 = Type.longType;
                    bl = true;
                    break;
                }
                case 'F': {
                    string = "writeFloat";
                    type2 = Type.floatType;
                    break;
                }
                case 'D': {
                    string = "writeDouble";
                    type2 = Type.doubleType;
                    bl = true;
                    break;
                }
                case 'C': {
                    string = "append";
                    type2 = Type.charType;
                    break;
                }
                case 'Z': {
                    string = "writeBoolean";
                    type2 = Type.booleanType;
                    break;
                }
                case 'V': {
                    return;
                }
            }
        } else {
            c = '\u0000';
            if (n == 1 || OccurrenceType.itemCountIsOne(type)) {
                string = "writeObject";
                type2 = Type.pointer_type;
            } else {
                method = Compilation.typeValues.getDeclaredMethod("writeValues", 2);
                codeAttr.emitLoad(this.consumer);
                if (n == 0) {
                    codeAttr.emitSwap();
                }
                codeAttr.emitInvokeStatic(method);
                return;
            }
        }
        if (n < 0) {
            if (bl) {
                codeAttr.pushScope();
                typeArray = codeAttr.addLocal(type);
                codeAttr.emitStore((Variable)typeArray);
                codeAttr.emitLoad(this.consumer);
                codeAttr.emitLoad((Variable)typeArray);
                codeAttr.popScope();
            } else {
                codeAttr.emitLoad(this.consumer);
                codeAttr.emitSwap();
            }
        }
        if (method == null && string != null) {
            typeArray = new Type[]{type2};
            method = Compilation.typeConsumer.getDeclaredMethod(string, typeArray);
        }
        if (method != null) {
            codeAttr.emitInvokeInterface(method);
        }
        if (c == 'C') {
            codeAttr.emitPop(1);
        }
    }

    public boolean compileWrite(Expression expression, Compilation compilation) {
        Type type = expression.getType();
        Type type2 = type.getImplementationType();
        if (type2 instanceof PrimType && !type2.isVoid() || OccurrenceType.itemCountIsOne(type2)) {
            compilation.getCode().emitLoad(this.consumer);
            Target target = StackTarget.getInstance(type2);
            expression.compile(compilation, target);
            this.compileFromStack(compilation, type2, 1);
            return true;
        }
        return false;
    }

    public Type getType() {
        return Compilation.scmSequenceType;
    }
}

