/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.Literal;
import gnu.expr.QuoteExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;

public class BindingInitializer
extends Initializer {
    Declaration decl;
    Expression value;
    static final ClassType typeThreadLocation = ClassType.make("gnu.mapping.ThreadLocation");

    public static void create(Declaration declaration, Expression expression, Compilation compilation) {
        BindingInitializer bindingInitializer = new BindingInitializer(declaration, expression);
        if (declaration.field != null && declaration.field.getStaticFlag()) {
            bindingInitializer.next = compilation.clinitChain;
            compilation.clinitChain = bindingInitializer;
        } else {
            bindingInitializer.next = compilation.mainLambda.initChain;
            compilation.mainLambda.initChain = bindingInitializer;
        }
    }

    public BindingInitializer(Declaration declaration, Expression expression) {
        this.decl = declaration;
        this.value = expression;
        this.field = declaration.field;
    }

    public void emit(Compilation compilation) {
        Object object2;
        Object object3;
        CodeAttr codeAttr = compilation.getCode();
        if (this.value instanceof QuoteExp && (object3 = ((QuoteExp)this.value).getValue()) != null && !(object3 instanceof String)) {
            object2 = compilation.litTable.findLiteral(object3);
            if (((Literal)object2).field == this.field) {
                return;
            }
        }
        int n = this.decl.getLineNumber();
        object2 = compilation.getMessages();
        SourceLocator sourceLocator = ((SourceMessages)object2).swapSourceLocator(this.decl);
        if (n > 0) {
            codeAttr.putLineNumber(this.decl.getFileName(), n);
        }
        if (this.field != null && !this.field.getStaticFlag()) {
            codeAttr.emitPushThis();
        }
        if (this.value == null) {
            boolean bl = compilation.getLanguage().hasSeparateFunctionNamespace();
            Object object4 = bl && this.decl.isProcedureDecl() ? EnvironmentKey.FUNCTION : null;
            Object object5 = this.decl.getSymbol();
            if (this.decl.getFlag(0x10010010)) {
                if (object5 instanceof String) {
                    object5 = Namespace.EmptyNamespace.getSymbol((String)object5);
                }
                compilation.compileConstant(object5, Target.pushObject);
                if (object4 == null) {
                    codeAttr.emitPushNull();
                } else {
                    compilation.compileConstant(object4, Target.pushObject);
                }
                codeAttr.emitInvokeStatic(typeThreadLocation.getDeclaredMethod("getInstance", 2));
            } else {
                compilation.compileConstant(object5, Target.pushObject);
                codeAttr.emitInvokeStatic(BindingInitializer.makeLocationMethod(object5));
            }
        } else {
            Type type = this.field == null ? this.decl.getType() : this.field.getType();
            this.value.compileWithPosition(compilation, StackTarget.getInstance(type));
        }
        if (this.field == null) {
            Variable variable = this.decl.getVariable();
            if (variable == null) {
                variable = this.decl.allocateVariable(codeAttr);
            }
            codeAttr.emitStore(variable);
        } else if (this.field.getStaticFlag()) {
            codeAttr.emitPutStatic(this.field);
        } else {
            codeAttr.emitPutField(this.field);
        }
        ((SourceMessages)object2).swapSourceLocator(sourceLocator);
    }

    public static Method makeLocationMethod(Object object2) {
        Type[] typeArray = new Type[]{object2 instanceof Symbol ? Compilation.typeSymbol : Type.javalangStringType};
        return Compilation.typeLocation.getDeclaredMethod("make", typeArray);
    }
}

