/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.BuiltinEnvironment;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.KawaConvert;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SimplePrompter;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.lists.AbstractFormat;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.FString;
import gnu.lists.PrintConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.InPort;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.NamedLocation;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kawa.repl;

public abstract class Language {
    protected static final ThreadLocation current = new ThreadLocation("language");
    static String[][] languages;
    protected Environment environ;
    protected Environment userEnv;
    static int envCounter;
    public static final int PARSE_IMMEDIATE = 1;
    public static final int PARSE_ONE_LINE = 2;
    public static final String NAMESPACE_PREFIX = "$Namespace$";
    public static final int VALUE_NAMESPACE = 1;
    public static final int FUNCTION_NAMESPACE = 2;
    public static final int NAMESPACE_PREFIX_NAMESPACE = 4;
    protected static int env_counter;

    public static Language getDefaultLanguage() {
        return (Language)current.get(null);
    }

    public static void setDefaultLanguage(Language language) {
        current.set(language);
    }

    public static String[][] getLanguages() {
        return languages;
    }

    public static void registerLanguage(String[] stringArray) {
        String[][] stringArrayArray = new String[languages.length + 1][];
        System.arraycopy(languages, 0, stringArrayArray, 0, languages.length);
        stringArrayArray[stringArrayArray.length - 1] = stringArray;
        languages = stringArrayArray;
    }

    public static Language getInstanceFromFilenameExtension(String string) {
        Language language;
        int n = string.lastIndexOf(46);
        if (n > 0 && (language = Language.getInstance(string.substring(n))) != null) {
            return language;
        }
        return null;
    }

    public static Language getInstance(String string) {
        int n = languages.length;
        block2: for (int i = 0; i < n; ++i) {
            int n2;
            String[] stringArray = languages[i];
            int n3 = n2 = stringArray.length - 1;
            while (--n3 >= 0) {
                Class<?> clazz;
                if (string != null && !stringArray[n3].equalsIgnoreCase(string)) continue;
                try {
                    clazz = Class.forName(stringArray[n2]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue block2;
                }
                return Language.getInstance(stringArray[0], clazz);
            }
        }
        return null;
    }

    protected Language() {
        Convert.setInstance(KawaConvert.getInstance());
    }

    public static Language getInstance(String string, Class clazz) {
        try {
            Method method;
            Class[] classArray = new Class[]{};
            try {
                String string2 = Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase();
                String string3 = "get" + string2 + "Instance";
                method = clazz.getDeclaredMethod(string3, classArray);
            }
            catch (Exception exception) {
                method = clazz.getDeclaredMethod("getInstance", classArray);
            }
            return (Language)method.invoke(null, Values.noArgs);
        }
        catch (Exception exception) {
            string = clazz.getName();
            Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
            throw new WrappedException("getInstance for '" + string + "' failed", throwable);
        }
    }

    public boolean isTrue(Object object2) {
        return object2 != Boolean.FALSE;
    }

    public Object booleanObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object noValue() {
        return Values.empty;
    }

    public boolean hasSeparateFunctionNamespace() {
        return false;
    }

    public final Environment getEnvironment() {
        return this.userEnv != null ? this.userEnv : Environment.getCurrent();
    }

    public final Environment getNewEnvironment() {
        return Environment.make("environment-" + ++envCounter, this.environ);
    }

    public Environment getLangEnvironment() {
        return this.environ;
    }

    public NamedLocation lookupBuiltin(Symbol symbol, Object object2, int n) {
        return this.environ == null ? null : this.environ.lookup(symbol, object2, n);
    }

    public void define(String string, Object object2) {
        Symbol symbol = this.getSymbol(string);
        this.environ.define(symbol, null, object2);
    }

    protected void defAliasStFld(String string, String string2, String string3) {
        StaticFieldLocation.define(this.environ, this.getSymbol(string), null, string2, string3);
    }

    protected void defProcStFld(String string, String string2, String string3) {
        Object object2 = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        Symbol symbol = this.getSymbol(string);
        StaticFieldLocation staticFieldLocation = StaticFieldLocation.define(this.environ, symbol, object2, string2, string3);
        staticFieldLocation.setProcedure();
    }

    protected void defProcStFld(String string, String string2) {
        this.defProcStFld(string, string2, Compilation.mangleNameIfNeeded(string));
    }

    public final void defineFunction(Named named) {
        Object object2 = named.getSymbol();
        Symbol symbol = object2 instanceof Symbol ? (Symbol)object2 : this.getSymbol(object2.toString());
        Object object3 = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        this.environ.define(symbol, object3, named);
    }

    public void defineFunction(String string, Object object2) {
        Object object3 = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        this.environ.define(this.getSymbol(string), object3, object2);
    }

    private void defineAll(Object object2) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            String string = field.getName();
            if (string.startsWith("$Prvt$") || string.endsWith("$instance")) continue;
            if ((field.getModifiers() & 0x10) != 0) {
                try {
                    this.defineFromFieldValue(field, field.get(object2));
                    continue;
                }
                catch (Throwable throwable) {
                    throw new WrappedException("error accessing field " + field, throwable);
                }
            }
            System.err.println("INTERNAL ERROR in defineAll for " + string + " in " + clazz);
        }
    }

    private void defineFromFieldValue(Field field, Object object2) throws Throwable {
        if (object2 instanceof Location) {
            Location location2 = (Location)object2;
            Symbol symbol = location2.getKeySymbol();
            if (symbol != null) {
                this.environ.addLocation(symbol, location2.getKeyProperty(), location2);
                return;
            }
        } else {
            Object object3 = object2 instanceof Named ? ((Named)object2).getSymbol() : null;
            if (object3 == null) {
                object3 = Compilation.demangleName(field.getName(), true).intern();
            }
            Symbol symbol = object3 instanceof Symbol ? (Symbol)object3 : this.environ.getSymbol(object3.toString());
            Object object4 = this.getEnvPropertyFor(field, object2);
            this.environ.define(symbol, object4, object2);
        }
    }

    public Object getEnvPropertyFor(Field field, Object object2) {
        if (!this.hasSeparateFunctionNamespace()) {
            return null;
        }
        if (Compilation.typeProcedure.getReflectClass().isAssignableFrom(field.getType())) {
            return EnvironmentKey.FUNCTION;
        }
        return null;
    }

    public Object getEnvPropertyFor(Declaration declaration) {
        if (this.hasSeparateFunctionNamespace() && declaration.isProcedureDecl()) {
            return EnvironmentKey.FUNCTION;
        }
        return null;
    }

    public void loadClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            this.defineAll(obj);
            if (obj instanceof ModuleBody) {
                ((ModuleBody)obj).run();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new WrappedException("cannot load " + string, exception);
        }
    }

    public Symbol getSymbol(String string) {
        return this.environ.getSymbol(string);
    }

    public Object lookup(String string) {
        return this.environ.get(string);
    }

    public void print(Object object2, OutPort outPort) {
        this.print(object2, outPort, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object object2, OutPort outPort, boolean bl) {
        if (object2 == Values.empty) {
            return;
        }
        AbstractFormat abstractFormat = outPort.objectFormat;
        try {
            outPort.objectFormat = this.getFormat(bl);
            if (object2 instanceof Values) {
                Object[] objectArray = ((Values)object2).getValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    outPort.println(objectArray[i]);
                }
            } else {
                outPort.println(object2);
            }
        }
        finally {
            outPort.objectFormat = abstractFormat;
        }
    }

    public AbstractFormat getFormat(boolean bl) {
        return null;
    }

    public Consumer getOutputConsumer(Writer writer) {
        OutPort outPort = writer instanceof OutPort ? (OutPort)writer : new OutPort(writer);
        outPort.objectFormat = this.getFormat(false);
        return outPort;
    }

    public String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public abstract Lexer getLexer(InPort var1, SourceMessages var2);

    public final Compilation parse(InPort inPort, SourceMessages sourceMessages, int n) throws IOException, SyntaxException {
        Lexer lexer = this.getLexer(inPort, sourceMessages);
        return this.parse(lexer, n);
    }

    public abstract Compilation parse(Lexer var1, int var2) throws IOException, SyntaxException;

    public Type getTypeFor(Class clazz) {
        return Type.make(clazz);
    }

    public static Type string2Type(String string) {
        Type type;
        if (string.endsWith("[]")) {
            type = Language.string2Type(string.substring(0, string.length() - 2));
            if (type == null) {
                return null;
            }
            type = ArrayType.make(type);
        } else if (Type.isValidJavaTypeName(string)) {
            type = Type.getType(string);
        } else {
            return null;
        }
        return type;
    }

    public Type getTypeFor(String string) {
        return Language.string2Type(string);
    }

    public Type asType(Object object2) {
        if (!(object2 instanceof Type)) {
            if (object2 instanceof Class) {
                return this.getTypeFor((Class)object2);
            }
            if (object2 instanceof String || object2 instanceof FString) {
                return this.getTypeFor(object2.toString());
            }
            if (object2 instanceof Symbol) {
                return this.getTypeFor(((Symbol)object2).getName());
            }
            if (object2 instanceof CharSeq) {
                return ClassType.make(object2.toString());
            }
        }
        return (Type)object2;
    }

    public Type getTypeFor(Expression expression) {
        if (expression instanceof QuoteExp) {
            try {
                return this.asType(((QuoteExp)expression).getValue());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (expression instanceof ReferenceExp) {
            Object object2;
            ReferenceExp referenceExp = (ReferenceExp)expression;
            Declaration declaration = Declaration.followAliases(referenceExp.getBinding());
            String string = referenceExp.getName();
            if (declaration != null) {
                string = declaration.getName();
                expression = declaration.getValue();
                if (declaration.isAlias() && expression instanceof QuoteExp) {
                    object2 = ((QuoteExp)expression).getValue();
                    if (object2 instanceof Location) {
                        Location location2 = (Location)object2;
                        if (location2.isBound()) {
                            return this.asType(location2.get());
                        }
                        if (!(location2 instanceof Named)) {
                            return null;
                        }
                        string = ((Named)((Object)location2)).getName();
                    }
                } else if (!declaration.getFlag(65536)) {
                    return this.getTypeFor(expression);
                }
            }
            if ((object2 = this.getEnvironment().get(string)) instanceof Type) {
                return (Type)object2;
            }
            int n = string.length();
            if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                return this.getTypeFor(string.substring(1, n - 1));
            }
        } else if (expression instanceof ClassExp) {
            return ((ClassExp)expression).getType();
        }
        return null;
    }

    public Declaration declFromField(ModuleExp moduleExp, Object object2, gnu.bytecode.Field field) {
        boolean bl;
        Object object3;
        String string = field.getName();
        Type type = field.getType();
        boolean bl2 = type.isSubtype(Compilation.typeLocation);
        boolean bl3 = string.endsWith("$instance");
        if (bl3) {
            object3 = string;
        } else if (object2 instanceof Named) {
            object3 = ((Named)object2).getSymbol();
        } else {
            if (string.startsWith("$Prvt$")) {
                string = string.substring("$Prvt$".length());
            }
            object3 = Compilation.demangleName(string, true).intern();
        }
        ClassType classType = bl2 ? Type.pointer_type : this.getTypeFor(type.getReflectClass());
        Declaration declaration = moduleExp.addDeclaration(object3, classType);
        boolean bl4 = (field.getModifiers() & 8) != 0;
        boolean bl5 = bl = (field.getModifiers() & 0x10) != 0;
        if (bl2) {
            declaration.setIndirectBinding(true);
        } else if (bl && type.isSubtype(Compilation.typeProcedure)) {
            declaration.setProcedureDecl(true);
        }
        if (bl4) {
            declaration.setFlag(2048);
        }
        declaration.field = field;
        if (bl && !bl2) {
            declaration.setFlag(16384);
        }
        if (bl3) {
            declaration.setFlag(0x40000000);
        }
        declaration.setSimple(false);
        return declaration;
    }

    public int getNamespaceOf(Declaration declaration) {
        return 1;
    }

    public void emitPushBoolean(boolean bl, CodeAttr codeAttr) {
        codeAttr.emitGetStatic(bl ? Compilation.trueConstant : Compilation.falseConstant);
    }

    public void emitCoerceToBoolean(CodeAttr codeAttr) {
        this.emitPushBoolean(false, codeAttr);
        codeAttr.emitIfNEq();
        codeAttr.emitPushInt(1);
        codeAttr.emitElse();
        codeAttr.emitPushInt(0);
        codeAttr.emitFi();
    }

    public Object coerceFromObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceFromObject(object2);
    }

    public Object coerceToObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceToObject(object2);
    }

    public Object coerceToObject(int n) {
        return IntNum.make(n);
    }

    public static synchronized void setDefaults(Language language) {
        Language.setDefaultLanguage(language);
        current.setGlobal(language);
        if (Environment.getGlobal() == BuiltinEnvironment.getInstance()) {
            Environment.setGlobal(Environment.getCurrent());
        }
    }

    public Procedure getPrompter() {
        Procedure procedure;
        Object object2 = null;
        if (this.hasSeparateFunctionNamespace()) {
            object2 = EnvironmentKey.FUNCTION;
        }
        if ((procedure = (Procedure)this.getEnvironment().get(this.getSymbol("default-prompter"), object2, null)) != null) {
            return procedure;
        }
        return new SimplePrompter();
    }

    public final Object eval(String string) throws Throwable {
        return this.eval(new CharArrayInPort(string));
    }

    public final Object eval(Reader reader) throws Throwable {
        return this.eval(reader instanceof InPort ? (InPort)reader : new InPort(reader));
    }

    public final Object eval(InPort inPort) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            this.eval(inPort, callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public final void eval(String string, Writer writer) throws Throwable {
        this.eval((Reader)new CharArrayInPort(string), writer);
    }

    public final void eval(String string, PrintConsumer printConsumer) throws Throwable {
        this.eval(string, this.getOutputConsumer(printConsumer));
    }

    public final void eval(String string, Consumer consumer) throws Throwable {
        this.eval((Reader)new CharArrayInPort(string), consumer);
    }

    public final void eval(Reader reader, Writer writer) throws Throwable {
        this.eval(reader, this.getOutputConsumer(writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(Reader reader, Consumer consumer) throws Throwable {
        InPort inPort = reader instanceof InPort ? (InPort)reader : new InPort(reader);
        CallContext callContext = CallContext.getInstance();
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            this.eval(inPort, callContext);
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(InPort inPort, CallContext callContext) throws Throwable {
        SourceMessages sourceMessages = new SourceMessages();
        Language language = Language.getDefaultLanguage();
        Language.setDefaultLanguage(this);
        try {
            Compilation compilation = this.parse(inPort, sourceMessages, 1);
            ModuleExp.evalModule(this.getEnvironment(), callContext, compilation);
        }
        finally {
            Language.setDefaultLanguage(language);
        }
        if (sourceMessages.seenErrors()) {
            throw new RuntimeException("invalid syntax in eval form:\n" + sourceMessages.toString(20));
        }
    }

    public void runAsApplication(String[] stringArray) {
        Language.setDefaults(this);
        repl.main(stringArray);
    }

    static {
        Environment.setGlobal(BuiltinEnvironment.getInstance());
        languages = new String[][]{{"scheme", ".scm", ".sc", "kawa.standard.Scheme"}, {"krl", ".krl", "gnu.kawa.brl.BRL"}, {"brl", ".brl", "gnu.kawa.brl.BRL"}, {"emacs", "elisp", "emacs-lisp", ".el", "gnu.jemacs.lang.ELisp"}, {"xquery", ".xquery", ".xq", ".xql", "gnu.xquery.lang.XQuery"}, {"q2", ".q2", "gnu.q2.lang.Q2"}, {"xslt", "xsl", ".xsl", "gnu.kawa.xslt.XSLT"}, {"commonlisp", "common-lisp", "clisp", "lisp", ".lisp", ".lsp", ".cl", "gnu.commonlisp.lang.CommonLisp"}};
        env_counter = 0;
    }
}

