/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.kawa.functions.DisplayFormat;
import gnu.lists.Consumer;

public class Print
extends DisplayFormat {
    public Print(boolean readable) {
        super(readable, 'E');
    }

    public static String escapeChar(int ch) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('?');
        if (ch < 32) {
            sbuf.append('\\');
            switch (ch) {
                case 9: {
                    sbuf.append('t');
                    break;
                }
                case 10: {
                    sbuf.append('n');
                    break;
                }
                case 13: {
                    sbuf.append('r');
                    break;
                }
                default: {
                    sbuf.append('^');
                    sbuf.append((char)(ch + 64));
                    if (ch + 64 == 92) {
                        sbuf.append('\\');
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (ch < 127) {
            switch (ch) {
                case 32: 
                case 34: 
                case 35: 
                case 39: 
                case 40: 
                case 41: 
                case 44: 
                case 46: 
                case 59: 
                case 63: 
                case 91: 
                case 92: 
                case 93: 
                case 96: {
                    sbuf.append('\\');
                }
            }
            sbuf.append((char)ch);
        } else if (ch == 127) {
            sbuf.append("\\^?");
        } else {
            if (ch < 160) {
                sbuf.append("\\^");
            }
            sbuf.append(ch);
        }
        return sbuf.toString();
    }

    public void write(int v, Consumer out) {
        if (this.getReadableOutput()) {
            this.write(Print.escapeChar(v), out);
        } else {
            out.write(v);
        }
    }
}

