/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.bytecode.ClassType;
import gnu.expr.PrimProcedure;
import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EKeymap;
import gnu.jemacs.buffer.EWindow;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Mode;
import gnu.jemacs.buffer.ProcessInsertCommand;
import gnu.jemacs.buffer.Signal;
import gnu.lists.CharSeq;
import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;
import java.io.IOException;
import java.io.Writer;

public class ProcessMode
extends Mode {
    protected Writer toInferior;
    protected Marker processMark;
    protected boolean lineMode = false;
    static Procedure enterAction = new PrimProcedure(ClassType.make("gnu.jemacs.buffer.ProcessMode").getDeclaredMethod("enterAction", 0));
    public static EKeymap modeMap = new EKeymap("process");

    public Marker getProcessMark() {
        return this.processMark;
    }

    public static void enterAction() {
        Buffer buffer = Buffer.getCurrent();
        ProcessMode pmode = ProcessMode.getProcessMode(buffer);
        pmode.enter();
    }

    public void enter() {
        try {
            if (this.lineMode) {
                this.buffer.insert('\n', 1, null);
                int pos = this.buffer.getDot();
                int markPos = this.processMark.getOffset();
                this.buffer.writeTo(markPos, pos - markPos, this.toInferior);
                this.processMark.setDot(pos);
            } else {
                this.toInferior.write(13);
            }
            this.toInferior.flush();
        }
        catch (Exception ex) {
            throw new WrappedException(ex);
        }
    }

    public static ProcessMode getProcessMode(Buffer buffer) {
        Mode mode = buffer.modes;
        while (true) {
            if (mode == null) {
                Signal.error("not in process mode");
            }
            if (mode instanceof ProcessMode) {
                return (ProcessMode)mode;
            }
            mode = mode.next;
        }
    }

    public void writeToInferior(CharSeq str) throws IOException {
        str.writeTo(this.toInferior);
        this.toInferior.flush();
    }

    public void selfInsert() {
        EWindow window = EWindow.getSelected();
        this.insert((char)window.pendingKeys[window.pendingLength], 1);
    }

    public void insert(char ch, int count) {
        if (!this.lineMode) {
            try {
                while (--count >= 0) {
                    this.toInferior.write(ch);
                }
                this.toInferior.flush();
            }
            catch (Exception ex) {
                throw new WrappedException(ex);
            }
        } else {
            this.buffer.insert(ch, count);
        }
    }

    public void invoke(Runnable doRun) {
        this.buffer.invoke(doRun);
    }

    static {
        modeMap.defineKey("\n", (Object)enterAction);
        modeMap.defineKey("\r", (Object)enterAction);
        modeMap.defineKey("enter", (Object)enterAction);
        modeMap.defineKey("return", (Object)enterAction);
        ProcessInsertCommand insert = new ProcessInsertCommand();
        modeMap.set(32, 126, insert);
        modeMap.set(128, 255, insert);
    }
}

