/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.functions.AddOp;
import gnu.kawa.functions.ArithOp;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.functions.BitwiseOp;
import gnu.kawa.functions.DivideOp;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.mapping.Procedure;
import gnu.math.IntNum;

public class CompileArith
implements CanInline,
Inlineable {
    int op;
    Procedure proc;
    public static CompileArith $Pl = new CompileArith(AddOp.$Pl, 1);
    public static CompileArith $Mn = new CompileArith(AddOp.$Mn, 2);

    CompileArith(Object proc, int op) {
        this.proc = (Procedure)proc;
        this.op = op;
    }

    public static CompileArith forMul(Object proc) {
        return new CompileArith(proc, 3);
    }

    public static CompileArith forDiv(Object proc) {
        int op = ((DivideOp)proc).op == 4 ? 5 : 4;
        return new CompileArith(proc, op);
    }

    public static CompileArith forBitwise(Object proc) {
        return new CompileArith(proc, ((BitwiseOp)proc).op);
    }

    public boolean appropriateIntConstant(Expression[] args, int iarg) {
        Expression arg = args[iarg];
        if (arg instanceof QuoteExp) {
            QuoteExp qarg = (QuoteExp)arg;
            Object value = qarg.getValue();
            if (qarg.getRawType() == null && value instanceof IntNum && CompileArith.inRange((IntNum)value, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
                value = ((IntNum)value).intValue();
                args[iarg] = arg = new QuoteExp(value, Type.intType);
                return true;
            }
        }
        return false;
    }

    public boolean appropriateLongConstant(Expression[] args, int iarg) {
        Expression arg = args[iarg];
        if (arg instanceof QuoteExp) {
            QuoteExp qarg = (QuoteExp)arg;
            Object value = qarg.getValue();
            if (qarg.getRawType() == null && value instanceof IntNum && CompileArith.inRange((IntNum)value, Long.MIN_VALUE, Long.MAX_VALUE)) {
                value = ((IntNum)value).longValue();
                args[iarg] = arg = new QuoteExp(value, Type.longType);
                return true;
            }
        }
        return false;
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, boolean argsInlined) {
        exp.walkArgs(walker, argsInlined);
        Expression[] args = exp.getArgs();
        if (args.length > 2) {
            return CompileArith.pairwise(this.proc, exp.getFunction(), args, walker);
        }
        Expression folded = exp.inlineIfConstant(this.proc, walker);
        if (folded != exp) {
            return folded;
        }
        int rkind = 0;
        if (args.length == 2 || args.length == 1) {
            int kind1 = Arithmetic.classifyType(args[0].getType());
            if (args.length == 2 && (this.op < 6 || this.op > 9)) {
                int kind2 = Arithmetic.classifyType(args[1].getType());
                rkind = this.getReturnKind(kind1, kind2);
                if (rkind == 4) {
                    if (kind1 == 1 && this.appropriateIntConstant(args, 1)) {
                        rkind = 1;
                    } else if (kind2 == 1 && this.appropriateIntConstant(args, 0)) {
                        rkind = 1;
                    } else if (kind1 == 2 && this.appropriateLongConstant(args, 1)) {
                        rkind = 2;
                    } else if (kind2 == 2 && this.appropriateLongConstant(args, 0)) {
                        rkind = 2;
                    }
                }
            } else {
                rkind = kind1;
            }
            rkind = this.adjustReturnKind(rkind);
            exp.setType(Arithmetic.kindType(rkind));
        }
        if (!walker.getCompilation().mustCompile) {
            return exp;
        }
        switch (this.op) {
            case 1: 
            case 2: {
                return this.inlineAdd((AddOp)this.proc, exp, walker);
            }
            case 4: 
            case 5: {
                return CompileArith.inlineDiv((DivideOp)this.proc, exp, walker);
            }
            case 13: {
                if (rkind <= 0) break;
                return this.inlineNot(exp, rkind, walker);
            }
        }
        return exp;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Type wtype;
        Expression[] args = exp.getArgs();
        int len = args.length;
        if (len == 0) {
            comp.compileConstant(((ArithOp)this.proc).defaultResult(), target);
            return;
        }
        if (len == 1 || target instanceof IgnoreTarget) {
            ApplyExp.compile(exp, comp, target);
            return;
        }
        int kind1 = Arithmetic.classifyType(args[0].getType());
        int kind2 = Arithmetic.classifyType(args[1].getType());
        int kind = this.getReturnKind(kind1, kind2);
        Type type = Arithmetic.kindType(kind);
        if (kind == 0 || len != 2) {
            ApplyExp.compile(exp, comp, target);
            return;
        }
        Type targetType = target.getType();
        int tkind = Arithmetic.classifyType(targetType);
        if ((tkind == 1 || tkind == 2) && kind >= 1 && kind <= 4) {
            kind = tkind;
            wtype = tkind == 1 ? LangPrimType.intType : LangPrimType.longType;
        } else if ((tkind == 8 || tkind == 7) && kind > 2 && kind <= 10) {
            kind = tkind;
            wtype = tkind == 7 ? LangPrimType.floatType : LangPrimType.doubleType;
        } else if (kind == 7) {
            wtype = LangPrimType.floatType;
        } else if (kind == 8 || kind == 9) {
            kind = 8;
            wtype = LangPrimType.doubleType;
        } else {
            wtype = type;
        }
        if (this.op == 4 || this.op == 5) {
            DivideOp dproc = (DivideOp)this.proc;
            if (dproc.op != 0 || kind > 4 && kind < 6 && kind > 9) {
                if (dproc.op == 1 && kind <= 10 && kind != 7 || dproc.op == 0 && kind == 10) {
                    kind = 8;
                } else if ((dproc.op != 3 && (dproc.op != 2 || kind > 4) || dproc.getRoundingMode() != 3 && kind != 7 && kind != 8) && (dproc.op != 4 || dproc.getRoundingMode() != 3)) {
                    ApplyExp.compile(exp, comp, target);
                    return;
                }
            }
        }
        if (this.op == 4 && ((DivideOp)this.proc).op == 0 && kind <= 10 && kind != 8 && kind != 7) {
            Method meth;
            if (kind == 6 || kind > 4) {
                LangObjType ctype = kind == 6 ? Arithmetic.typeRatNum : Arithmetic.typeRealNum;
                wtype = ctype;
                meth = ctype.getDeclaredMethod("divide", 2);
            } else {
                wtype = Arithmetic.typeIntNum;
                meth = Arithmetic.typeRatNum.getDeclaredMethod("make", 2);
            }
            Target wtarget = StackTarget.getInstance(wtype);
            args[0].compile(comp, wtarget);
            args[1].compile(comp, wtarget);
            comp.getCode().emitInvokeStatic(meth);
        } else if (kind == 4 && (this.op == 1 || this.op == 3 || this.op == 2 || this.op == 10 || this.op == 11 || this.op == 12 || this.op >= 6 && this.op <= 8)) {
            this.compileIntNum(args[0], args[1], kind1, kind2, comp);
        } else if (kind == 1 || kind == 2 || (kind == 7 || kind == 8) && (this.op <= 5 || this.op >= 10)) {
            Target wtarget = StackTarget.getInstance(wtype);
            CodeAttr code = comp.getCode();
            block3: for (int i = 0; i < len; ++i) {
                if (i == 1 && this.op >= 6 && this.op <= 9) {
                    wtarget = StackTarget.getInstance(Type.intType);
                }
                args[i].compile(comp, wtarget);
                if (i == 0) continue;
                switch (kind) {
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: {
                        if (this.op == 6) {
                            Type[] margs = new Type[]{wtype, Type.intType};
                            Method method = ClassType.make("gnu.math.IntNum").getDeclaredMethod("shift", margs);
                            code.emitInvokeStatic(method);
                            continue block3;
                        }
                        code.emitBinop(this.primitiveOpcode(), (PrimType)wtype.getImplementationType());
                    }
                }
            }
        } else {
            ApplyExp.compile(exp, comp, target);
            return;
        }
        target.compileFromStack(comp, wtype);
    }

    static boolean inRange(Expression exp, int lo, int hi) {
        Object val = exp.valueIfConstant();
        return val instanceof IntNum && CompileArith.inRange((IntNum)val, (long)lo, (long)hi);
    }

    public static boolean inRange(IntNum val, long lo, long hi) {
        return IntNum.compare(val, lo) >= 0 && IntNum.compare(val, hi) <= 0;
    }

    public boolean compileIntNum(Expression arg1, Expression arg2, int kind1, int kind2, Compilation comp) {
        Type type2;
        Type type1;
        boolean swap;
        boolean addOrMul;
        if (this.op == 2 && arg2 instanceof QuoteExp) {
            boolean negateOk;
            long lval;
            Object val = arg2.valueIfConstant();
            if (kind2 <= 2) {
                lval = ((Number)val).longValue();
                negateOk = lval > Integer.MIN_VALUE && lval <= Integer.MAX_VALUE;
            } else if (val instanceof IntNum) {
                IntNum ival = (IntNum)val;
                lval = ival.longValue();
                negateOk = CompileArith.inRange(ival, -2147483647L, Integer.MAX_VALUE);
            } else {
                negateOk = false;
                lval = 0L;
            }
            if (negateOk) {
                return $Pl.compileIntNum(arg1, QuoteExp.getInstance((int)(-lval)), kind1, 1, comp);
            }
        }
        boolean bl = addOrMul = this.op == 1 || this.op == 3;
        if (addOrMul) {
            if (CompileArith.inRange(arg1, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
                kind1 = 1;
            }
            if (CompileArith.inRange(arg2, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
                kind2 = 1;
            }
            boolean bl2 = swap = kind1 == 1 && kind2 != 1;
            if (!(!swap || arg1.side_effects() && arg2.side_effects())) {
                return this.compileIntNum(arg2, arg1, kind2, kind1, comp);
            }
            type1 = kind1 == 1 ? Type.intType : Arithmetic.typeIntNum;
            type2 = kind2 == 1 ? Type.intType : Arithmetic.typeIntNum;
        } else if (this.op >= 6 && this.op <= 9) {
            type1 = Arithmetic.typeIntNum;
            type2 = Type.intType;
            swap = false;
        } else {
            type1 = type2 = Arithmetic.typeIntNum;
            swap = false;
        }
        arg1.compile(comp, type1);
        arg2.compile(comp, type2);
        CodeAttr code = comp.getCode();
        if (swap) {
            code.emitSwap();
            type1 = Arithmetic.typeIntNum;
            type2 = LangPrimType.intType;
        }
        String mname = null;
        Type[] argTypes = null;
        ObjectType mclass = Arithmetic.typeIntNum;
        switch (this.op) {
            case 1: {
                mname = "add";
                break;
            }
            case 2: {
                mname = "sub";
                break;
            }
            case 3: {
                mname = "times";
                break;
            }
            case 10: {
                mname = "and";
            }
            case 11: {
                if (mname == null) {
                    mname = "ior";
                }
            }
            case 12: {
                if (mname == null) {
                    mname = "xor";
                }
                mclass = ClassType.make("gnu.math.BitOps");
                break;
            }
            case 4: 
            case 5: {
                mname = this.op == 4 ? "quotient" : "remainder";
                DivideOp dproc = (DivideOp)this.proc;
                if (this.op == 5 && dproc.rounding_mode == 1) {
                    mname = "modulo";
                    break;
                }
                if (dproc.rounding_mode == 3) break;
                code.emitPushInt(dproc.rounding_mode);
                argTypes = new Type[]{type1, type2, Type.intType};
                break;
            }
            case 7: 
            case 8: {
                mname = this.op == 7 ? "shiftLeft" : "shiftRight";
                mclass = ClassType.make("gnu.kawa.functions.BitwiseOp");
                break;
            }
            case 6: {
                mname = "shift";
                break;
            }
            default: {
                throw new Error();
            }
        }
        if (argTypes == null) {
            argTypes = new Type[]{type1, type2};
        }
        Method meth = mclass.getMethod(mname, argTypes);
        code.emitInvokeStatic(meth);
        return true;
    }

    public int getReturnKind(int kind1, int kind2) {
        if (this.op >= 6 && this.op <= 9) {
            return kind1;
        }
        return kind1 <= 0 || kind1 > kind2 && kind2 > 0 ? kind1 : kind2;
    }

    public int getReturnKind(Expression[] args) {
        int len = args.length;
        if (len == 0) {
            return 4;
        }
        ClassType type = Type.pointer_type;
        int kindr = 0;
        for (int i = 0; i < len; ++i) {
            Expression arg = args[i];
            int kind = Arithmetic.classifyType(arg.getType());
            if (i != 0 && kind != 0 && kind <= kindr) continue;
            kindr = kind;
        }
        return kindr;
    }

    public Type getReturnType(Expression[] args) {
        return Arithmetic.kindType(this.adjustReturnKind(this.getReturnKind(args)));
    }

    int adjustReturnKind(int rkind) {
        if (this.op == 4 && rkind > 0) {
            DivideOp dproc = (DivideOp)this.proc;
            switch (dproc.op) {
                case 0: {
                    if (rkind > 4) break;
                    rkind = 6;
                    break;
                }
                case 1: {
                    if (rkind > 10 || rkind == 7) break;
                    rkind = 8;
                    break;
                }
                case 3: {
                    if (rkind > 10) break;
                    rkind = 4;
                }
            }
        }
        return rkind;
    }

    public Expression inlineAdd(AddOp proc, ApplyExp exp, InlineCalls walker) {
        Type type0;
        Expression[] args = exp.getArgs();
        if (args.length == 1 && proc.plusOrMinus < 0 && (type0 = args[0].getType()) instanceof PrimType) {
            char sig0 = type0.getSignature().charAt(0);
            PrimType type = null;
            int opcode = 0;
            if (sig0 != 'V' && sig0 != 'Z' && sig0 != 'C') {
                if (sig0 == 'D') {
                    opcode = 119;
                    type = LangPrimType.doubleType;
                } else if (sig0 == 'F') {
                    opcode = 118;
                    type = LangPrimType.floatType;
                } else if (sig0 == 'J') {
                    opcode = 117;
                    type = LangPrimType.longType;
                } else {
                    opcode = 116;
                    type = LangPrimType.intType;
                }
            }
            if (type != null) {
                PrimProcedure prim = PrimProcedure.makeBuiltinUnary(opcode, type);
                return new ApplyExp(prim, args);
            }
        }
        return exp;
    }

    public static Expression inlineDiv(DivideOp proc, ApplyExp exp, InlineCalls walker) {
        Expression[] args = exp.getArgs();
        if (args.length == 1) {
            args = new Expression[]{QuoteExp.getInstance(IntNum.one()), args[0]};
            exp = new ApplyExp(exp.getFunction(), args);
        }
        return exp;
    }

    public Expression inlineNot(ApplyExp exp, int kind, InlineCalls walker) {
        if (exp.getArgCount() == 1) {
            Expression arg = exp.getArg(0);
            if (kind == 1 || kind == 2) {
                Expression[] args = new Expression[]{arg, QuoteExp.getInstance(IntNum.minusOne())};
                return walker.walkApplyOnly(new ApplyExp(BitwiseOp.xor, args));
            }
            String cname = kind == 4 ? "gnu.math.BitOps" : (kind == 3 ? "java.meth.BigInteger" : null);
            if (cname != null) {
                return new ApplyExp(ClassType.make(cname).getDeclaredMethod("not", 1), exp.getArgs());
            }
        }
        return exp;
    }

    public int primitiveOpcode() {
        switch (this.op) {
            case 1: {
                return 96;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 104;
            }
            case 4: {
                return 108;
            }
            case 5: {
                return 112;
            }
            case 7: {
                return 120;
            }
            case 8: {
                return 122;
            }
            case 9: {
                return 124;
            }
            case 10: {
                return 126;
            }
            case 11: {
                return 128;
            }
            case 12: {
                return 130;
            }
        }
        return -1;
    }

    public static Expression pairwise(Procedure proc, Expression rproc, Expression[] args, InlineCalls walker) {
        int len = args.length;
        Expression prev = args[0];
        for (int i = 1; i < len; ++i) {
            Expression[] args2 = new Expression[]{prev, args[i]};
            ApplyExp next = new ApplyExp(rproc, args2);
            Expression inlined = walker.maybeInline(next, true, proc);
            prev = inlined != null ? inlined : next;
        }
        return prev;
    }
}

