/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.ImageLoader;
import gnu.jel.IntegerStack;
import gnu.jel.Library;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPcall;
import gnu.jel.OPcondtnl;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Stack;
import junit.framework.TestCase;

public class ClassFileExprTest
extends TestCase {
    ClassFile cf;
    Library lib;
    Object[] dynalib;
    byte[] image;
    LocalMethod[] eval_methods;
    ClassFile cf_orig;
    int retID_patchback;

    public ClassFileExprTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        LocalField[] lf = new LocalField[]{new LocalField(2, new Object[0].getClass(), "e", null)};
        Class[] stat = new Class[]{Class.forName("java.lang.Math")};
        Class[] dyn = new Class[]{Class.forName("java.lang.Double")};
        this.lib = new Library(stat, dyn, null, null, null);
        this.dynalib = new Object[1];
        this.dynalib[0] = new Double(100.0);
        this.image = null;
        int numPrimitives = 10;
        this.eval_methods = new LocalMethod[10];
        this.cf_orig = null;
        this.retID_patchback = 0;
        Class[] paramsE = new Class[]{new Object[0].getClass()};
        for (int i = 0; i < 9; ++i) {
            String name = "evaluate";
            Class<?> cls = OP.specialTypes[i];
            if (i != 8) {
                name = name + '_' + cls;
            } else {
                cls = new Object().getClass();
            }
            this.eval_methods[i] = new LocalMethod(1, cls, name, paramsE, null);
        }
        Class<?> cmplExpr = Class.forName("gnu.jel.CompiledExpression");
        this.cf = new ClassFile(1, "dump", cmplExpr, null, lf);
        LocalMethod cnstr = new LocalMethod(1, Void.TYPE, "<init>", null, null);
        this.cf.newMethod(cnstr, null);
        this.cf.code(42L);
        this.cf.noteStk(-1, 11);
        Constructor<?> supInit = cmplExpr.getConstructor(new Class[0]);
        this.cf.code(183L);
        this.cf.writeShort(this.cf.getIndex(supInit, 11));
        this.cf.noteStk(11, -1);
        this.cf.code(177L);
        LocalMethod getType = new LocalMethod(1, Integer.TYPE, "getType", null, null);
        this.cf.newMethod(getType, null);
        this.cf.code(16L);
        this.retID_patchback = this.cf.tsize;
        this.cf.code(8L);
        this.cf.noteStk(-1, 4);
        this.cf.code(172L);
        this.cf.noteStk(4, -1);
        this.cf_orig = this.cf.clone();
        this.cf.newMethod(this.eval_methods[8], null);
        this.cf.code(1L);
        this.cf.noteStk(-1, 11);
        this.cf.code(176L);
        this.cf.noteStk(11, -1);
        this.image = this.cf.getImage();
    }

    public void tearDown() throws Exception {
    }

    public void testExecTemplate() throws Throwable {
        CompiledExpression expr = (CompiledExpression)ImageLoader.load(this.image).newInstance();
        boolean ok = expr.getType() == 8 && expr.evaluate(null) == null;
        ClassFileExprTest.assertTrue(ok);
    }

    public void testExpr1() throws Throwable {
        ClassFileExprTest.exprMiniComp("1 (I)", this.dynalib, this.lib, new Integer(1), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr2() throws Throwable {
        ClassFileExprTest.exprMiniComp("1 (I)", this.dynalib, this.lib, new Integer(1), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr3() throws Throwable {
        ClassFileExprTest.exprMiniComp("1 -- (I)", this.dynalib, this.lib, new Integer(-1), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr4() throws Throwable {
        ClassFileExprTest.exprMiniComp("1 --", this.dynalib, this.lib, new Integer(-1), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr5() throws Throwable {
        ClassFileExprTest.exprMiniComp("1L --", this.dynalib, this.lib, new Long(-1L), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr6() throws Throwable {
        for (byte i = 0; i <= 6; i = (byte)(i + 1)) {
            ClassFileExprTest.exprMiniComp(String.valueOf(i), this.dynalib, this.lib, new Byte(i), this.cf_orig, this.retID_patchback, this.eval_methods, false);
            ClassFileExprTest.exprMiniComp(String.valueOf(i) + 'L', this.dynalib, this.lib, new Long(i), this.cf_orig, this.retID_patchback, this.eval_methods, false);
        }
    }

    public void testExpr7() throws Throwable {
        for (int i = 0; i <= 3; i = (int)((byte)(i + 1))) {
            ClassFileExprTest.exprMiniComp(String.valueOf(i) + ".0F", this.dynalib, this.lib, new Float(i), this.cf_orig, this.retID_patchback, this.eval_methods, false);
            ClassFileExprTest.exprMiniComp(String.valueOf(i) + ".0", this.dynalib, this.lib, new Double(i), this.cf_orig, this.retID_patchback, this.eval_methods, false);
        }
    }

    public void testExpr8() throws Throwable {
        ClassFileExprTest.exprMiniComp("true", this.dynalib, this.lib, Boolean.TRUE, this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr9() throws Throwable {
        ClassFileExprTest.exprMiniComp("false", this.dynalib, this.lib, Boolean.FALSE, this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr10() throws Throwable {
        for (int i = 126; i <= 128; ++i) {
            ClassFileExprTest.exprMiniComp(String.valueOf(i) + " (I)", this.dynalib, this.lib, new Integer(i), this.cf_orig, this.retID_patchback, this.eval_methods, false);
            ClassFileExprTest.exprMiniComp(String.valueOf(i) + " -- (I)", this.dynalib, this.lib, new Integer(-i), this.cf_orig, this.retID_patchback, this.eval_methods, false);
        }
    }

    public void testExpr11() throws Throwable {
        ClassFileExprTest.exprMiniComp("( 1 , 2 , min)", this.dynalib, this.lib, new Integer(1), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr12() throws Throwable {
        ClassFileExprTest.exprMiniComp("( ( E) , sin)", this.dynalib, this.lib, new Double(Math.sin(Math.E)), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr13() throws Throwable {
        ClassFileExprTest.exprMiniComp("2 , 2 , *", this.dynalib, this.lib, new Integer(4), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr14() throws Throwable {
        ClassFileExprTest.exprMiniComp("3 , 2 , * , 1 , -", this.dynalib, this.lib, new Integer(5), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr15() throws Throwable {
        ClassFileExprTest.exprMiniComp("3 , 2 , * , 1 , - , 3 , - , 2 , *", this.dynalib, this.lib, new Integer(4), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr16() throws Throwable {
        ClassFileExprTest.exprMiniComp("3 , 2 , * , 1 , - , 3 , - , 2 , * , 4 , ==", this.dynalib, this.lib, Boolean.TRUE, this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr17() throws Throwable {
        ClassFileExprTest.exprMiniComp("\"a\" , \"b\" , + , 4 , + , true , +", this.dynalib, this.lib, "ab4true", this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr18() throws Throwable {
        ClassFileExprTest.exprMiniComp("2 , 3 , > , 3 , 2 , >= , ||", this.dynalib, this.lib, Boolean.TRUE, this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr19() throws Throwable {
        ClassFileExprTest.exprMiniComp("( isNaN)", this.dynalib, this.lib, Boolean.FALSE, this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr20() throws Throwable {
        ClassFileExprTest.exprMiniComp("1 , ( doubleValue) , + , 101 , ==", this.dynalib, this.lib, Boolean.TRUE, this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr21() throws Throwable {
        ClassFileExprTest.exprMiniComp("( true ? 1 : 2 ) (I)", this.dynalib, this.lib, new Integer(1), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr22() throws Throwable {
        ClassFileExprTest.exprMiniComp("( false ? 1 : 2 ) (I)", this.dynalib, this.lib, new Integer(2), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr23() throws Throwable {
        ClassFileExprTest.exprMiniComp("( false ? 1 : 2 , 2 , + ) (I)", this.dynalib, this.lib, new Integer(4), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    public void testExpr24() throws Throwable {
        ClassFileExprTest.exprMiniComp("( true ? ( 1 , 3 , + , 5 , min) : 2 ) (I)", this.dynalib, this.lib, new Integer(4), this.cf_orig, this.retID_patchback, this.eval_methods, false);
    }

    private static void exprMiniComp(String expr, Object[] thisPtrs, Library lib, Object expRes, ClassFile cf_orig, int retID_patchback, LocalMethod[] eval_methods, boolean verbose) throws Throwable {
        int cChar;
        StringBuffer testTitle = new StringBuffer();
        for (int i = 0; i < expr.length(); ++i) {
            if (expr.charAt(i) == ' ') continue;
            testTitle.append(expr.charAt(i));
        }
        testTitle.append(" == ");
        int id = OP.typeIDObject(expRes);
        if (id < 8) {
            testTitle.append(expRes);
            testTitle.append(id > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(id));
        } else if (expRes instanceof String) {
            testTitle.append('\"');
            testTitle.append(expRes);
            testTitle.append('\"');
        } else {
            testTitle.append(expRes);
        }
        Stack<OP> paramOPs = new Stack<OP>();
        IntegerStack paramsStart = new IntegerStack();
        Stack oldLists = new Stack();
        IntegerStack branchStack = new IntegerStack();
        StringReader sr = new StringReader(expr);
        StringBuffer cToken = new StringBuffer();
        block55: while ((cChar = sr.read()) > 0) {
            while ((char)cChar == ' ' && (cChar = sr.read()) > 0) {
            }
            cToken.setLength(0);
            while (cChar > 0 && (char)cChar != ' ') {
                cToken.append((char)cChar);
                cChar = sr.read();
            }
            if (cToken.length() <= 0) continue;
            char cTok = cToken.charAt(0);
            switch (cTok) {
                case '~': {
                    paramOPs.push(new OPunary(paramOPs, 1));
                    break;
                }
                case ',': {
                    break;
                }
                case '(': {
                    if (cToken.length() == 1) {
                        paramsStart.push(paramOPs.size());
                        break;
                    }
                    if (cToken.length() == 3) {
                        int tid;
                        char ttype = cToken.charAt(1);
                        char[] primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'L', 'V', 'L', 'L'};
                        for (tid = 0; tid < primitiveCodes.length && ttype != primitiveCodes[tid]; ++tid) {
                        }
                        paramOPs.push(new OPunary(paramOPs, tid, null, true));
                        break;
                    }
                    System.err.println("Wrong bracketed token \"" + cToken + "\".");
                    break;
                }
                case '?': {
                    break;
                }
                case ':': {
                    break;
                }
                case ')': {
                    paramOPs.push(new OPcondtnl(paramOPs));
                    break;
                }
                case '+': {
                    paramOPs.push(new OPbinary(paramOPs, 0));
                    break;
                }
                case '-': {
                    if (cToken.length() == 1) {
                        paramOPs.push(new OPbinary(paramOPs, 1));
                        break;
                    }
                    if (cToken.length() == 2 && cToken.charAt(1) == '-') {
                        paramOPs.push(new OPunary(paramOPs, 0));
                        break;
                    }
                    System.err.println("Wrong token \"" + cTok + "\".");
                    break;
                }
                case '*': {
                    paramOPs.push(new OPbinary(paramOPs, 2));
                    break;
                }
                case '/': {
                    paramOPs.push(new OPbinary(paramOPs, 3));
                    break;
                }
                case '%': {
                    paramOPs.push(new OPbinary(paramOPs, 4));
                    break;
                }
                case '^': {
                    paramOPs.push(new OPbinary(paramOPs, 7));
                    break;
                }
                case '=': {
                    if (cToken.charAt(1) != '=') continue block55;
                    paramOPs.push(new OPbinary(paramOPs, 8));
                    break;
                }
                case '!': {
                    if (cToken.length() == 1) {
                        paramOPs.push(new OPunary(paramOPs, 2));
                        break;
                    }
                    if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                        paramOPs.push(new OPbinary(paramOPs, 9));
                        break;
                    }
                    System.err.println("Wrong ! token \"" + cTok + "\".");
                    break;
                }
                case '<': {
                    if (cToken.length() == 1) {
                        paramOPs.push(new OPbinary(paramOPs, 10));
                        break;
                    }
                    if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                        paramOPs.push(new OPbinary(paramOPs, 13));
                        break;
                    }
                    if (cToken.length() == 2 && cToken.charAt(1) == '<') {
                        paramOPs.push(new OPbinary(paramOPs, 14));
                        break;
                    }
                    System.err.println("Wrong < token \"" + cTok + "\".");
                    break;
                }
                case '>': {
                    if (cToken.length() == 1) {
                        paramOPs.push(new OPbinary(paramOPs, 11));
                        break;
                    }
                    if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                        paramOPs.push(new OPbinary(paramOPs, 12));
                        break;
                    }
                    if (cToken.length() == 2 && cToken.charAt(1) == '>') {
                        paramOPs.push(new OPbinary(paramOPs, 15));
                        break;
                    }
                    if (cToken.length() == 3 && cToken.charAt(2) == '>') {
                        paramOPs.push(new OPbinary(paramOPs, 16));
                        break;
                    }
                    System.err.println("Wrong > token \"" + cTok + "\".");
                    break;
                }
                case '&': {
                    if (cToken.length() == 1) {
                        paramOPs.push(new OPbinary(paramOPs, 5));
                        break;
                    }
                    if (cToken.length() == 3 && cToken.charAt(1) == '&') {
                        paramOPs.push(new OPbinary(paramOPs, 17));
                        break;
                    }
                    System.err.println("Wrong & token \"" + cTok + "\".");
                    break;
                }
                case '|': {
                    if (cToken.length() == 1) {
                        paramOPs.push(new OPbinary(paramOPs, 6));
                        break;
                    }
                    if (cToken.length() == 2 && cToken.charAt(1) == '|') {
                        paramOPs.push(new OPbinary(paramOPs, 18));
                        break;
                    }
                    System.err.println("Wrong | token \"" + cTok + "\".");
                    break;
                }
                case '[': {
                    if (cToken.length() == 3 && cToken.charAt(1) == ']') {
                        paramOPs.push(new OPbinary(paramOPs, 19));
                        break;
                    }
                    System.err.println("Wrong [ token \"" + cTok + "\".");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Class<Number> otlc;
                    Number otl;
                    String sval = cToken.toString();
                    if (sval.indexOf(46) > 0) {
                        char lc = Character.toUpperCase(sval.charAt(sval.length() - 1));
                        boolean makeFloat = lc == 'F';
                        String svalue = sval;
                        if (lc == 'D' || lc == 'F') {
                            svalue = svalue.substring(0, svalue.length() - 1);
                        }
                        Double value = null;
                        try {
                            value = new Double(svalue);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Can;t parse \"" + svalue + "\" as a floating point number.");
                        }
                        otl = null;
                        otlc = null;
                        if (makeFloat) {
                            otl = new Float(value.floatValue());
                            otlc = Float.TYPE;
                        } else {
                            otl = value;
                            otlc = Double.TYPE;
                        }
                        paramOPs.push(new OPload(otl));
                        break;
                    }
                    String svalue = sval.toUpperCase();
                    long value = 0L;
                    boolean makelong = svalue.endsWith("L");
                    if (makelong) {
                        svalue = svalue.substring(0, svalue.length() - 1);
                    }
                    try {
                        if (svalue.startsWith("0X")) {
                            svalue = svalue.substring(2);
                            value = Long.parseLong(svalue, 16);
                        } else {
                            value = svalue.startsWith("0") ? Long.parseLong(svalue, 8) : Long.parseLong(svalue, 10);
                        }
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Number \"" + svalue + "\" is too large, it does not fit even " + "into 64 bit long.");
                    }
                    otl = null;
                    otlc = null;
                    if (!makelong) {
                        if (value <= 127L) {
                            otl = new Byte((byte)value);
                            otlc = Byte.TYPE;
                        } else if (value <= 32767L) {
                            otl = new Short((short)value);
                            otlc = Short.TYPE;
                        } else if (value <= Integer.MAX_VALUE) {
                            otl = new Integer((int)value);
                            otlc = Integer.TYPE;
                        } else {
                            System.err.println("Integer number \"" + svalue + "\" is too large for type 'int'. Be sure" + " to add 'L' suffix to use 'long' type.");
                        }
                    } else {
                        otl = new Long(value);
                        otlc = Long.TYPE;
                    }
                    paramOPs.push(new OPload(otl));
                    break;
                }
                case '\'': {
                    String sval = cToken.toString().substring(1, cToken.length() - 1);
                    int chr = sval.charAt(0);
                    if (sval.length() != 1) {
                        int ec = sval.charAt(1);
                        try {
                            switch (ec) {
                                case 110: {
                                    ec = 10;
                                    break;
                                }
                                case 116: {
                                    ec = 9;
                                    break;
                                }
                                case 98: {
                                    ec = 8;
                                    break;
                                }
                                case 114: {
                                    ec = 13;
                                    break;
                                }
                                case 102: {
                                    ec = 12;
                                    break;
                                }
                                case 92: {
                                    ec = 92;
                                    break;
                                }
                                case 39: {
                                    ec = 39;
                                    break;
                                }
                                case 34: {
                                    ec = 34;
                                    break;
                                }
                                default: {
                                    ec = (char)Integer.parseInt(sval.substring(1), 8);
                                    break;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Can;t parse \"" + cToken + "\" as a character literal.");
                        }
                        chr = ec;
                    }
                    paramOPs.push(new OPload(new Character((char)chr)));
                    break;
                }
                case '\"': {
                    String sval = cToken.toString().substring(1, cToken.length() - 1);
                    StringBuffer unescaped = new StringBuffer(sval.length());
                    for (int i = 0; i < sval.length(); ++i) {
                        int ec = sval.charAt(i);
                        if (ec == 92) {
                            ec = sval.charAt(++i);
                            switch (ec) {
                                case 110: {
                                    ec = 10;
                                    break;
                                }
                                case 116: {
                                    ec = 9;
                                    break;
                                }
                                case 98: {
                                    ec = 8;
                                    break;
                                }
                                case 114: {
                                    ec = 13;
                                    break;
                                }
                                case 102: {
                                    ec = 12;
                                    break;
                                }
                                case 92: {
                                    ec = 92;
                                    break;
                                }
                                case 39: {
                                    ec = 39;
                                    break;
                                }
                                case 34: {
                                    ec = 34;
                                    break;
                                }
                                default: {
                                    int nval = 0;
                                    while (i < sval.length()) {
                                        char c = sval.charAt(i);
                                        ec = c;
                                        if (c < '0' || ec > 55) break;
                                        nval <<= 3 + (ec - 48);
                                        ++i;
                                    }
                                    --i;
                                    ec = (char)nval;
                                }
                            }
                        }
                        unescaped.append((char)ec);
                    }
                    paramOPs.push(new OPload(unescaped.toString()));
                    break;
                }
                default: {
                    if (cToken.toString().equals("true")) {
                        paramOPs.push(new OPload(Boolean.TRUE));
                        break;
                    }
                    if (cToken.toString().equals("false")) {
                        paramOPs.push(new OPload(Boolean.FALSE));
                        break;
                    }
                    cToken.setLength(cToken.length() - 1);
                    int ps = paramsStart.pop();
                    int np = paramOPs.size() - ps;
                    Class[] params = new Class[np];
                    OP[] paramsOPs = new OP[np];
                    for (int i = np - 1; i >= 0; --i) {
                        paramsOPs[i] = paramOPs.pop();
                        params[i] = paramsOPs[i].resType;
                    }
                    Member m = null;
                    try {
                        m = lib.getMember(null, cToken.toString(), params);
                    }
                    catch (CompilationException exc) {
                        System.err.println("Can't find method \"" + cToken + "\".");
                    }
                    if ((m.getModifiers() & 8) == 0) {
                        paramOPs.push(new OPcall(1, new Object[0].getClass()));
                        int classID = lib.getDynamicMethodClassID(m);
                        paramOPs.push(new OPload(new Integer(classID)));
                        paramOPs.push(new OPbinary(paramOPs, 19));
                    }
                    for (int i = 0; i < np; ++i) {
                        paramOPs.push(paramsOPs[i]);
                    }
                    paramOPs.push(new OPcall(paramOPs, m, false));
                }
            }
        }
        if (((OP)paramOPs.peek()).resID == 10) {
            paramOPs.push(new OPunary(paramOPs, 11, null, false));
        }
        OP rop = (OP)paramOPs.peek();
        int retID = rop.resID > 9 ? 8 : rop.resID;
        Class retType = rop.resType;
        paramOPs.push(new OPunary(paramOPs, 3));
        if (paramOPs.size() != 1) {
            System.err.println("Extra paramOPs left in stack when compiling.");
        }
        OP program = paramOPs.pop();
        String name = "evaluate";
        if (retID != 8) {
            name = name + '_' + retType;
        }
        boolean ok = true;
        for (int i = 0; i < 2; ++i) {
            boolean localOK;
            if (verbose) {
                System.out.print(ClassFileExprTest.toStr(program));
            }
            ClassFile cf = cf_orig.clone();
            int otsize = cf.tsize;
            cf.tsize = retID_patchback;
            cf.write(retID);
            cf.tsize = otsize;
            cf.newMethod(eval_methods[retID], null);
            program.compile(cf);
            byte[] image = cf.getImage();
            CompiledExpression cexpr = (CompiledExpression)ImageLoader.load(image).newInstance();
            Object res = cexpr.evaluate(thisPtrs);
            boolean bl = localOK = expRes == null && expRes == res || expRes.equals(res);
            if (verbose) {
                System.out.print(" == ");
                System.out.print(res);
                System.out.print("  ");
                if (localOK) {
                    System.out.print("ok.");
                } else {
                    System.out.print("WRONG !!!");
                }
                System.out.println("");
            }
            ok = ok && localOK;
            try {
                program = new OPload(program, program.eval());
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        ClassFileExprTest.assertTrue(testTitle.toString(), ok);
        if (!(ok | verbose)) {
            ClassFileExprTest.exprMiniComp(expr, thisPtrs, lib, expRes, cf_orig, retID_patchback, eval_methods, true);
        }
    }

    public static String toStr(OP o) {
        if (o instanceof OPload) {
            OPload op = (OPload)o;
            if (op.resID == 8) {
                return "\"" + op.what + "\"";
            }
            return op.what.toString() + (op.resID > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(op.resID));
        }
        if (o instanceof OPbinary) {
            String[] opSymbols = new String[]{"+", "-", "*", "/", "%", "&", "|", "^", "==", "!=", "<", ">=", ">", "<=", "<<", ">>", ">>>", "&&", "||", "{}", ".+."};
            OPbinary op = (OPbinary)o;
            return ClassFileExprTest.toStr(op.chi[0]) + opSymbols[op.code] + ClassFileExprTest.toStr(op.chi[1]);
        }
        if (o instanceof OPunary) {
            String[] opSymbols = new String[]{"--", "~", "!", "<RET>", "(Z)", "(B)", "(C)", "(S)", "(I)", "(J)", "(F)", "(D)", "(L)", "(POP)", "->TSB", "->STR"};
            OPunary op = (OPunary)o;
            return opSymbols[op.code] + ClassFileExprTest.toStr(op.chi[0]);
        }
        if (o instanceof OPcall) {
            OPcall op = (OPcall)o;
            if (op.m == null) {
                return "{" + op.nplv + "}";
            }
            StringBuffer res = new StringBuffer(op.m.getName());
            res.append('(');
            for (int i = 0; i < op.chi.length; ++i) {
                if (i > 0) {
                    res.append(",");
                }
                res.append(ClassFileExprTest.toStr(op.chi[i]));
            }
            res.append(')');
            return res.toString();
        }
        if (o instanceof OPcondtnl) {
            OPcondtnl op = (OPcondtnl)o;
            StringBuffer res = new StringBuffer();
            if (op.chi[1] != null) {
                res.append('(');
            }
            res.append(ClassFileExprTest.toStr(op.chi[0]));
            if (op.chi[1] != null) {
                res.append('?');
                res.append(ClassFileExprTest.toStr(op.chi[1]));
                res.append(':');
                res.append(ClassFileExprTest.toStr(op.chi[2]));
                res.append(')');
            }
            return res.toString();
        }
        return "<<<<<OP TYPE NOT IDENTIFIED>>>>";
    }

    public static void dumpImage(ClassFile cf) throws Exception {
        FileOutputStream fos = new FileOutputStream("dump.class");
        fos.write(cf.getImage());
        fos.close();
    }
}

