/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.Environment;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.tests.AbstractTest;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TechnologyTest
extends AbstractTest {
    public TechnologyTest(String testName) {
        super(testName);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new TechnologyTest("artwork"));
        list.add(new TechnologyTest("bicmos"));
        list.add(new TechnologyTest("bipolar"));
        list.add(new TechnologyTest("cmos"));
        list.add(new TechnologyTest("efido"));
        list.add(new TechnologyTest("fpga"));
        list.add(new TechnologyTest("gem"));
        list.add(new TechnologyTest("mocmos_deep_5_1"));
        list.add(new TechnologyTest("mocmos_deep_5_1_a"));
        list.add(new TechnologyTest("mocmos_deep_5_2"));
        list.add(new TechnologyTest("mocmos_deep_6_1"));
        list.add(new TechnologyTest("mocmos_deep_6_2"));
        list.add(new TechnologyTest("mocmos_deep_6_2_s"));
        list.add(new TechnologyTest("mocmos_scmos_2_1"));
        list.add(new TechnologyTest("mocmos_scmos_2_1_a"));
        list.add(new TechnologyTest("mocmos_scmos_2_2"));
        list.add(new TechnologyTest("mocmos_scmos_3_1"));
        list.add(new TechnologyTest("mocmos_scmos_3_2"));
        list.add(new TechnologyTest("mocmos_scmos_4_1"));
        list.add(new TechnologyTest("mocmos_scmos_4_2"));
        list.add(new TechnologyTest("mocmos_scmos_4_2_s"));
        list.add(new TechnologyTest("mocmos_sub_2_1"));
        list.add(new TechnologyTest("mocmos_sub_2_1_a"));
        list.add(new TechnologyTest("mocmos_sub_2_2"));
        list.add(new TechnologyTest("mocmos_sub_3_1"));
        list.add(new TechnologyTest("mocmos_sub_3_2"));
        list.add(new TechnologyTest("mocmos_sub_4_1"));
        list.add(new TechnologyTest("mocmos_sub_4_2"));
        list.add(new TechnologyTest("mocmos_sub_5_1"));
        list.add(new TechnologyTest("mocmos_sub_5_2"));
        list.add(new TechnologyTest("mocmos_sub_6_1"));
        list.add(new TechnologyTest("mocmos_sub_6_1_a"));
        list.add(new TechnologyTest("mocmos_sub_6_2"));
        list.add(new TechnologyTest("mocmos_sub_6_2_s"));
        list.add(new TechnologyTest("mocmos_scna"));
        list.add(new TechnologyTest("mocmosold"));
        list.add(new TechnologyTest("mocmossub"));
        list.add(new TechnologyTest("nmos"));
        list.add(new TechnologyTest("pcb"));
        list.add(new TechnologyTest("rcmos"));
        list.add(new TechnologyTest("schematic"));
        list.add(new TechnologyTest("tft"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Database/output/";
    }

    public Boolean artwork() {
        return this.basicTest(this.getRegressionPath(), "artwork", "artwork");
    }

    public Boolean bicmos() {
        return this.basicTest(this.getRegressionPath(), "bicmos", "bicmos");
    }

    public Boolean bipolar() {
        return this.basicTest(this.getRegressionPath(), "bipolar", "bipolar");
    }

    public Boolean cmos() {
        return this.basicTest(this.getRegressionPath(), "cmos", "cmos");
    }

    public Boolean efido() {
        return this.basicTest(this.getRegressionPath(), "efido", "efido");
    }

    public Boolean fpga() {
        return this.basicTest(this.getRegressionPath(), "fpga", "fpga");
    }

    public Boolean gem() {
        return this.basicTest(this.getRegressionPath(), "gem", "gem");
    }

    public Boolean mocmos_deep_5_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_deep_5_1_sf_af");
    }

    public Boolean mocmos_deep_5_1_a() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_deep_5_1_sf_at");
    }

    public Boolean mocmos_deep_5_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_deep_5_2_sf_af");
    }

    public Boolean mocmos_deep_6_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_deep_6_1_sf_af");
    }

    public Boolean mocmos_deep_6_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_deep_6_2_sf_af");
    }

    public Boolean mocmos_deep_6_2_s() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_deep_6_2_st_af");
    }

    public Boolean mocmos_scmos_2_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_2_1_sf_af");
    }

    public Boolean mocmos_scmos_2_1_a() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_2_1_sf_at");
    }

    public Boolean mocmos_scmos_2_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_2_2_sf_af");
    }

    public Boolean mocmos_scmos_3_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_3_1_sf_af");
    }

    public Boolean mocmos_scmos_3_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_3_2_sf_af");
    }

    public Boolean mocmos_scmos_4_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_4_1_sf_af");
    }

    public Boolean mocmos_scmos_4_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_4_2_sf_af");
    }

    public Boolean mocmos_scmos_4_2_s() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scmos_4_2_st_af");
    }

    public Boolean mocmos_sub_2_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_2_1_sf_af");
    }

    public Boolean mocmos_sub_2_1_a() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_2_1_sf_at");
    }

    public Boolean mocmos_sub_2_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_2_2_sf_af");
    }

    public Boolean mocmos_sub_3_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_3_1_sf_af");
    }

    public Boolean mocmos_sub_3_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_3_2_sf_af");
    }

    public Boolean mocmos_sub_4_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_4_1_sf_af");
    }

    public Boolean mocmos_sub_4_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_4_2_sf_af");
    }

    public Boolean mocmos_sub_5_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_5_1_sf_af");
    }

    public Boolean mocmos_sub_5_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_5_2_sf_af");
    }

    public Boolean mocmos_sub_6_1() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_6_1_sf_af");
    }

    public Boolean mocmos_sub_6_1_a() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_6_1_sf_at");
    }

    public Boolean mocmos_sub_6_2() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_6_2_sf_af");
    }

    public Boolean mocmos_sub_6_2_s() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_sub_6_2_st_af");
    }

    public Boolean mocmos_scna() {
        return this.basicTest(this.getRegressionPath(), "mocmos", "mocmos_scna");
    }

    public Boolean mocmosold() {
        return this.basicTest(this.getRegressionPath(), "mocmosold", "mocmosold");
    }

    public Boolean mocmossub() {
        return this.basicTest(this.getRegressionPath(), "mocmossub", "mocmossub");
    }

    public Boolean nmos() {
        return this.basicTest(this.getRegressionPath(), "nmos", "nmos");
    }

    public Boolean pcb() {
        return this.basicTest(this.getRegressionPath(), "pcb", "pcb");
    }

    public Boolean rcmos() {
        return this.basicTest(this.getRegressionPath(), "rcmos", "rcmos");
    }

    public Boolean schematic() {
        return this.basicTest(this.getRegressionPath(), "schematic", "schematic");
    }

    public Boolean tft() {
        return this.basicTest(this.getRegressionPath(), "tft", "tft");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean basicTest(String rootPath, String techName, String testName) {
        Environment savedEnvironment = Environment.setThreadEnvironment(null);
        try {
            Boolean bl = TechnologyTest.basicTechnologyTest(rootPath, techName, testName);
            return bl;
        }
        finally {
            Environment.setThreadEnvironment(savedEnvironment);
        }
    }

    private static boolean basicTechnologyTest(String rootPath, String techName, String testName) {
        String trueRootPath = TechnologyTest.getValidRootPath(rootPath, "/tools/Database/", "");
        String outputDir = trueRootPath + "output/";
        TechnologyTest.ensureOutputDirectory(outputDir);
        try {
            String fileName = trueRootPath + "data/projsettings_" + testName + ".xml";
            ProjSettings projSettings = ProjSettings.read(new File(fileName));
            if (projSettings == null) {
                System.out.println("Error: can't open '" + fileName + "'");
                return false;
            }
            TechFactory techFactory = TechFactory.getKnownTechs().get(techName);
            if (techFactory == null) {
                System.out.println("Error: no factory for technology " + techName);
                return false;
            }
            HashMap<TechFactory.Param, Object> paramValues = new HashMap<TechFactory.Param, Object>();
            for (TechFactory.Param param2 : techFactory.getTechParams()) {
                Object value = projSettings.getValue(param2.xmlPath);
                if (value == null) continue;
                paramValues.put(param2, value);
            }
            HashMap<Object, Map<String, Object>> additionalAttributes = new HashMap<Object, Map<String, Object>>();
            Xml.Technology xmlTech = techFactory.getXml(paramValues, additionalAttributes);
            if (!TechnologyTest.checkXml(trueRootPath, testName, xmlTech, additionalAttributes)) {
                return false;
            }
            IdManager idManager = new IdManager();
            Generic generic = Generic.newInstance(idManager);
            Technology tech0 = techFactory.newInstance(generic, paramValues);
            if (!TechnologyTest.checkSettings(trueRootPath, techName, tech0)) {
                return false;
            }
            if (!TechnologyTest.checkDump(trueRootPath, testName, tech0, projSettings)) {
                return false;
            }
            if (!TechnologyTest.checkXml(trueRootPath, testName, tech0)) {
                return false;
            }
            Technology tech1 = techFactory.newInstance(generic);
            Technology tech2 = tech1.withTechParams(paramValues);
            if (!TechnologyTest.checkSettings(trueRootPath, techName, tech1)) {
                return false;
            }
            if (!TechnologyTest.checkSettings(trueRootPath, techName, tech2)) {
                return false;
            }
            if (!TechnologyTest.checkDump(trueRootPath, testName, tech2, projSettings)) {
                return false;
            }
            return TechnologyTest.checkXml(trueRootPath, testName, tech2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkDump(String rootPath, String testName, Technology tech, ProjSettings projSettings) throws IOException {
        HashMap<Setting, Object> settingValues = new HashMap<Setting, Object>();
        for (Setting setting : tech.getProjectSettings().getSettings()) {
            Object value = projSettings.getValue(setting.getXmlPath());
            if (value == null) {
                value = setting.getFactoryValue();
            }
            settingValues.put(setting, value);
        }
        String fileName = testName + ".txt";
        File dumpFile = new File(rootPath + "output/" + fileName);
        dumpFile.delete();
        PrintWriter out = new PrintWriter(dumpFile);
        tech.dump(out, settingValues);
        out.close();
        System.out.println("Wrote tech dump to " + dumpFile);
        return TechnologyTest.equal(rootPath, fileName);
    }

    private static boolean checkXml(String rootPath, String testName, Technology tech) throws IOException {
        HashMap<Object, Map<String, Object>> additionalAttributes = new HashMap<Object, Map<String, Object>>();
        Xml.Technology techXml = tech.makeXml(additionalAttributes);
        return TechnologyTest.checkXml(rootPath, testName, techXml, additionalAttributes);
    }

    private static boolean checkXml(String rootPath, String testName, Xml.Technology techXml, Map<Object, Map<String, Object>> additionalAttributes) {
        String fileName = testName + ".xml";
        File dumpFile = new File(rootPath + "output/" + fileName);
        dumpFile.delete();
        techXml.writeXml(dumpFile.getPath(), false, null, additionalAttributes);
        System.out.println("Wrote Xml tech dump to " + dumpFile);
        return TechnologyTest.equal(rootPath, fileName);
    }

    private static boolean checkSettings(String rootPath, String techName, Technology tech) throws IOException {
        ProjSettings ps = new ProjSettings();
        for (Setting setting : tech.getProjectSettings().getSettings()) {
            ps.putValue(setting.getXmlPath(), setting.getFactoryValue());
        }
        return TechnologyTest.check(rootPath, techName + ".set", ps);
    }

    private static boolean check(String rootPath, String fileName, ProjSettings ps) {
        File prefFile = new File(rootPath + "output/" + fileName);
        prefFile.delete();
        ps.write(prefFile.toString());
        return TechnologyTest.equal(rootPath, fileName);
    }

    private static boolean equal(String rootPath, String fileName) {
        String resultFile = rootPath + "output/" + fileName;
        String expectedFile = rootPath + "data/expected/" + fileName;
        return TechnologyTest.compareResults(resultFile, expectedFile);
    }
}

