/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.memory.MemoryUsage;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class IOTool
extends Tool {
    private static IOTool tool = new IOTool();
    public static final Variable.Key IO_TRUE_LIBRARY;
    private static boolean skillChecked;
    private static Class<?> skillClass;
    private static Method skillOutputMethod;
    private static boolean calibreDRVChecked;
    private static Class<?> calibreDRVClass;
    private static Method calibreDRVInputMethod;
    private static boolean pnrChecked;
    private static Class<?> pnrClass;
    private static Method pnrOutputMethod;
    private static boolean daisChecked;
    private static Class<?> daisClass;
    private static Method daisInputMethod;
    private static Pref cacheBackupRedundancy;
    private static Pref cachePlotArea;
    private static Pref cachePlotDate;
    private static Pref cachePrinterName;
    private static Pref cacheCIFInSquaresWires;
    private static Pref cacheDEFLogicalPlacement;
    private static Pref cacheDEFPhysicalPlacement;
    private static Pref cacheDEFIgnorePhysicalInNets;
    private static Pref cacheDEFIgnoreLogicalInSpecialNets;
    private static Pref cacheDEFUsePureLayerNodes;
    private static Pref cacheDEFMakeDummyCells;
    private static Pref cacheDEFIgnoreUngeneratedPins;
    private static Pref cacheDEFIgnoreViasBlock;
    private static Pref cacheDEFConnectByGDSNames;
    public static final int DEFLEFUNKNOWNLAYERIGNORE = 0;
    public static final int DEFLEFUNKNOWNLAYERUSEDRC = 1;
    private static Pref cacheDEFInUnknownLayerHandling;
    private static Pref cacheLEFInUnknownLayerHandling;
    private static Pref cacheLEFIgnoreUngeneratedPins;
    private static Pref cacheLEFIgnoreTechnology;
    private static Pref cacheGDSInMergesBoxes;
    private static Pref cacheGDSWritesEntireLibrary;
    private static Pref cacheGDSFlatDesign;
    private static Pref cacheGDSOnlyVisible;
    private static Pref cacheGDSIncludesText;
    private static Pref cacheGDSInExpandsCells;
    private static Pref cacheGDSInInstantiatesArrays;
    public static final int GDSUNKNOWNLAYERIGNORE = 0;
    public static final int GDSUNKNOWNLAYERUSEDRC = 1;
    public static final int GDSUNKNOWNLAYERUSERANDOM = 2;
    private static Pref cacheGDSInUnknownLayerHandling;
    private static Pref cacheGDSConvertNCCExportsConnectedByParentPins;
    private static Pref cacheGDSInSimplifyCells;
    private static Pref cacheGDSArraySimplification;
    private static Pref cacheGDSCadenceCompatibility;
    private static Pref cachePrintEncapsulated;
    private static Pref cachePrintResolution;
    private static Pref cachePrintForPlotter;
    private static Pref cachePrintWidth;
    private static Pref cachePrintHeight;
    private static Pref cachePrintMargin;
    private static Pref cachePrintRotation;
    private static Pref cachePrintColorMethod;
    public static final Variable.Key POSTSCRIPT_EPS_SCALE;
    public static final Variable.Key POSTSCRIPT_FILENAME;
    public static final Variable.Key POSTSCRIPT_FILEDATE;
    private static Pref cachePrintPSLineWidth;
    private static Pref cacheEDIFUseSchematicView;
    private static Pref cacheEDIFCadenceCompatibility;
    private static Pref cacheEDIFShowArcNames;
    private static Pref cacheEDIFShowNodeNames;
    private static Pref cacheEDIFInputScale;
    private static Pref cacheEDIFConfigurationFile;
    private static Pref cacheEDIFAcceptedParameters;
    private static Pref cacheEDIFImportAllParameters;
    private static Pref cacheEDIFImportStitchesCells;
    private static Pref cacheDXFInputFlattensHierarchy;
    private static Pref cacheDXFInputReadsAllLayers;
    private static Pref cacheSueUses4PortTransistors;
    private static Pref cacheSueConvertsExpressions;
    private static Pref cacheGerberReadsAllFiles;
    private static Pref cacheGerberFillsPolygons;
    private static Pref cacheSVGScale;
    private static Pref cacheSVGMargin;
    private static Pref cacheSkillExcludesSubcells;
    private static Pref cacheSkillFlattensHierarchy;
    private static Pref cacheSkillGDSNameLimit;
    private static Pref cacheVerilogMakeLayoutCells;
    private static Pref cacheDaisDisplayOnly;
    private static Pref cacheDaisReadCellInstances;
    private static Pref cacheDaisReadDetailWires;
    private static Pref cacheDaisReadGlobalWires;
    private static Pref cacheDaisReadPowerAndGround;
    private static Pref cacheDaisReadConnectivity;

    protected IOTool() {
        super("io");
    }

    public static IOTool getIOTool() {
        return tool;
    }

    public static boolean hasSkill() {
        if (!skillChecked) {
            skillChecked = true;
            try {
                skillClass = Class.forName("com.sun.electric.plugins.skill.Skill");
            }
            catch (ClassNotFoundException e) {
                TextUtils.recordMissingPrivateComponent("Skill");
                skillClass = null;
                return false;
            }
            try {
                skillOutputMethod = skillClass.getMethod("writeSkillFile", Cell.class, String.class, SkillPreferences.class);
            }
            catch (NoSuchMethodException e) {
                skillClass = null;
                return false;
            }
        }
        return skillClass != null;
    }

    public static boolean hasCalibreDRV() {
        if (!calibreDRVChecked) {
            calibreDRVChecked = true;
            String functionName = "readCalibreDRVFile";
            String classNanme = "CalibreDRV";
            try {
                calibreDRVClass = Class.forName("com.sun.electric.plugins.calibre." + classNanme);
            }
            catch (ClassNotFoundException e) {
                TextUtils.recordMissingPrivateComponent(classNanme);
                calibreDRVClass = null;
                return false;
            }
            try {
                calibreDRVInputMethod = calibreDRVClass.getMethod(functionName, URL.class, Library.class, Technology.class, EditingPreferences.class, Map.class, CalibreDRVPreferences.class);
            }
            catch (NoSuchMethodException e) {
                calibreDRVClass = null;
                TextUtils.recordMissingPrivateComponent(classNanme + ":" + functionName);
                return false;
            }
        }
        return calibreDRVClass != null;
    }

    public static boolean hasPnR() {
        if (!pnrChecked) {
            pnrChecked = true;
            try {
                pnrClass = Class.forName("com.sun.electric.plugins.pnr.PnR");
            }
            catch (ClassNotFoundException e) {
                TextUtils.recordMissingPrivateComponent("PnR");
                pnrClass = null;
                return false;
            }
            try {
                pnrOutputMethod = pnrClass.getMethod("writePnRFile", List.class, Double.class, String.class, Boolean.class);
            }
            catch (NoSuchMethodException e) {
                pnrClass = null;
                TextUtils.recordMissingPrivateComponent("PnR:writePnRFile()");
                return false;
            }
        }
        return pnrClass != null;
    }

    public static boolean hasDais() {
        if (!daisChecked) {
            daisChecked = true;
            try {
                daisClass = Class.forName("com.sun.electric.plugins.dais.Dais");
            }
            catch (ClassNotFoundException e) {
                TextUtils.recordMissingPrivateComponent("Dais");
                daisClass = null;
                return false;
            }
            try {
                daisInputMethod = daisClass.getMethod("readDaisFile", URL.class, Library.class, Boolean.TYPE, EditingPreferences.class, DaisPreferences.class);
            }
            catch (NoSuchMethodException e) {
                daisClass = null;
                return false;
            }
        }
        return daisClass != null;
    }

    public static int getBackupRedundancy() {
        return cacheBackupRedundancy.getInt();
    }

    public static void setBackupRedundancy(int r) {
        cacheBackupRedundancy.setInt(r);
    }

    public static int getFactoryBackupRedundancy() {
        return cacheBackupRedundancy.getIntFactoryValue();
    }

    public static boolean isUseCopyrightMessage() {
        return IOTool.getUseCopyrightMessageSetting().getBoolean();
    }

    public static Setting getUseCopyrightMessageSetting() {
        return ToolSettings.getUseCopyrightMessageSetting();
    }

    public static String getCopyrightMessage() {
        return IOTool.getCopyrightMessageSetting().getString();
    }

    public static Setting getCopyrightMessageSetting() {
        return ToolSettings.getCopyrightMessageSetting();
    }

    public static int getPlotArea() {
        return cachePlotArea.getInt();
    }

    public static void setPlotArea(int pa) {
        cachePlotArea.setInt(pa);
    }

    public static int getFactoryPlotArea() {
        return cachePlotArea.getIntFactoryValue();
    }

    public static boolean isPlotDate() {
        return cachePlotDate.getBoolean();
    }

    public static void setPlotDate(boolean pd) {
        cachePlotDate.setBoolean(pd);
    }

    public static boolean isFactoryPlotDate() {
        return cachePlotDate.getBooleanFactoryValue();
    }

    private static Pref getCachePrinterName() {
        if (cachePrinterName == null) {
            cachePrinterName = Pref.makeStringPref("PrinterName", IOTool.tool.prefs, "");
        }
        return cachePrinterName;
    }

    public static String getPrinterName() {
        return IOTool.getCachePrinterName().getString();
    }

    public static void setPrinterName(String pName) {
        IOTool.getCachePrinterName().setString(pName);
    }

    public static boolean isCIFOutMimicsDisplay() {
        return IOTool.getCIFOutMimicsDisplaySetting().getBoolean();
    }

    public static Setting getCIFOutMimicsDisplaySetting() {
        return ToolSettings.getCIFOutMimicsDisplaySetting();
    }

    public static boolean isCIFOutMergesBoxes() {
        return IOTool.getCIFOutMergesBoxesSetting().getBoolean();
    }

    public static Setting getCIFOutMergesBoxesSetting() {
        return ToolSettings.getCIFOutMergesBoxesSetting();
    }

    public static boolean isCIFOutInstantiatesTopLevel() {
        return IOTool.getCIFOutInstantiatesTopLevelSetting().getBoolean();
    }

    public static Setting getCIFOutInstantiatesTopLevelSetting() {
        return ToolSettings.getCIFOutInstantiatesTopLevelSetting();
    }

    public static boolean isCIFInSquaresWires() {
        return cacheCIFInSquaresWires.getBoolean();
    }

    public static void setCIFInSquaresWires(boolean s2) {
        cacheCIFInSquaresWires.setBoolean(s2);
    }

    public static boolean isFactoryCIFInSquaresWires() {
        return cacheCIFInSquaresWires.getBooleanFactoryValue();
    }

    public static int getCIFOutScaleFactor() {
        return IOTool.getCIFOutScaleFactorSetting().getInt();
    }

    public static Setting getCIFOutScaleFactorSetting() {
        return ToolSettings.getCIFOutScaleFactor();
    }

    public static boolean isDEFLogicalPlacement() {
        return cacheDEFLogicalPlacement.getBoolean();
    }

    public static void setDEFLogicalPlacement(boolean on) {
        cacheDEFLogicalPlacement.setBoolean(on);
    }

    public static boolean isFactoryDEFLogicalPlacement() {
        return cacheDEFLogicalPlacement.getBooleanFactoryValue();
    }

    public static boolean isDEFPhysicalPlacement() {
        return cacheDEFPhysicalPlacement.getBoolean();
    }

    public static void setDEFPhysicalPlacement(boolean on) {
        cacheDEFPhysicalPlacement.setBoolean(on);
    }

    public static boolean isFactoryDEFPhysicalPlacement() {
        return cacheDEFPhysicalPlacement.getBooleanFactoryValue();
    }

    public static boolean isDEFIgnorePhysicalInNets() {
        return cacheDEFIgnorePhysicalInNets.getBoolean();
    }

    public static void setDEFIgnorePhysicalInNets(boolean on) {
        cacheDEFIgnorePhysicalInNets.setBoolean(on);
    }

    public static boolean isFactoryDEFIgnorePhysicalInNets() {
        return cacheDEFIgnorePhysicalInNets.getBooleanFactoryValue();
    }

    public static boolean isDEFIgnoreLogicalInSpecialNets() {
        return cacheDEFIgnoreLogicalInSpecialNets.getBoolean();
    }

    public static void setDEFIgnoreLogicalInSpecialNets(boolean on) {
        cacheDEFIgnoreLogicalInSpecialNets.setBoolean(on);
    }

    public static boolean isFactoryDEFIgnoreLogicalInSpecialNets() {
        return cacheDEFIgnoreLogicalInSpecialNets.getBooleanFactoryValue();
    }

    public static boolean isDEFUsePureLayerNodes() {
        return cacheDEFUsePureLayerNodes.getBoolean();
    }

    public static void setDEFUsePureLayerNodes(boolean on) {
        cacheDEFUsePureLayerNodes.setBoolean(on);
    }

    public static boolean isFactoryDEFUsePureLayerNodes() {
        return cacheDEFUsePureLayerNodes.getBooleanFactoryValue();
    }

    public static boolean isDEFMakeDummyCells() {
        return cacheDEFMakeDummyCells.getBoolean();
    }

    public static void setDEFMakeDummyCells(boolean on) {
        cacheDEFMakeDummyCells.setBoolean(on);
    }

    public static boolean isFactoryDEFMakeDummyCells() {
        return cacheDEFMakeDummyCells.getBooleanFactoryValue();
    }

    public static boolean isDEFIgnoreUngeneratedPins() {
        return cacheDEFIgnoreUngeneratedPins.getBoolean();
    }

    public static void setDEFIgnoreUngeneratedPins(boolean on) {
        cacheDEFIgnoreUngeneratedPins.setBoolean(on);
    }

    public static boolean isFactoryDEFIgnoreUngeneratedPins() {
        return cacheDEFIgnoreUngeneratedPins.getBooleanFactoryValue();
    }

    public static boolean isDEFIgnoreViasBlock() {
        return cacheDEFIgnoreViasBlock.getBoolean();
    }

    public static void setDEFIgnoreViasBlock(boolean on) {
        cacheDEFIgnoreViasBlock.setBoolean(on);
    }

    public static boolean isFactoryDEFIgnoreViasBlock() {
        return cacheDEFIgnoreViasBlock.getBooleanFactoryValue();
    }

    public static boolean isDEFConnectByGDSNames() {
        return cacheDEFConnectByGDSNames.getBoolean();
    }

    public static void setDEFConnectByGDSNames(boolean on) {
        cacheDEFConnectByGDSNames.setBoolean(on);
    }

    public static boolean isFactoryDEFConnectByGDSNames() {
        return cacheDEFConnectByGDSNames.getBooleanFactoryValue();
    }

    public static int getDEFInUnknownLayerHandling() {
        return cacheDEFInUnknownLayerHandling.getInt();
    }

    public static void setDEFInUnknownLayerHandling(int h) {
        cacheDEFInUnknownLayerHandling.setInt(h);
    }

    public static int getFactoryDEFInUnknownLayerHandling() {
        return cacheDEFInUnknownLayerHandling.getIntFactoryValue();
    }

    public static int getLEFInUnknownLayerHandling() {
        return cacheLEFInUnknownLayerHandling.getInt();
    }

    public static void setLEFInUnknownLayerHandling(int h) {
        cacheLEFInUnknownLayerHandling.setInt(h);
    }

    public static int getFactoryLEFInUnknownLayerHandling() {
        return cacheLEFInUnknownLayerHandling.getIntFactoryValue();
    }

    public static boolean isLEFIgnoreUngeneratedPins() {
        return cacheLEFIgnoreUngeneratedPins.getBoolean();
    }

    public static void setLEFIgnoreUngeneratedPins(boolean on) {
        cacheLEFIgnoreUngeneratedPins.setBoolean(on);
    }

    public static boolean isFactoryLEFIgnoreUngeneratedPins() {
        return cacheLEFIgnoreUngeneratedPins.getBooleanFactoryValue();
    }

    public static boolean isLEFIgnoreTechnology() {
        return cacheLEFIgnoreTechnology.getBoolean();
    }

    public static void setLEFIgnoreTechnology(boolean on) {
        cacheLEFIgnoreTechnology.setBoolean(on);
    }

    public static boolean isFactoryLEFIgnoreTechnology() {
        return cacheLEFIgnoreTechnology.getBooleanFactoryValue();
    }

    public static boolean isGDSOutMergesBoxes() {
        return IOTool.getGDSOutMergesBoxesSetting().getBoolean();
    }

    public static Setting getGDSOutMergesBoxesSetting() {
        return ToolSettings.getGDSOutMergesBoxesSetting();
    }

    public static boolean isGDSOutWritesExportPins() {
        return IOTool.getGDSOutWritesExportPinsSetting().getBoolean();
    }

    public static Setting getGDSOutWritesExportPinsSetting() {
        return ToolSettings.getGDSOutWritesExportPinsSetting();
    }

    public static boolean isGDSOutUpperCase() {
        return IOTool.getGDSOutUpperCaseSetting().getBoolean();
    }

    public static Setting getGDSOutUpperCaseSetting() {
        return ToolSettings.getGDSOutUpperCaseSetting();
    }

    public static boolean isGDSOutColapseVddGndPinNames() {
        return IOTool.getGDSOutUpperCaseSetting().getBoolean();
    }

    public static Setting getGDSOutColapseVddGndPinNamesSetting() {
        return ToolSettings.getGDSOutUpperCaseSetting();
    }

    public static boolean isGDSOutWriteExportCharacteristicsSetting() {
        return IOTool.getGDSOutWriteExportCharacteristicsSetting().getBoolean();
    }

    public static Setting getGDSOutWriteExportCharacteristicsSetting() {
        return ToolSettings.getGDSOutWriteExportChacteristicsSetting();
    }

    public static int getGDSDefaultTextLayer() {
        return IOTool.getGDSDefaultTextLayerSetting().getInt();
    }

    public static Setting getGDSDefaultTextLayerSetting() {
        return ToolSettings.getGDSDefaultTextLayerSetting();
    }

    public static boolean getGDSOutputConvertsBracketsInExports() {
        return IOTool.getGDSOutputConvertsBracketsInExportsSetting().getBoolean();
    }

    public static Setting getGDSOutputConvertsBracketsInExportsSetting() {
        return ToolSettings.getGDSOutputConvertsBracketsInExportsSetting();
    }

    public static int getGDSCellNameLenMax() {
        return IOTool.getGDSCellNameLenMaxSetting().getInt();
    }

    public static Setting getGDSCellNameLenMaxSetting() {
        return ToolSettings.getGDSCellNameLenMaxSetting();
    }

    public static double getGDSInputScale() {
        return IOTool.getGDSInputScaleSetting().getDouble();
    }

    public static double getFactoryGDSInputScale() {
        return IOTool.getGDSInputScaleSetting().getDoubleFactoryValue();
    }

    public static Setting getGDSInputScaleSetting() {
        return ToolSettings.getGDSInputScaleSetting();
    }

    public static double getGDSOutputScale() {
        return IOTool.getGDSOutputScaleSetting().getDouble();
    }

    public static Setting getGDSOutputScaleSetting() {
        return ToolSettings.getGDSOutputScaleSetting();
    }

    public static boolean isGDSInMergesBoxes() {
        return cacheGDSInMergesBoxes.getBoolean();
    }

    public static void setGDSInMergesBoxes(boolean on) {
        cacheGDSInMergesBoxes.setBoolean(on);
    }

    public static boolean isFactoryGDSInMergesBoxes() {
        return cacheGDSInMergesBoxes.getBooleanFactoryValue();
    }

    public static boolean isGDSWritesEntireLibrary() {
        return cacheGDSWritesEntireLibrary.getBoolean();
    }

    public static void setGDSWritesEntireLibrary(boolean on) {
        cacheGDSWritesEntireLibrary.setBoolean(on);
    }

    public static boolean isFactoryGDSWritesEntireLibrary() {
        return cacheGDSWritesEntireLibrary.getBooleanFactoryValue();
    }

    public static boolean isGDSFlatDesign() {
        return cacheGDSFlatDesign.getBoolean();
    }

    public static void setGDSFlatDesign(boolean on) {
        cacheGDSFlatDesign.setBoolean(on);
    }

    public static boolean isFactoryGDSFlatDesign() {
        return cacheGDSFlatDesign.getBooleanFactoryValue();
    }

    public static boolean isGDSOnlyInvisibleLayers() {
        return cacheGDSOnlyVisible.getBoolean();
    }

    public static void setGDSOnlyInvisibleLayers(boolean on) {
        cacheGDSOnlyVisible.setBoolean(on);
    }

    public static boolean isFactoryGDSOnlyInvisibleLayers() {
        return cacheGDSOnlyVisible.getBooleanFactoryValue();
    }

    public static boolean isGDSIncludesText() {
        return cacheGDSIncludesText.getBoolean();
    }

    public static void setGDSIncludesText(boolean on) {
        cacheGDSIncludesText.setBoolean(on);
    }

    public static boolean isFactoryGDSIncludesText() {
        return cacheGDSIncludesText.getBooleanFactoryValue();
    }

    public static boolean isGDSInExpandsCells() {
        return cacheGDSInExpandsCells.getBoolean();
    }

    public static void setGDSInExpandsCells(boolean on) {
        cacheGDSInExpandsCells.setBoolean(on);
    }

    public static boolean isFactoryGDSInExpandsCells() {
        return cacheGDSInExpandsCells.getBooleanFactoryValue();
    }

    public static boolean isGDSInInstantiatesArrays() {
        return cacheGDSInInstantiatesArrays.getBoolean();
    }

    public static void setGDSInInstantiatesArrays(boolean on) {
        cacheGDSInInstantiatesArrays.setBoolean(on);
    }

    public static boolean isFactoryGDSInInstantiatesArrays() {
        return cacheGDSInInstantiatesArrays.getBooleanFactoryValue();
    }

    public static int getGDSInUnknownLayerHandling() {
        return cacheGDSInUnknownLayerHandling.getInt();
    }

    public static void setGDSInUnknownLayerHandling(int h) {
        cacheGDSInUnknownLayerHandling.setInt(h);
    }

    public static int getFactoryGDSInUnknownLayerHandling() {
        return cacheGDSInUnknownLayerHandling.getIntFactoryValue();
    }

    public static boolean getGDSConvertNCCExportsConnectedByParentPins() {
        return cacheGDSConvertNCCExportsConnectedByParentPins.getBoolean();
    }

    public static void setGDSConvertNCCExportsConnectedByParentPins(boolean b) {
        cacheGDSConvertNCCExportsConnectedByParentPins.setBoolean(b);
    }

    public static boolean getFactoryGDSConvertNCCExportsConnectedByParentPins() {
        return cacheGDSConvertNCCExportsConnectedByParentPins.getBooleanFactoryValue();
    }

    public static boolean isGDSInSimplifyCells() {
        return cacheGDSInSimplifyCells.getBoolean();
    }

    public static void setGDSInSimplifyCells(boolean on) {
        cacheGDSInSimplifyCells.setBoolean(on);
    }

    public static boolean isFactoryGDSInSimplifyCells() {
        return cacheGDSInSimplifyCells.getBooleanFactoryValue();
    }

    public static int getGDSArraySimplification() {
        return cacheGDSArraySimplification.getInt();
    }

    public static void setGDSArraySimplification(int on) {
        cacheGDSArraySimplification.setInt(on);
    }

    public static int getFactoryGDSArraySimplification() {
        return cacheGDSArraySimplification.getIntFactoryValue();
    }

    public static boolean isGDSCadenceCompatibility() {
        return cacheGDSCadenceCompatibility.getBoolean();
    }

    public static void setGDSCadenceCompatibility(boolean c) {
        cacheGDSCadenceCompatibility.setBoolean(c);
    }

    public static boolean isFactoryGDSCadenceCompatibility() {
        return cacheGDSCadenceCompatibility.getBooleanFactoryValue();
    }

    public static boolean isPrintEncapsulated() {
        return cachePrintEncapsulated.getBoolean();
    }

    public static void setPrintEncapsulated(boolean on) {
        cachePrintEncapsulated.setBoolean(on);
    }

    public static boolean isFactoryPrintEncapsulated() {
        return cachePrintEncapsulated.getBooleanFactoryValue();
    }

    public static int getPrintResolution() {
        return cachePrintResolution.getInt();
    }

    public static void setPrintResolution(int r) {
        cachePrintResolution.setInt(r);
    }

    public static int getFactoryPrintResolution() {
        return cachePrintResolution.getIntFactoryValue();
    }

    public static boolean isPrintForPlotter() {
        return cachePrintForPlotter.getBoolean();
    }

    public static void setPrintForPlotter(boolean on) {
        cachePrintForPlotter.setBoolean(on);
    }

    public static boolean isFactoryPrintForPlotter() {
        return cachePrintForPlotter.getBooleanFactoryValue();
    }

    public static double getPrintWidth() {
        return cachePrintWidth.getDouble();
    }

    public static void setPrintWidth(double wid) {
        cachePrintWidth.setDouble(wid);
    }

    public static double getFactoryPrintWidth() {
        return cachePrintWidth.getDoubleFactoryValue();
    }

    public static double getPrintHeight() {
        return cachePrintHeight.getDouble();
    }

    public static void setPrintHeight(double hei) {
        cachePrintHeight.setDouble(hei);
    }

    public static double getFactoryPrintHeight() {
        return cachePrintHeight.getDoubleFactoryValue();
    }

    public static double getPrintMargin() {
        return cachePrintMargin.getDouble();
    }

    public static void setPrintMargin(double mar) {
        cachePrintMargin.setDouble(mar);
    }

    public static double getFactoryPrintMargin() {
        return cachePrintMargin.getDoubleFactoryValue();
    }

    public static int getPrintRotation() {
        return cachePrintRotation.getInt();
    }

    public static void setPrintRotation(int rot) {
        cachePrintRotation.setInt(rot);
    }

    public static int getFactoryPrintRotation() {
        return cachePrintRotation.getIntFactoryValue();
    }

    public static int getPrintColorMethod() {
        return cachePrintColorMethod.getInt();
    }

    public static void setPrintColorMethod(int cm) {
        cachePrintColorMethod.setInt(cm);
    }

    public static int getFactoryPrintColorMethod() {
        return cachePrintColorMethod.getIntFactoryValue();
    }

    public static double getPrintEPSScale(Cell cell) {
        Variable var = cell.getVar(POSTSCRIPT_EPS_SCALE);
        if (var != null) {
            Object obj = var.getObject();
            String desc = obj.toString();
            double epsScale = TextUtils.atof(desc);
            return epsScale;
        }
        return 1.0;
    }

    public static void setPrintEPSScale(Cell cell, double scale) {
        tool.setVarInJob(cell, POSTSCRIPT_EPS_SCALE, new Double(scale));
    }

    public static String getPrintEPSSynchronizeFile(Cell cell) {
        Variable var = cell.getVar(POSTSCRIPT_FILENAME);
        if (var != null) {
            Object obj = var.getObject();
            String desc = obj.toString();
            return desc;
        }
        return "";
    }

    public static void setPrintEPSSynchronizeFile(Cell cell, String syncFile) {
        tool.setVarInJob(cell, POSTSCRIPT_FILENAME, syncFile);
    }

    public static Date getPrintEPSSavedDate(Cell cell) {
        Integer[] lastSavedDateAsInts = cell.getVarValue(POSTSCRIPT_FILEDATE, Integer[].class);
        if (lastSavedDateAsInts == null) {
            return null;
        }
        long lastSavedDateInSeconds = (long)lastSavedDateAsInts[0].intValue() << 32 | (long)(lastSavedDateAsInts[1] & 0xFFFFFFFF);
        Date lastSavedDate = new Date(lastSavedDateInSeconds);
        return lastSavedDate;
    }

    public static void setPrintEPSSavedDate(Cell cell, Date date) {
        long iVal = date.getTime();
        Integer[] dateArray = new Integer[]{new Integer((int)(iVal >> 32)), new Integer((int)(iVal & 0xFFFFFFFFFFFFFFFFL))};
        tool.setVarInJob(cell, POSTSCRIPT_FILEDATE, dateArray);
    }

    public static double getPrintPSLineWidth() {
        return cachePrintPSLineWidth.getDouble();
    }

    public static void setPrintPSLineWidth(double mar) {
        cachePrintPSLineWidth.setDouble(mar);
    }

    public static double getFactoryPrintPSLineWidth() {
        return cachePrintPSLineWidth.getDoubleFactoryValue();
    }

    public static boolean isEDIFUseSchematicView() {
        return cacheEDIFUseSchematicView.getBoolean();
    }

    public static void setEDIFUseSchematicView(boolean f) {
        cacheEDIFUseSchematicView.setBoolean(f);
    }

    public static boolean isFactoryEDIFUseSchematicView() {
        return cacheEDIFUseSchematicView.getBooleanFactoryValue();
    }

    public static boolean isEDIFCadenceCompatibility() {
        return cacheEDIFCadenceCompatibility.getBoolean();
    }

    public static void setEDIFCadenceCompatibility(boolean c) {
        cacheEDIFCadenceCompatibility.setBoolean(c);
    }

    public static boolean isFactoryEDIFCadenceCompatibility() {
        return cacheEDIFCadenceCompatibility.getBooleanFactoryValue();
    }

    public static boolean isEDIFShowArcNames() {
        return cacheEDIFShowArcNames.getBoolean();
    }

    public static void setEDIFShowArcNames(boolean c) {
        cacheEDIFShowArcNames.setBoolean(c);
    }

    public static boolean isFactoryEDIFShowArcNames() {
        return cacheEDIFShowArcNames.getBooleanFactoryValue();
    }

    public static boolean isEDIFShowNodeNames() {
        return cacheEDIFShowNodeNames.getBoolean();
    }

    public static void setEDIFShowNodeNames(boolean c) {
        cacheEDIFShowNodeNames.setBoolean(c);
    }

    public static boolean isFactoryEDIFShowNodeNames() {
        return cacheEDIFShowNodeNames.getBooleanFactoryValue();
    }

    public static double getEDIFInputScale() {
        return cacheEDIFInputScale.getDouble();
    }

    public static void setEDIFInputScale(double f) {
        cacheEDIFInputScale.setDouble(f);
    }

    public static double getFactoryEDIFInputScale() {
        return cacheEDIFInputScale.getDoubleFactoryValue();
    }

    public static String getEDIFConfigurationFile() {
        return cacheEDIFConfigurationFile.getString();
    }

    public static void setEDIFConfigurationFile(String cFile) {
        cacheEDIFConfigurationFile.setString(cFile);
    }

    public static String getFactoryEDIFConfigurationFile() {
        return cacheEDIFConfigurationFile.getStringFactoryValue();
    }

    public static String getEDIFAcceptedParameters() {
        return cacheEDIFAcceptedParameters.getString();
    }

    public static void setEDIFAcceptedParameters(String ap) {
        cacheEDIFAcceptedParameters.setString(ap);
    }

    public static String getFactoryEDIFAcceptedParameters() {
        return cacheEDIFAcceptedParameters.getStringFactoryValue();
    }

    public static boolean isEDIFImportAllParameters() {
        return cacheEDIFImportAllParameters.getBoolean();
    }

    public static void setEDIFImportAllParameters(boolean c) {
        cacheEDIFImportAllParameters.setBoolean(c);
    }

    public static boolean isFactoryEDIFImportAllParameters() {
        return cacheEDIFImportAllParameters.getBooleanFactoryValue();
    }

    public static boolean isEDIFImportStitchesCells() {
        return cacheEDIFImportStitchesCells.getBoolean();
    }

    public static void setEDIFImportStitchesCells(boolean c) {
        cacheEDIFImportStitchesCells.setBoolean(c);
    }

    public static boolean isFactoryEDIFImportStitchesCells() {
        return cacheEDIFImportStitchesCells.getBooleanFactoryValue();
    }

    public static int getDXFScale() {
        return IOTool.getDXFScaleSetting().getInt();
    }

    public static int getFactoryDXFScale() {
        return IOTool.getDXFScaleSetting().getIntFactoryValue();
    }

    public static Setting getDXFScaleSetting() {
        return ToolSettings.getDXFScaleSetting();
    }

    public static boolean isDXFInputFlattensHierarchy() {
        return cacheDXFInputFlattensHierarchy.getBoolean();
    }

    public static void setDXFInputFlattensHierarchy(boolean f) {
        cacheDXFInputFlattensHierarchy.setBoolean(f);
    }

    public static boolean isFactoryDXFInputFlattensHierarchy() {
        return cacheDXFInputFlattensHierarchy.getBooleanFactoryValue();
    }

    public static boolean isDXFInputReadsAllLayers() {
        return cacheDXFInputReadsAllLayers.getBoolean();
    }

    public static void setDXFInputReadsAllLayers(boolean a) {
        cacheDXFInputReadsAllLayers.setBoolean(a);
    }

    public static boolean isFactoryDXFInputReadsAllLayers() {
        return cacheDXFInputReadsAllLayers.getBooleanFactoryValue();
    }

    public static boolean isSueUses4PortTransistors() {
        return cacheSueUses4PortTransistors.getBoolean();
    }

    public static void setSueUses4PortTransistors(boolean on) {
        cacheSueUses4PortTransistors.setBoolean(on);
    }

    public static boolean isFactorySueUses4PortTransistors() {
        return cacheSueUses4PortTransistors.getBooleanFactoryValue();
    }

    public static boolean isSueConvertsExpressions() {
        return cacheSueConvertsExpressions.getBoolean();
    }

    public static void setSueConvertsExpressions(boolean on) {
        cacheSueConvertsExpressions.setBoolean(on);
    }

    public static boolean isFactorySueConvertsExpressions() {
        return cacheSueConvertsExpressions.getBooleanFactoryValue();
    }

    public static boolean isGerberReadsAllFiles() {
        return cacheGerberReadsAllFiles.getBoolean();
    }

    public static void setGerberReadsAllFiles(boolean on) {
        cacheGerberReadsAllFiles.setBoolean(on);
    }

    public static boolean isFactoryGerberReadsAllFiles() {
        return cacheGerberReadsAllFiles.getBooleanFactoryValue();
    }

    public static boolean isGerberFillsPolygons() {
        return cacheGerberFillsPolygons.getBoolean();
    }

    public static void setGerberFillsPolygons(boolean on) {
        cacheGerberFillsPolygons.setBoolean(on);
    }

    public static boolean isFactoryGerberFillsPolygons() {
        return cacheGerberFillsPolygons.getBooleanFactoryValue();
    }

    public static double getSVGScale() {
        return cacheSVGScale.getDouble();
    }

    public static void setSVGScale(double s2) {
        cacheSVGScale.setDouble(s2);
    }

    public static double getFactorySVGScale() {
        return cacheSVGScale.getDoubleFactoryValue();
    }

    public static double getSVGMargin() {
        return cacheSVGMargin.getDouble();
    }

    public static void setSVGMargin(double m) {
        cacheSVGMargin.setDouble(m);
    }

    public static double getFactorySVGMargin() {
        return cacheSVGMargin.getDoubleFactoryValue();
    }

    public static boolean isSkillExcludesSubcells() {
        return cacheSkillExcludesSubcells.getBoolean();
    }

    public static void setSkillExcludesSubcells(boolean on) {
        cacheSkillExcludesSubcells.setBoolean(on);
    }

    public static boolean isFactorySkillExcludesSubcells() {
        return cacheSkillExcludesSubcells.getBooleanFactoryValue();
    }

    public static boolean isSkillFlattensHierarchy() {
        return cacheSkillFlattensHierarchy.getBoolean();
    }

    public static void setSkillFlattensHierarchy(boolean on) {
        cacheSkillFlattensHierarchy.setBoolean(on);
    }

    public static boolean isFactorySkillFlattensHierarchy() {
        return cacheSkillFlattensHierarchy.getBooleanFactoryValue();
    }

    public static boolean isSkillGDSNameLimit() {
        return cacheSkillGDSNameLimit.getBoolean();
    }

    public static void setSkillGDSNameLimit(boolean on) {
        cacheSkillGDSNameLimit.setBoolean(on);
    }

    public static boolean isFactorySkillGDSNameLimit() {
        return cacheSkillGDSNameLimit.getBooleanFactoryValue();
    }

    public static boolean isVerilogMakeLayoutCells() {
        return cacheVerilogMakeLayoutCells.getBoolean();
    }

    public static void setVerilogMakeLayoutCells(boolean on) {
        cacheVerilogMakeLayoutCells.setBoolean(on);
    }

    public static boolean isFactoryVerilogMakeLayoutCells() {
        return cacheVerilogMakeLayoutCells.getBooleanFactoryValue();
    }

    public static boolean isDaisDisplayOnly() {
        return cacheDaisDisplayOnly.getBoolean();
    }

    public static void setDaisDisplayOnly(boolean on) {
        cacheDaisDisplayOnly.setBoolean(on);
    }

    public static boolean isFactoryDaisDisplayOnly() {
        return cacheDaisDisplayOnly.getBooleanFactoryValue();
    }

    public static boolean isDaisReadCellInstances() {
        return cacheDaisReadCellInstances.getBoolean();
    }

    public static void setDaisReadCellInstances(boolean on) {
        cacheDaisReadCellInstances.setBoolean(on);
    }

    public static boolean isFactoryDaisReadCellInstances() {
        return cacheDaisReadCellInstances.getBooleanFactoryValue();
    }

    public static boolean isDaisReadDetailWires() {
        return cacheDaisReadDetailWires.getBoolean();
    }

    public static void setDaisReadDetailWires(boolean on) {
        cacheDaisReadDetailWires.setBoolean(on);
    }

    public static boolean isFactoryDaisReadDetailWires() {
        return cacheDaisReadDetailWires.getBooleanFactoryValue();
    }

    public static boolean isDaisReadGlobalWires() {
        return cacheDaisReadGlobalWires.getBoolean();
    }

    public static void setDaisReadGlobalWires(boolean on) {
        cacheDaisReadGlobalWires.setBoolean(on);
    }

    public static boolean isFactoryDaisReadGlobalWires() {
        return cacheDaisReadGlobalWires.getBooleanFactoryValue();
    }

    public static boolean isDaisReadPowerAndGround() {
        return cacheDaisReadPowerAndGround.getBoolean();
    }

    public static void setDaisReadPowerAndGround(boolean on) {
        cacheDaisReadPowerAndGround.setBoolean(on);
    }

    public static boolean isFactoryDaisReadPowerAndGround() {
        return cacheDaisReadPowerAndGround.getBooleanFactoryValue();
    }

    public static boolean isDaisReadConnectivity() {
        return cacheDaisReadConnectivity.getBoolean();
    }

    public static void setDaisReadConnectivity(boolean on) {
        cacheDaisReadConnectivity.setBoolean(on);
    }

    public static boolean isFactoryDaisReadConnectivity() {
        return cacheDaisReadConnectivity.getBooleanFactoryValue();
    }

    static {
        FileType.getFileTypeGroups();
        IO_TRUE_LIBRARY = Variable.newKey("IO_true_library");
        skillChecked = false;
        skillClass = null;
        calibreDRVChecked = false;
        calibreDRVClass = null;
        pnrChecked = false;
        pnrClass = null;
        daisChecked = false;
        daisClass = null;
        cacheBackupRedundancy = Pref.makeIntPref("OutputBackupRedundancy", IOTool.tool.prefs, 0);
        cachePlotArea = Pref.makeIntPref("PlotArea", IOTool.tool.prefs, 0);
        cachePlotDate = Pref.makeBooleanPref("PlotDate", IOTool.tool.prefs, false);
        cachePrinterName = null;
        cacheCIFInSquaresWires = Pref.makeBooleanPref("CIFInSquaresWires", IOTool.tool.prefs, true);
        cacheDEFLogicalPlacement = Pref.makeBooleanPref("DEFLogicalPlacement", IOTool.tool.prefs, true);
        cacheDEFPhysicalPlacement = Pref.makeBooleanPref("DEFPhysicalPlacement", IOTool.tool.prefs, true);
        cacheDEFIgnorePhysicalInNets = Pref.makeBooleanPref("DEFIgnorePhysicalInNets", IOTool.tool.prefs, false);
        cacheDEFIgnoreLogicalInSpecialNets = Pref.makeBooleanPref("DEFIgnoreLogicalInSpecialNets", IOTool.tool.prefs, false);
        cacheDEFUsePureLayerNodes = Pref.makeBooleanPref("DEFUsePureLayerNodes", IOTool.tool.prefs, false);
        cacheDEFMakeDummyCells = Pref.makeBooleanPref("DEFMakeDummyCells", IOTool.tool.prefs, false);
        cacheDEFIgnoreUngeneratedPins = Pref.makeBooleanPref("DEFIgnoreUngeneratedPins", IOTool.tool.prefs, true);
        cacheDEFIgnoreViasBlock = Pref.makeBooleanPref("DEFIgnoreViasBlock", IOTool.tool.prefs, false);
        cacheDEFConnectByGDSNames = Pref.makeBooleanPref("DEFConnectByGDSNames", IOTool.tool.prefs, false);
        cacheDEFInUnknownLayerHandling = Pref.makeIntPref("DEFInUnknownLayerHandling", IOTool.tool.prefs, 0);
        cacheLEFInUnknownLayerHandling = Pref.makeIntPref("LEFInUnknownLayerHandling", IOTool.tool.prefs, 0);
        cacheLEFIgnoreUngeneratedPins = Pref.makeBooleanPref("LEFIgnoreUngeneratedPins", IOTool.tool.prefs, true);
        cacheLEFIgnoreTechnology = Pref.makeBooleanPref("LEFIgnoreTechnology", IOTool.tool.prefs, false);
        cacheGDSInMergesBoxes = Pref.makeBooleanPref("GDSInMergesBoxes", IOTool.tool.prefs, false);
        cacheGDSWritesEntireLibrary = Pref.makeBooleanPref("GDSWritesEntireLibrary", IOTool.tool.prefs, false);
        cacheGDSFlatDesign = Pref.makeBooleanPref("GDSFlatDesign", IOTool.tool.prefs, false);
        cacheGDSOnlyVisible = Pref.makeBooleanPref("GDSOnlyVisible", IOTool.tool.prefs, false);
        cacheGDSIncludesText = Pref.makeBooleanPref("GDSInIncludesText", IOTool.tool.prefs, false);
        cacheGDSInExpandsCells = Pref.makeBooleanPref("GDSInExpandsCells", IOTool.tool.prefs, false);
        cacheGDSInInstantiatesArrays = Pref.makeBooleanPref("GDSInInstantiatesArrays", IOTool.tool.prefs, true);
        cacheGDSInUnknownLayerHandling = Pref.makeIntPref("GDSInUnknownLayerHandling", IOTool.tool.prefs, 1);
        cacheGDSConvertNCCExportsConnectedByParentPins = Pref.makeBooleanPref("GDSConvertNCCEconnectedByParentPins", IOTool.tool.prefs, false);
        cacheGDSInSimplifyCells = Pref.makeBooleanPref("GDSInSimplifyCells", IOTool.tool.prefs, false);
        cacheGDSArraySimplification = Pref.makeIntPref("cacheGDSArraySimplification", IOTool.tool.prefs, 0);
        cacheGDSCadenceCompatibility = Pref.makeBooleanPref("GDSCadenceCompatibility", IOTool.tool.prefs, true);
        cachePrintEncapsulated = Pref.makeBooleanPref("PostScriptEncapsulated", IOTool.tool.prefs, false);
        cachePrintResolution = Pref.makeIntPref("PrintResolution", IOTool.tool.prefs, 300);
        cachePrintForPlotter = Pref.makeBooleanPref("PostScriptForPlotter", IOTool.tool.prefs, false);
        cachePrintWidth = Pref.makeDoublePref("PostScriptWidth", IOTool.tool.prefs, 8.5);
        cachePrintHeight = Pref.makeDoublePref("PostScriptHeight", IOTool.tool.prefs, 11.0);
        cachePrintMargin = Pref.makeDoublePref("PostScriptMargin", IOTool.tool.prefs, 0.75);
        cachePrintRotation = Pref.makeIntPref("PostScriptRotation", IOTool.tool.prefs, 0);
        cachePrintColorMethod = Pref.makeIntPref("PostScriptColorMethod", IOTool.tool.prefs, 0);
        POSTSCRIPT_EPS_SCALE = Variable.newKey("IO_postscript_EPS_scale");
        POSTSCRIPT_FILENAME = Variable.newKey("IO_postscript_filename");
        POSTSCRIPT_FILEDATE = Variable.newKey("IO_postscript_filedate");
        cachePrintPSLineWidth = Pref.makeDoublePref("PostScriptLineWidth", IOTool.tool.prefs, 1.0);
        cacheEDIFUseSchematicView = Pref.makeBooleanPref("EDIFUseSchematicView", IOTool.tool.prefs, true);
        cacheEDIFCadenceCompatibility = Pref.makeBooleanPref("EDIFCadenceCompatibility", IOTool.tool.prefs, true);
        cacheEDIFShowArcNames = Pref.makeBooleanPref("EDIFShowArcNames", IOTool.tool.prefs, true);
        cacheEDIFShowNodeNames = Pref.makeBooleanPref("EDIFShowNodeNames", IOTool.tool.prefs, true);
        cacheEDIFInputScale = Pref.makeDoublePref("EDIFInputScale", IOTool.tool.prefs, 0.05);
        cacheEDIFConfigurationFile = Pref.makeStringPref("EDIFConfigurationFile", IOTool.tool.prefs, "");
        cacheEDIFAcceptedParameters = Pref.makeStringPref("EDIFAcceptedParameters", IOTool.tool.prefs, "");
        cacheEDIFImportAllParameters = Pref.makeBooleanPref("EDIFImportAllParameters", IOTool.tool.prefs, false);
        cacheEDIFImportStitchesCells = Pref.makeBooleanPref("EDIFImportStitchesCells", IOTool.tool.prefs, true);
        cacheDXFInputFlattensHierarchy = Pref.makeBooleanPref("DXFInputFlattensHierarchy", IOTool.tool.prefs, true);
        cacheDXFInputReadsAllLayers = Pref.makeBooleanPref("DXFInputReadsAllLayers", IOTool.tool.prefs, true);
        cacheSueUses4PortTransistors = Pref.makeBooleanPref("SueUses4PortTransistors", IOTool.tool.prefs, false);
        cacheSueConvertsExpressions = Pref.makeBooleanPref("SueConvertsExpressions", IOTool.tool.prefs, true);
        cacheGerberReadsAllFiles = Pref.makeBooleanPref("GerberReadsAllFiles", IOTool.tool.prefs, true);
        cacheGerberFillsPolygons = Pref.makeBooleanPref("GerberFillsPolygons", IOTool.tool.prefs, true);
        cacheSVGScale = Pref.makeDoublePref("SVGScale", IOTool.tool.prefs, 1.0);
        cacheSVGMargin = Pref.makeDoublePref("SVGMargin", IOTool.tool.prefs, 50.0);
        cacheSkillExcludesSubcells = Pref.makeBooleanPref("SkillExcludesSubcells", IOTool.tool.prefs, false);
        cacheSkillFlattensHierarchy = Pref.makeBooleanPref("SkillFlattensHierarchy", IOTool.tool.prefs, false);
        cacheSkillGDSNameLimit = Pref.makeBooleanPref("SkillGDSNameLimit", IOTool.tool.prefs, false);
        cacheVerilogMakeLayoutCells = Pref.makeBooleanPref("VerilogMakeLayoutCells", IOTool.tool.prefs, false);
        cacheDaisDisplayOnly = Pref.makeBooleanPref("DaisDisplayOnly", IOTool.tool.prefs, false);
        cacheDaisReadCellInstances = Pref.makeBooleanPref("DaisReadCellInstances", IOTool.tool.prefs, true);
        cacheDaisReadDetailWires = Pref.makeBooleanPref("DaisReadDetailWires", IOTool.tool.prefs, true);
        cacheDaisReadGlobalWires = Pref.makeBooleanPref("DaisReadGlobalWires", IOTool.tool.prefs, false);
        cacheDaisReadPowerAndGround = Pref.makeBooleanPref("DaisReadPowerAndGround", IOTool.tool.prefs, true);
        cacheDaisReadConnectivity = Pref.makeBooleanPref("DaisReadConnectivity", IOTool.tool.prefs, true);
    }

    public static class DaisPreferences
    extends Input.InputPreferences {
        private boolean newLib;
        public boolean displayOnly;
        public boolean readCellInstances;
        public boolean readGlobalWires;
        public boolean readPowerAndGround;
        public boolean readDetailWires;
        public boolean readConnectivity;

        public DaisPreferences(boolean factory, boolean newLib) {
            super(factory);
            this.newLib = newLib;
            if (!factory) {
                this.displayOnly = IOTool.isDaisDisplayOnly();
                this.readCellInstances = IOTool.isDaisReadCellInstances();
                this.readGlobalWires = IOTool.isDaisReadGlobalWires();
                this.readPowerAndGround = IOTool.isDaisReadPowerAndGround();
                this.readDetailWires = IOTool.isDaisReadDetailWires();
                this.readConnectivity = IOTool.isDaisReadConnectivity();
            }
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            if (!IOTool.hasDais()) {
                return null;
            }
            try {
                long startTime = System.currentTimeMillis();
                long startMemory = MemoryUsage.getMemoryUsage();
                daisInputMethod.invoke((Object)daisClass, fileURL, lib, this.newLib, ep, this);
                long endTime = System.currentTimeMillis();
                ElapseTimer et = ElapseTimer.createInstanceByValues(startTime, endTime);
                long end = MemoryUsage.getMemoryUsage();
                long amt = (end - startMemory) / 1024L / 1024L;
                System.out.println("*** DAIS INPUT TOOK " + et + ", " + amt + " megabytes");
            }
            catch (Exception e) {
                System.out.println("Unable to run the Dais input module (" + e.getClass() + ")");
                e.printStackTrace(System.out);
            }
            return lib;
        }
    }

    public static class PnRPreferences
    implements Serializable {
        public PnRPreferences(boolean factory) {
        }

        public void writePnR(List<Geometric> allGeometry, double scale, String filePath, boolean clockTreeTask) {
            if (!IOTool.hasPnR()) {
                System.out.println("PnR module is not available");
                return;
            }
            Output out = null;
            try {
                out = (Output)pnrOutputMethod.invoke((Object)pnrClass, allGeometry, new Double(scale), filePath, clockTreeTask);
            }
            catch (Exception e) {
                String msg = "Unable to run the PnR output module: " + e.getMessage();
                if (out != null) {
                    out.reportError(msg);
                }
                System.out.println(msg);
            }
        }
    }

    public static class CalibreDRVPreferences
    extends Input.InputPreferences {
        public CalibreDRVPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            if (!IOTool.hasCalibreDRV()) {
                System.out.println("CalibreDRV module is not available");
                return null;
            }
            lib = null;
            try {
                lib = (Library)calibreDRVInputMethod.invoke((Object)calibreDRVClass, fileURL, lib, tech, ep, currentCells, this);
            }
            catch (Exception e) {
                System.out.println("Unable to run the CalibreDRV input module: " + e.getMessage());
            }
            return lib;
        }
    }

    public static class SkillPreferences
    extends Output.OutputPreferences {
        public boolean exportsOnly;
        public String libName;
        public boolean gdsNameLimit;
        public int gdsCellNameLenMax;
        public boolean gdsOutUpperCase;
        public boolean flattenHierarchy;
        public boolean excludeSubcells;

        public SkillPreferences(boolean factory, boolean exportsOnly, Cell cell) {
            super(factory);
            this.exportsOnly = exportsOnly;
            this.gdsNameLimit = IOTool.isSkillGDSNameLimit();
            this.gdsCellNameLenMax = IOTool.getGDSCellNameLenMax();
            this.gdsOutUpperCase = IOTool.isGDSOutUpperCase();
            this.flattenHierarchy = IOTool.isSkillFlattensHierarchy();
            this.excludeSubcells = IOTool.isSkillExcludesSubcells();
            this.libName = Job.getUserInterface().askForInput("Library name to use in SKILL file:", "Name Selection", cell.getLibrary().getName());
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            if (!IOTool.hasSkill()) {
                return null;
            }
            Output out = null;
            try {
                out = (Output)skillOutputMethod.invoke((Object)skillClass, cell, filePath, this);
            }
            catch (Exception e) {
                String msg = "Unable to run the Skill output module: " + e.getMessage();
                if (out != null) {
                    out.reportError(msg);
                }
                System.out.println(msg);
            }
            return out;
        }
    }
}

