/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.GDSLayers;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GDSMap
extends EDialog {
    private HashMap<String, JComboBox> assocCombosDrawing;
    private List<MapLine> drawingEntries;
    private List<MapLine> pinEntries;
    private List<MapLine> textEntries;
    private Technology tech;

    public static void exportMapFile() {
        Technology tech = Technology.getCurrent();
        String fileName = OpenFile.chooseOutputFile(FileType.GDSMAP, "Exporting GDS Layer Map for '" + tech.getTechName() + "'", "gdsmap.map");
        if (fileName == null) {
            return;
        }
        PrintWriter printWriter = com.sun.electric.util.TextUtils.openPrintWriterFromFileName(fileName, false);
        System.out.print("Writing GDS Layer Map from '" + fileName + "' ");
        String text2 = TextUtils.generateFileHeader(null, "#", "#", true, true);
        printWriter.println(text2);
        printWriter.println("# Layer Name \t\t Layer Purpose \t Layer Stream Number \t Datatype Stream Number");
        printWriter.println();
        List<Layer> list2 = tech.getLayersSortedByRule(Layer.LayerSortingType.ByGDSIndex);
        for (Layer l : list2) {
            GDSLayers gdsL = GDSLayers.getGDSValues(l);
            int layerNum = gdsL.getLayerNumber(GDSLayers.GDSLayerType.DRAWING);
            int layerType = gdsL.getLayerType(GDSLayers.GDSLayerType.DRAWING);
            printWriter.println(l.getName() + "\t\tdrawing\t" + layerNum + "\t" + layerType);
            if (gdsL.hasLayerType(GDSLayers.GDSLayerType.PIN)) {
                printWriter.println(l.getName() + "\t\tpin\t" + gdsL.getLayerNumber(GDSLayers.GDSLayerType.PIN) + "\t" + gdsL.getLayerType(GDSLayers.GDSLayerType.PIN));
            }
            if (!gdsL.hasLayerType(GDSLayers.GDSLayerType.TEXT)) continue;
            printWriter.println(l.getName() + "\t\ttext\t" + gdsL.getLayerNumber(GDSLayers.GDSLayerType.TEXT) + "\t" + gdsL.getLayerType(GDSLayers.GDSLayerType.TEXT));
        }
        printWriter.close();
        System.out.println("done.");
    }

    public static void importMapFile() {
        Technology tech = Technology.getCurrent();
        String fileName = OpenFile.chooseInputFile(FileType.GDSMAP, "Importing GDS Layer Map File for '" + tech.getTechName() + "'", null);
        if (fileName == null) {
            return;
        }
        HashSet<String> allNames = new HashSet<String>();
        ArrayList<MapLine> drawingEntries = new ArrayList<MapLine>();
        ArrayList<MapLine> pinEntries = new ArrayList<MapLine>();
        ArrayList<MapLine> textEntries = new ArrayList<MapLine>();
        URL url = com.sun.electric.util.TextUtils.makeURLToFile(fileName);
        System.out.print("Reading of GDS Layer Map from '" + fileName + "' ");
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            while ((buf = lineReader.readLine()) != null) {
                int spaPos;
                if ((buf = buf.trim()).length() == 0 || buf.charAt(0) == '#' || (spaPos = buf.indexOf(32)) < 0) continue;
                String layerName = buf.substring(0, spaPos);
                if ((spaPos = (buf = buf.substring(spaPos + 1).trim()).indexOf(32)) < 0) continue;
                String layerPurpose = buf.substring(0, spaPos);
                if ((spaPos = (buf = buf.substring(spaPos + 1).trim()).indexOf(32)) < 0) continue;
                int gdsNumber = com.sun.electric.util.TextUtils.atoi(buf.substring(0, spaPos));
                buf = buf.substring(spaPos + 1).trim();
                int gdsType = com.sun.electric.util.TextUtils.atoi(buf);
                if (!layerPurpose.equalsIgnoreCase("drawing") && !layerPurpose.equalsIgnoreCase("pin") && !layerPurpose.equalsIgnoreCase("text")) continue;
                MapLine ml = new MapLine();
                ml.name = layerName;
                ml.layer = gdsNumber;
                ml.type = gdsType;
                if (layerPurpose.equalsIgnoreCase("drawing")) {
                    drawingEntries.add(ml);
                } else if (layerPurpose.equalsIgnoreCase("pin")) {
                    pinEntries.add(ml);
                } else {
                    textEntries.add(ml);
                }
                allNames.add(layerName);
            }
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return;
        }
        new GDSMap(TopLevel.getCurrentJFrame(), allNames, drawingEntries, pinEntries, textEntries);
        System.out.println("done.");
    }

    private void addElement(MapLine map2, String purpose, int row, JPanel panel, Foundry foundry, Map<Setting, Object> context) {
        String value2 = map2.name + " (" + purpose + "," + map2.layer;
        value2 = value2 + (map2.type != 0 ? "/" + map2.type + ")" : ")");
        JLabel lab = new JLabel(value2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.ipadx = 5;
        gbc.anchor = 17;
        panel.add((Component)lab, gbc);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("<IGNORE>");
        Layer foundLayer = null;
        Iterator<Layer> lIt = this.tech.getLayers();
        while (lIt.hasNext()) {
            Layer lay = lIt.next();
            String layName = lay.getName();
            comboBox.addItem(layName);
            if (!layName.equals(map2.name)) continue;
            assert (foundLayer == null);
            foundLayer = lay;
        }
        String valueFromfile = value2;
        value2 = "";
        if (foundLayer != null) {
            comboBox.setSelectedItem(map2.name);
            Setting set = foundry.getGDSLayerSetting(foundLayer);
            Object obj = context.get(set);
            GDSLayers l = GDSLayers.parseLayerString(obj.toString());
            if (purpose.toLowerCase().equals("drawing")) {
                value2 = map2.name + " (" + purpose + "," + l.getString(GDSLayers.GDSLayerType.DRAWING) + ")";
            } else if (purpose.toLowerCase().equals("pin")) {
                value2 = map2.name + " (" + purpose + "," + l.getString(GDSLayers.GDSLayerType.PIN) + ")";
            } else if (purpose.toLowerCase().equals("text")) {
                value2 = map2.name + " (" + purpose + "," + l.getString(GDSLayers.GDSLayerType.TEXT) + ")";
            }
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = row;
        gbc.ipadx = 5;
        panel.add(comboBox, gbc);
        lab = new JLabel(value2);
        if (value2.equals(valueFromfile)) {
            lab.setForeground(Color.GRAY);
        } else {
            lab.setForeground(Color.RED);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = row;
        gbc.ipadx = 5;
        panel.add((Component)lab, gbc);
        this.assocCombosDrawing.put(map2.name, comboBox);
    }

    public GDSMap(Frame parent, HashSet<String> allNames, List<MapLine> drawingEntries, List<MapLine> pinEntries, List<MapLine> textEntries) {
        super(parent, true);
        this.drawingEntries = drawingEntries;
        this.pinEntries = pinEntries;
        this.textEntries = textEntries;
        this.tech = Technology.getCurrent();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("GDS Layer Map Association");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GDSMap.this.closeDialog(evt);
            }
        });
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : allNames) {
            nameList.add(name);
        }
        Collections.sort(nameList, com.sun.electric.util.TextUtils.STRING_NUMBER_ORDER);
        this.assocCombosDrawing = new HashMap();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        JLabel lab = new JLabel("Imported data");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.ipadx = 5;
        gbc.ipady = 15;
        gbc.anchor = 10;
        panel.add((Component)lab, gbc);
        lab = new JLabel("Action");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = row;
        gbc.ipadx = 5;
        gbc.ipady = 15;
        gbc.anchor = 10;
        panel.add((Component)lab, gbc);
        lab = new JLabel("Current data");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = row;
        gbc.ipadx = 5;
        gbc.ipady = 15;
        gbc.anchor = 10;
        panel.add((Component)lab, gbc);
        Foundry foundry = this.tech.getSelectedFoundry();
        row = 2;
        EDatabase database = EDatabase.clientDatabase();
        Map<Setting, Object> context = database.getSettings();
        for (MapLine map2 : drawingEntries) {
            this.addElement(map2, "drawing", row, panel, foundry, context);
            ++row;
        }
        for (MapLine n : pinEntries) {
            this.addElement(n, "pin", row, panel, foundry, context);
            ++row;
        }
        for (MapLine n : textEntries) {
            this.addElement(n, "text", row, panel, foundry, context);
            ++row;
        }
        JScrollPane assocPane = new JScrollPane();
        assocPane.setViewportView(panel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)assocPane, gbc);
        lab = new JLabel("Mapping these layer names to the '" + this.tech.getTechName() + "' technology:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)lab, gbc);
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GDSMap.this.ok();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)ok, gbc);
        this.getRootPane().setDefaultButton(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GDSMap.this.closeDialog(null);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)cancel, gbc);
        this.pack();
        this.setVisible(true);
    }

    public void termDialog() {
        for (String name : this.assocCombosDrawing.keySet()) {
            JComboBox combo = this.assocCombosDrawing.get(name);
            String layerName = "";
            if (combo.getSelectedIndex() != 0) {
                layerName = (String)combo.getSelectedItem();
            }
            this.setSavedAssoc(name, layerName);
        }
        Foundry foundry = this.tech.getSelectedFoundry();
        if (foundry == null) {
            System.out.println("No foundry associated for the mapping");
            return;
        }
        Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        for (MapLine ml : this.drawingEntries) {
            Layer layer;
            String layerName = this.getSavedAssoc(ml.name);
            if (layerName.length() == 0 || (layer = this.tech.findLayer(layerName)) == null) continue;
            String layerInfo = "" + ml.layer;
            if (ml.type != 0) {
                layerInfo = layerInfo + "/" + ml.type;
            }
            for (MapLine pMl : this.pinEntries) {
                if (!pMl.name.equals(ml.name)) continue;
                if (pMl.layer == -1) break;
                layerInfo = layerInfo + "," + pMl.layer;
                if (pMl.type != 0) {
                    layerInfo = layerInfo + "/" + pMl.type;
                }
                layerInfo = layerInfo + "p";
                break;
            }
            for (MapLine tMl : this.textEntries) {
                if (!tMl.name.equals(ml.name)) continue;
                if (tMl.layer == -1) break;
                layerInfo = layerInfo + "," + tMl.layer;
                if (tMl.type != 0) {
                    layerInfo = layerInfo + "/" + tMl.type;
                }
                layerInfo = layerInfo + "t";
                break;
            }
            changeBatch.add(foundry.getGDSLayerSetting(layer), layerInfo);
        }
        new OKUpdate(changeBatch).startJob();
    }

    private void ok() {
        this.termDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private String getSavedAssoc(String mapName) {
        Preferences preferences = Pref.getPrefRoot().node(IOTool.getIOTool().prefs.relativePath());
        return preferences.get("GDSMappingFor" + mapName, "");
    }

    private void setSavedAssoc(String mapName, String layerName) {
        Preferences preferences = Pref.getPrefRoot().node(IOTool.getIOTool().prefs.relativePath());
        preferences.put("GDSMappingFor" + mapName, layerName);
    }

    private static class OKUpdate
    extends Job {
        private Setting.SettingChangeBatch changeBatch;

        private OKUpdate(Setting.SettingChangeBatch changeBatch) {
            super("Update GDS Mapping", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.changeBatch = changeBatch;
        }

        @Override
        public boolean doIt() throws JobException {
            this.getDatabase().implementSettingChanges(this.changeBatch);
            return true;
        }

        @Override
        public void terminateOK() {
        }
    }

    private static class MapLine {
        String name;
        int layer;
        int type;

        private MapLine() {
        }
    }
}

