/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.util.math.FixpRectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PortInst
extends ElectricObject
implements SteinerTree.SteinerTreePort {
    private final NodeInst nodeInst;
    private final PortProto portProto;

    private PortInst(PortProto portProto, NodeInst nodeInst) {
        this.portProto = portProto;
        this.nodeInst = nodeInst;
    }

    private Object writeReplace() throws NotSerializableException {
        if (!this.isLinked()) {
            throw new NotSerializableException(this + " not linked");
        }
        return this;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.nodeInst.getProto() != this.portProto.getParent()) {
            throw new InvalidObjectException("PortInst");
        }
        PortInst pi = this.nodeInst.findPortInstFromProto(this.portProto);
        if (pi == null) {
            throw new InvalidObjectException("PortInst");
        }
        return pi;
    }

    @Override
    public ImmutablePortInst getD() {
        return this.nodeInst.getD().getPortInst(this.portProto.getId());
    }

    @Override
    public void addVar(Variable var) {
        this.nodeInst.addVar(this.portProto.getId(), var);
    }

    @Override
    public void delVar(Variable.Key key) {
        this.nodeInst.delVar(this.portProto.getId(), key);
    }

    public void delVars() {
        this.nodeInst.delVars(this.portProto.getId());
        assert (this.getNumVariables() == 0);
    }

    public static PortInst newInstance(PortProto portProto, NodeInst nodeInst) {
        PortInst pi = new PortInst(portProto, nodeInst);
        return pi;
    }

    public NodeInst getNodeInst() {
        return this.nodeInst;
    }

    public PortProto getPortProto() {
        return this.portProto;
    }

    public final int getPortIndex() {
        return this.portProto.getPortIndex();
    }

    public boolean hasConnections() {
        return this.nodeInst.hasConnections(this.portProto.getId());
    }

    public Iterator<Connection> getConnections() {
        return this.nodeInst.getConnections(this.portProto.getId());
    }

    public Iterator<Export> getExports() {
        return this.nodeInst.getExports(this.portProto.getId());
    }

    public FixpRectangle getBounds() {
        return this.getPoly().getBounds2D();
    }

    @Override
    public EPoint getCenter() {
        return this.getPoly().getCenter();
    }

    public Poly getPoly() {
        return this.nodeInst.getShapeOfPort(this.portProto);
    }

    @Override
    public void addDisplayableVariables(Rectangle2D rect, List<Poly> polys, EditWindow0 wnd, boolean multipleStrings, boolean showTempNames) {
        int startOfMyPolys = polys.size();
        super.addDisplayableVariables(this.getBounds(), polys, wnd, multipleStrings, showTempNames);
        for (int i = startOfMyPolys; i < polys.size(); ++i) {
            polys.get(i).setPort(this.getPortProto());
        }
    }

    public String describe(boolean withQuotes) {
        String info = this.nodeInst.describe(false) + "." + this.portProto.getName();
        return withQuotes ? "'" + info + "'" : info;
    }

    @Override
    public String toString() {
        return "port " + this.describe(true);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly noPoly;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortInst no = (PortInst)obj;
        HashSet<Connection> noCheckAgain = new HashSet<Connection>();
        Iterator<Connection> it = this.getConnections();
        while (it.hasNext()) {
            Connection c = it.next();
            boolean found = false;
            Iterator<Connection> noIt = no.getConnections();
            while (noIt.hasNext()) {
                Connection noC = noIt.next();
                if (noCheckAgain.contains(noC) || !c.getLocation().equals(noC.getLocation())) continue;
                found = true;
                noCheckAgain.add(noC);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding port " + this + " found in " + no + " at the location " + c.getLocation() + " \n");
            }
            return false;
        }
        Poly poly = this.getPoly();
        boolean check2 = poly.compare(noPoly = no.getPoly(), buffer);
        if (!check2 && buffer != null) {
            buffer.append("No same ports detected in " + this.portProto.getName() + " and " + no.getPortProto().getName() + "\n");
        }
        return check2;
    }

    @Override
    public boolean isLinked() {
        try {
            return this.nodeInst != null && this.nodeInst.isLinked() && this.nodeInst.getPortInst(this.getPortIndex()) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public EDatabase getDatabase() {
        return this.nodeInst.getDatabase();
    }

    public Poly computeTextPoly(EditWindow0 wnd, Variable var, Name name) {
        Poly poly = null;
        if (var != null) {
            FixpRectangle bounds = this.getPoly().getBounds2D();
            LinkedList<Poly> polys = new LinkedList<Poly>();
            this.addPolyList(polys, var, ((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY(), wnd, false);
            if (!polys.isEmpty()) {
                poly = polys.getFirst();
                poly.transform(this.getNodeInst().rotateOut());
            }
        }
        if (poly != null) {
            poly.setExactTextBounds(wnd, this);
        }
        return poly;
    }
}

