/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.btree.unboxed.LatticeOperation;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedComparable;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedHalfDouble;
import com.sun.electric.tool.simulation.BTreeSignal;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.SweptSample;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class ScalarSample
implements Sample,
Comparable<Object> {
    private double value;
    public static final UnboxedComparable<ScalarSample> unboxer = new UnboxedComparable<ScalarSample>(){

        @Override
        public int getSize() {
            return UnboxedHalfDouble.instance.getSize();
        }

        @Override
        public ScalarSample deserialize(byte[] buf, int ofs) {
            return new ScalarSample(UnboxedHalfDouble.instance.deserialize(buf, ofs));
        }

        @Override
        public void serialize(ScalarSample v, byte[] buf, int ofs) {
            UnboxedHalfDouble.instance.serialize(new Double(v.value), buf, ofs);
        }

        @Override
        public int compare(byte[] buf1, int ofs1, byte[] buf2, int ofs2) {
            return UnboxedHalfDouble.instance.compare(buf1, ofs1, buf2, ofs2);
        }
    };
    static final LatticeOperation<ScalarSample> latticeOp = new LatticeOperation<ScalarSample>(unboxer){

        @Override
        public void glb(byte[] buf1, int ofs1, byte[] buf2, int ofs2, byte[] dest, int dest_ofs) {
            if (UnboxedHalfDouble.instance.compare(buf1, ofs1, buf2, ofs2) < 0) {
                System.arraycopy(buf1, ofs1, dest, dest_ofs, unboxer.getSize());
            } else {
                System.arraycopy(buf2, ofs2, dest, dest_ofs, unboxer.getSize());
            }
        }

        @Override
        public void lub(byte[] buf1, int ofs1, byte[] buf2, int ofs2, byte[] dest, int dest_ofs) {
            if (UnboxedHalfDouble.instance.compare(buf1, ofs1, buf2, ofs2) < 0) {
                System.arraycopy(buf2, ofs2, dest, dest_ofs, unboxer.getSize());
            } else {
                System.arraycopy(buf1, ofs1, dest, dest_ofs, unboxer.getSize());
            }
        }
    };

    public ScalarSample() {
        this(0.0);
    }

    public ScalarSample(double value2) {
        this.value = value2;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ScalarSample)) {
            return false;
        }
        ScalarSample ss = (ScalarSample)o;
        return ss.value == this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l & 0xFFFFFFFFFFFFFFFFL) ^ (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int compareTo(Object o) {
        if (o == null || !(o instanceof ScalarSample)) {
            throw new RuntimeException("impossible!");
        }
        ScalarSample ss = (ScalarSample)o;
        return Double.compare(this.value, ss.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public boolean isLogicX() {
        return this.value == Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isLogicZ() {
        return this.value == Double.NEGATIVE_INFINITY;
    }

    @Override
    public Sample glb(Sample s) {
        if (!(s instanceof ScalarSample)) {
            throw new RuntimeException("tried to call ScalarSample.glb(" + s.getClass().getName() + ")");
        }
        return this.value < ((ScalarSample)s).value ? this : s;
    }

    @Override
    public Sample lub(Sample s) {
        if (!(s instanceof ScalarSample)) {
            throw new RuntimeException("tried to call ScalarSample.lub(" + s.getClass().getName() + ")");
        }
        return this.value > ((ScalarSample)s).value ? this : s;
    }

    @Override
    public double getMinValue() {
        return this.value;
    }

    @Override
    public double getMaxValue() {
        return this.value;
    }

    public static void plotSig(MutableSignal<?> sig, Panel panel, Graphics g, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
        int linePointMode = panel.getWaveWindow().getLinePointMode();
        Dimension sz = panel.getSize();
        MutableSignal<?> as = sig;
        int s = 0;
        MutableSignal<?> wave = as;
        if (wave.isEmpty()) {
            return;
        }
        Signal.View waveform = wave.getRasterView(panel.convertXScreenToData(0), panel.convertXScreenToData(sz.width), sz.width);
        Signal.View<RangeSample<?>> xWaveform = null;
        if (xAxisSignal != null) {
            xWaveform = xAxisSignal.getRasterView(panel.convertXScreenToData(0), panel.convertXScreenToData(sz.width), sz.width);
        }
        int lastX = 0;
        int lastLY = 0;
        int lastHY = 0;
        boolean first = true;
        for (int i = 0; i < waveform.getNumEvents(); ++i) {
            RangeSample samp = waveform.getSample(i);
            if (samp == null) continue;
            int lowY = panel.convertYDataToScreen(((ScalarSample)samp.getMin()).getValue());
            int highY = panel.convertYDataToScreen(((ScalarSample)samp.getMax()).getValue());
            int x2 = panel.convertXDataToScreen(waveform.getTime(i));
            if (xWaveform != null) {
                int xEventNum = waveform.getNumEvents() * i / xWaveform.getNumEvents();
                RangeSample<?> xSampRange = xWaveform.getSample(xEventNum);
                Object xSamp = xSampRange.getMin();
                if (xSamp instanceof SweptSample) {
                    xSamp = ((SweptSample)xSamp).getSweep(0);
                }
                x2 = panel.convertXDataToScreen(((ScalarSample)xSamp).getValue());
            }
            if (linePointMode <= 1) {
                if (!first) {
                    if (lastLY != lastHY || lowY != highY) {
                        if (g != null) {
                            g.setColor(light);
                        }
                        panel.processALine(g, lastX, lastHY, lastX, lastLY, bounds, forPs, selectedObjects, ws, s);
                        panel.processALine(g, x2, highY, x2, lowY, bounds, forPs, selectedObjects, ws, s);
                        if (g != null) {
                            g.setColor(ws.getColor());
                        }
                        panel.processALine(g, lastX, lastHY, x2, highY, bounds, forPs, selectedObjects, ws, s);
                    }
                    panel.processALine(g, lastX, lastLY, x2, lowY, bounds, forPs, selectedObjects, ws, s);
                }
                first = false;
            }
            if (linePointMode >= 1) {
                panel.processABox(g, x2 - 2, lowY - 2, x2 + 2, lowY + 2, bounds, forPs, selectedObjects, ws, false, 0.0);
            }
            lastX = x2;
            lastLY = lowY;
            lastHY = highY;
        }
    }

    public static MutableSignal<ScalarSample> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext) {
        BTreeSignal<ScalarSample> ret = new BTreeSignal<ScalarSample>(sc, sd, signalName, signalContext, false, BTreeSignal.getTree(unboxer, latticeOp, sd)){

            @Override
            public void plot(Panel panel, Graphics g, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
                ScalarSample.plotSig(this, panel, g, ws, light, forPs, bounds, selectedObjects, xAxisSignal);
            }
        };
        return ret;
    }

    public static MutableSignal<ScalarSample> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, double[] time, double[] values2) {
        if (values2.length == 0) {
            throw new RuntimeException("attempt to create an empty signal");
        }
        MutableSignal<ScalarSample> as = ScalarSample.createSignal(sc, sd, signalName, signalContext);
        for (int i = 0; i < time.length; ++i) {
            if (as.getSample(time[i]) != null) continue;
            as.addSample(time[i], new ScalarSample(values2[i]));
        }
        return as;
    }
}

