/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sandbox;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.text.Version;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.sandbox.ESandBox;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class TechExplorer
extends ESandBox {
    public static void main(String[] args) {
        try {
            String fileName = args[0];
            File electricJar = new File(fileName);
            if (!electricJar.exists()) {
                throw new FileNotFoundException(fileName);
            }
            TechExplorer m = new TechExplorer(electricJar);
            InputStream commandStream = System.in;
            if (args.length >= 2) {
                String commands = "initTechnologies\ndumpAll " + args[1] + "\n" + "";
                byte[] buf = commands.getBytes();
                assert (buf.length == commands.length());
                commandStream = new ByteArrayInputStream(buf);
            }
            m.loop(commandStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TechExplorer(File electricJar) throws IOException, ClassNotFoundException, MalformedURLException, IllegalAccessException {
        super(electricJar.toURI().toURL());
    }

    public void initTechnologies(String args) throws IllegalAccessException, InvocationTargetException {
        if (this.Undo_changesQuiet != null) {
            this.Undo_changesQuiet.invoke(null, Boolean.TRUE);
        }
        if (this.Tool_initProjectSettings != null) {
            this.Tool_initProjectSettings.invoke(this.User_getUserTool.invoke(null, new Object[0]), new Object[0]);
        }
        this.Technology_initAllTechnologies.invoke(null, new Object[0]);
    }

    public void dumpAll(String fileName) throws IllegalAccessException, InvocationTargetException {
        String version = this.Version_getVersion.invoke(null, new Object[0]).toString();
        Xml.Version v = new Xml.Version();
        v.electricVersion = Version.parseVersion(version);
        v.techVersion = 1;
        Iterator tit = (Iterator)this.Technology_getTechnologies.invoke(null, new Object[0]);
        while (tit.hasNext()) {
            Object tech = tit.next();
            String techName = (String)this.Technology_getTechName.invoke(tech, new Object[0]);
            Xml.Technology t = this.makeXml(techName);
            t.writeXml(fileName.replaceAll("lst", techName + "\\.xml"));
        }
    }

    public void dumpPrefs(String fileName) throws IOException {
        PrintWriter out = new PrintWriter(fileName);
        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName.replaceAll("\\.lst", "\\.bin"))));
        this.dumpPrefs(out, dout);
        out.close();
        dout.close();
    }

    private void dumpPrefs(PrintWriter out, DataOutputStream dout) throws IOException {
        try {
            Object factoryValue;
            String version = this.Version_getVersion.invoke(null, new Object[0]).toString();
            Xml.Version v = new Xml.Version();
            v.electricVersion = Version.parseVersion(version);
            v.techVersion = 1;
            out.println("Version " + version);
            dout.writeUTF(version);
            Iterator tit = (Iterator)this.Technology_getTechnologies.invoke(null, new Object[0]);
            while (tit.hasNext()) {
                Object tech = tit.next();
                String techName = (String)this.Technology_getTechName.invoke(tech, new Object[0]);
                assert (techName.length() > 0);
                out.println("Technology " + techName);
                dout.writeUTF(techName);
                Iterator it = (Iterator)this.Technology_getLayers.invoke(tech, new Object[0]);
                while (it.hasNext()) {
                    Object layer = it.next();
                    String layerName = (String)this.Layer_getName.invoke(layer, new Object[0]);
                    assert (layerName.length() > 0);
                    Object pseudoLayer = null;
                    if (this.Layer_getPseudoLayer != null) {
                        pseudoLayer = this.Layer_getPseudoLayer.invoke(layer, new Object[0]);
                    }
                    out.print("Layer " + layerName);
                    dout.writeUTF(layerName);
                    String pseudoLayerName = "";
                    if (pseudoLayer != null) {
                        pseudoLayerName = (String)this.Layer_getName.invoke(pseudoLayer, new Object[0]);
                        assert (pseudoLayerName.length() > 0);
                        out.print(" " + pseudoLayerName);
                    }
                    dout.writeUTF(pseudoLayerName);
                    out.println();
                }
                dout.writeUTF("");
                it = (Iterator)this.Technology_getArcs.invoke(tech, new Object[0]);
                while (it.hasNext()) {
                    Object ap = it.next();
                    String arcName = (String)this.ArcProto_getName.invoke(ap, new Object[0]);
                    out.println("Arc " + arcName);
                    dout.writeUTF(arcName);
                }
                dout.writeUTF("");
                it = (Iterator)this.Technology_getNodes.invoke(tech, new Object[0]);
                while (it.hasNext()) {
                    Object pn = it.next();
                    String nodeName = (String)this.PrimitiveNode_getName.invoke(pn, new Object[0]);
                    out.println("Node " + nodeName);
                    dout.writeUTF(nodeName);
                }
                dout.writeUTF("");
            }
            dout.writeUTF("");
            if (this.Setting_getSettings != null) {
                Collection allSettings = (Collection)this.Setting_getSettings.invoke(null, new Object[0]);
                for (Object setting : allSettings) {
                    String xmlPath = (String)this.Setting_getXmlPath.invoke(setting, new Object[0]);
                    Preferences prefs = (Preferences)this.Setting_prefs.get(setting);
                    String prefName = (String)this.Setting_getPrefName.invoke(setting, new Object[0]);
                    String prefPath = prefs.absolutePath() + "/" + prefName;
                    factoryValue = this.Setting_getFactoryValue.invoke(setting, new Object[0]);
                    out.println("Setting " + xmlPath + " " + prefPath + " <" + factoryValue + ">");
                    assert (xmlPath.length() > 0);
                    dout.writeUTF(xmlPath);
                    dout.writeUTF(prefPath);
                }
            }
            dout.writeUTF("");
            List allPrefs = (List)this.Pref_allPrefs.get(null);
            for (Object pref : allPrefs) {
                Preferences prefs = (Preferences)this.Pref_prefs.get(pref);
                String prefName = (String)this.Pref_getPrefName.invoke(pref, new Object[0]);
                String prefPath = prefs.absolutePath() + "/" + prefName;
                boolean isMeaning = this.Pref_getMeaning != null && this.Pref_getMeaning.invoke(pref, new Object[0]) != null;
                factoryValue = this.Pref_getFactoryValue.invoke(pref, new Object[0]);
                out.println((isMeaning ? "Mean " : "Pref ") + prefPath + " <" + factoryValue + ">");
                dout.writeUTF(prefPath);
                dout.writeBoolean(isMeaning);
            }
            dout.writeUTF("");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Xml.Technology makeXml(String techName) throws IllegalAccessException, InvocationTargetException {
        Object[][] origPalette;
        Object tech = this.Technology_findTechnology.invoke(null, techName);
        Xml.Technology t = new Xml.Technology();
        t.techName = techName;
        t.className = tech.getClass().getName();
        if (t.className.equals("com.sun.electric.technology.Technology")) {
            t.className = null;
        }
        Xml.Version version = new Xml.Version();
        String versionStr = this.Version_getVersion.invoke(null, new Object[0]).toString();
        version.techVersion = 1;
        version.electricVersion = Version.parseVersion("8.05g");
        t.versions.add(version);
        version = new Xml.Version();
        version.techVersion = 2;
        version.electricVersion = Version.parseVersion("8.05o");
        t.versions.add(version);
        t.shortTechName = (String)this.Technology_getTechShortName.invoke(tech, new Object[0]);
        t.description = (String)this.Technology_getTechDesc.invoke(tech, new Object[0]);
        t.scaleValue = (Double)this.Technology_getScale.invoke(tech, new Object[0]);
        t.scaleRelevant = (Boolean)this.Technology_isScaleRelevant.invoke(tech, new Object[0]);
        t.defaultFoundry = "NONE";
        if (this.Technology_getPrefFoundry != null) {
            t.defaultFoundry = this.Technology_getPrefFoundry.invoke(tech, new Object[0]).toString();
        }
        t.minResistance = (Double)this.Technology_getMinResistance.invoke(tech, new Object[0]);
        t.minCapacitance = (Double)this.Technology_getMinCapacitance.invoke(tech, new Object[0]);
        int numTransparentLayers = (Integer)this.Technology_getNumTransparentLayers.invoke(tech, new Object[0]);
        if (numTransparentLayers > 0) {
            Color[] colorMap = (Color[])this.Technology_getColorMap.invoke(tech, new Object[0]);
            for (int i = 0; i < numTransparentLayers; ++i) {
                Color transparentColor = colorMap[1 << i];
                t.transparentLayers.add(transparentColor);
            }
        }
        int maxMetal = 0;
        Iterator it = (Iterator)this.Technology_getLayers.invoke(tech, new Object[0]);
        while (it.hasNext()) {
            Object layer = it.next();
            String layerName = (String)this.Layer_getName.invoke(layer, new Object[0]);
            Object pseudoLayer = null;
            if (this.Layer_getPseudoLayer != null) {
                pseudoLayer = this.Layer_getPseudoLayer.invoke(layer, new Object[0]);
            }
            String pseudoLayerName = "";
            if (pseudoLayer != null) {
                pseudoLayerName = (String)this.Layer_getName.invoke(pseudoLayer, new Object[0]);
            }
            int extraFun = (Integer)this.Layer_getFunctionExtras.invoke(layer, new Object[0]);
            int PSEUDO = 4096;
            if ((extraFun & 0x1000) != 0 || this.Layer_isPseudoLayer != null && ((Boolean)this.Layer_isPseudoLayer.invoke(layer, new Object[0])).booleanValue()) continue;
            Xml.Layer l = new Xml.Layer();
            l.name = layerName;
            Object fun = this.Layer_getFunction.invoke(layer, new Object[0]);
            Layer.Function function = l.function = fun != null ? (Layer.Function)((Object)this.LayerFunctions.get(fun)) : Layer.Function.UNKNOWN;
            if (l.function.isMetal()) {
                maxMetal = Math.max(maxMetal, l.function.getLevel());
            }
            l.extraFunction = extraFun;
            Object desc = this.Layer_getGraphics.invoke(layer, new Object[0]);
            boolean displayPatterned = (Boolean)this.EGraphics_isPatternedOnDisplay.invoke(desc, new Object[0]);
            boolean printPatterned = (Boolean)this.EGraphics_isPatternedOnPrinter.invoke(desc, new Object[0]);
            EGraphics.Outline outlineWhenPatterned = EGraphics.Outline.NOPAT;
            if (this.EGraphics_getOutlined != null) {
                Object outline = this.EGraphics_getOutlined.invoke(desc, new Object[0]);
                if (outline != null) {
                    outlineWhenPatterned = (EGraphics.Outline)((Object)this.EGraphicsOutlines.get(outline));
                }
            } else {
                if (this.EGraphics_isOutlinedOnDisplay != null && ((Boolean)this.EGraphics_isOutlinedOnDisplay.invoke(desc, new Object[0])).booleanValue()) {
                    outlineWhenPatterned = EGraphics.Outline.PAT_S;
                }
                if (this.EGraphics_isOutlinedOnPrinter != null && ((Boolean)this.EGraphics_isOutlinedOnPrinter.invoke(desc, new Object[0])).booleanValue()) {
                    outlineWhenPatterned = EGraphics.Outline.PAT_S;
                }
            }
            int transparentLayer = (Integer)this.EGraphics_getTransparentLayer.invoke(desc, new Object[0]);
            Color color = (Color)this.EGraphics_getColor.invoke(desc, new Object[0]);
            double opacity = (Double)this.EGraphics_getOpacity.invoke(desc, new Object[0]);
            boolean foreground = (Boolean)this.EGraphics_getForeground.invoke(desc, new Object[0]);
            int[] pattern = (int[])this.EGraphics_getPattern.invoke(desc, new Object[0]);
            l.desc = new EGraphics(displayPatterned, printPatterned, outlineWhenPatterned, transparentLayer, color.getRed(), color.getGreen(), color.getBlue(), opacity, foreground, pattern);
            l.thick3D = (Double)this.Layer_getThickness.invoke(layer, new Object[0]);
            if (this.Layer_getDistance != null) {
                l.height3D = (Double)this.Layer_getDistance.invoke(layer, new Object[0]);
            } else if (this.Layer_getHeight != null) {
                l.height3D = (Double)this.Layer_getHeight.invoke(layer, new Object[0]);
            }
            if (this.Layer_getTransparencyMode != null) {
                l.mode3D = (String)this.Layer_getTransparencyMode.invoke(layer, new Object[0]);
            }
            if (this.Layer_getTransparencyFactor != null) {
                l.factor3D = (Double)this.Layer_getTransparencyFactor.invoke(layer, new Object[0]);
            }
            l.cif = (String)this.Layer_getCIFLayer.invoke(layer, new Object[0]);
            l.skill = (String)this.Layer_getSkillLayer.invoke(layer, new Object[0]);
            l.resistance = (Double)this.Layer_getResistance.invoke(layer, new Object[0]);
            l.capacitance = (Double)this.Layer_getCapacitance.invoke(layer, new Object[0]);
            l.edgeCapacitance = (Double)this.Layer_getEdgeCapacitance.invoke(layer, new Object[0]);
            t.layers.add(l);
        }
        if (this.Technology_getNumMetals != null) {
            maxMetal = (Integer)this.Technology_getNumMetals.invoke(tech, new Object[0]);
        }
        t.maxNumMetals = t.defaultNumMetals = maxMetal;
        t.minNumMetals = t.defaultNumMetals;
        Map oldArcNames = this.Technology_getOldArcNames != null ? (Map)this.Technology_getOldArcNames.invoke(tech, new Object[0]) : Collections.emptyMap();
        Iterator it2 = (Iterator)this.Technology_getArcs.invoke(tech, new Object[0]);
        while (it2.hasNext()) {
            Object[] arcLayers;
            Object ap = it2.next();
            String arcName = (String)this.ArcProto_getName.invoke(ap, new Object[0]);
            Xml.ArcProto a = new Xml.ArcProto();
            a.name = arcName;
            for (Map.Entry e : oldArcNames.entrySet()) {
                if (e.getValue() != ap) continue;
                a.oldName = (String)e.getKey();
            }
            a.function = (ArcProto.Function)((Object)this.ArcProtoFunctions.get(this.ArcProto_getFunction.invoke(ap, new Object[0])));
            a.wipable = (Boolean)this.ArcProto_isWipable.invoke(ap, new Object[0]);
            a.curvable = (Boolean)this.ArcProto_isCurvable.invoke(ap, new Object[0]);
            a.special = this.ArcProto_isSpecialArc != null && (Boolean)this.ArcProto_isSpecialArc.invoke(ap, new Object[0]) != false;
            a.skipSizeInPalette = this.ArcProto_isSkipSizeInPalette != null && (Boolean)this.ArcProto_isSkipSizeInPalette.invoke(ap, new Object[0]) != false;
            a.notUsed = (Boolean)this.ArcProto_isNotUsed.invoke(ap, new Object[0]);
            a.extended = (Boolean)this.ArcProto_isExtended.invoke(ap, new Object[0]);
            a.fixedAngle = (Boolean)this.ArcProto_isFixedAngle.invoke(ap, new Object[0]);
            a.angleIncrement = (Integer)this.ArcProto_getAngleIncrement.invoke(ap, new Object[0]);
            if (this.ERC_getAntennaRatio != null) {
                a.antennaRatio = (Double)this.ERC_getAntennaRatio.invoke(this.ERC_tool.get(null), ap);
            } else if (this.ArcProto_getAntennaRatio != null) {
                a.antennaRatio = (Double)this.ArcProto_getAntennaRatio.invoke(ap, new Object[0]);
            }
            double defaultFullWidth = 0.0;
            if (this.ArcProto_getDefaultLambdaFullWidth != null) {
                defaultFullWidth = (Double)this.ArcProto_getDefaultLambdaFullWidth.invoke(ap, new Object[0]);
            } else if (this.ArcProto_getDefaultWidth != null) {
                defaultFullWidth = (Double)this.ArcProto_getDefaultWidth.invoke(ap, new Object[0]);
            }
            double widthOffset = 0.0;
            if (this.ArcProto_getLambdaWidthOffset != null) {
                widthOffset = (Double)this.ArcProto_getLambdaWidthOffset.invoke(ap, new Object[0]);
            } else if (this.ArcProto_getWidthOffset != null) {
                widthOffset = (Double)this.ArcProto_getWidthOffset.invoke(ap, new Object[0]);
            }
            if (widthOffset != 0.0) {
                a.diskOffset.put(1, TechExplorer.round(0.5 * defaultFullWidth));
                a.diskOffset.put(2, TechExplorer.round(0.5 * (defaultFullWidth - widthOffset)));
            } else {
                a.diskOffset.put(2, TechExplorer.round(0.5 * defaultFullWidth));
            }
            for (Object arcLayer : arcLayers = (Object[])this.ArcProto_layers.get(ap)) {
                Xml.ArcLayer al = new Xml.ArcLayer();
                al.layer = (String)this.Layer_getName.invoke(this.TechnologyArcLayer_getLayer.invoke(arcLayer, new Object[0]), new Object[0]);
                al.style = (Poly.Type)((Object)this.PolyTypes.get(this.TechnologyArcLayer_getStyle.invoke(arcLayer, new Object[0])));
                double offset = 0.0;
                if (this.TechnologyArcLayer_getLambdaOffset != null) {
                    offset = (Double)this.TechnologyArcLayer_getLambdaOffset.invoke(arcLayer, new Object[0]);
                } else if (this.TechnologyArcLayer_getOffset != null) {
                    offset = (Double)this.TechnologyArcLayer_getOffset.invoke(arcLayer, new Object[0]);
                }
                al.extend.value = TechExplorer.round(0.5 * (defaultFullWidth - offset));
                a.arcLayers.add(al);
            }
            t.arcs.add(a);
        }
        Map oldNodeNames = this.Technology_getOldNodeNames != null ? (Map)this.Technology_getOldNodeNames.invoke(tech, new Object[0]) : Collections.emptyMap();
        Iterator it3 = (Iterator)this.Technology_getNodes.invoke(tech, new Object[0]);
        while (it3.hasNext()) {
            EPoint minFullSize;
            Object pn = it3.next();
            String nodeName = (String)this.PrimitiveNode_getName.invoke(pn, new Object[0]);
            PrimitiveNode.Function fun = (PrimitiveNode.Function)((Object)this.PrimitiveNodeFunctions.get(this.PrimitiveNode_getFunction.invoke(pn, new Object[0])));
            Object[] nodeLayersArray = (Object[])this.PrimitiveNode_getLayers.invoke(pn, new Object[0]);
            double defWidth = (Double)this.PrimitiveNode_getDefWidth.invoke(pn, new Object[0]);
            double defHeight = (Double)this.PrimitiveNode_getDefHeight.invoke(pn, new Object[0]);
            Iterator ports = (Iterator)this.PrimitiveNode_getPorts.invoke(pn, new Object[0]);
            if (fun == PrimitiveNode.Function.NODE && nodeLayersArray.length == 1) {
                Object[] connections;
                Xml.PureLayerNode pln = new Xml.PureLayerNode();
                pln.name = nodeName;
                for (Map.Entry e : oldNodeNames.entrySet()) {
                    if (e.getValue() != pn) continue;
                    pln.oldName = (String)e.getKey();
                }
                Object port = ports.next();
                pln.port = (String)this.PrimitivePort_getName.invoke(port, new Object[0]);
                pln.style = (Poly.Type)((Object)this.PolyTypes.get(this.TechnologyNodeLayer_getStyle.invoke(nodeLayersArray[0], new Object[0])));
                pln.size.value = TechExplorer.round(defWidth);
                for (Object ap : connections = (Object[])this.PrimitivePort_getConnections.invoke(port, new Object[0])) {
                    String arcName = (String)this.ArcProto_getName.invoke(ap, new Object[0]);
                    if (this.Technology_findArcProto.invoke(tech, arcName) != ap) continue;
                    pln.portArcs.add(arcName);
                }
                Xml.Layer layer = t.findLayer((String)this.Layer_getName.invoke(this.TechnologyNodeLayer_getLayer.invoke(nodeLayersArray[0], new Object[0]), new Object[0]));
                layer.pureLayerNode = pln;
                continue;
            }
            Xml.PrimitiveNode n = new Xml.PrimitiveNode();
            n.name = nodeName;
            for (Map.Entry e : oldNodeNames.entrySet()) {
                if (e.getValue() != pn) continue;
                n.oldName = (String)e.getKey();
            }
            n.function = fun;
            n.shrinkArcs = (Boolean)this.PrimitiveNode_isArcsShrink.invoke(pn, new Object[0]);
            n.square = (Boolean)this.PrimitiveNode_isSquare.invoke(pn, new Object[0]);
            n.canBeZeroSize = (Boolean)this.PrimitiveNode_isCanBeZeroSize.invoke(pn, new Object[0]);
            n.wipes = (Boolean)this.PrimitiveNode_isWipeOn1or2.invoke(pn, new Object[0]);
            n.lockable = (Boolean)this.PrimitiveNode_isLockedPrim.invoke(pn, new Object[0]);
            n.edgeSelect = (Boolean)this.PrimitiveNode_isEdgeSelect.invoke(pn, new Object[0]);
            if (this.PrimitiveNode_isSkipSizeInPalette != null) {
                n.skipSizeInPalette = (Boolean)this.PrimitiveNode_isSkipSizeInPalette.invoke(pn, new Object[0]);
            }
            n.notUsed = (Boolean)this.PrimitiveNode_isNotUsed.invoke(pn, new Object[0]);
            if (this.PrimitiveNode_LOWVTBIT != null) {
                n.lowVt = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_LOWVTBIT.get(null));
            }
            if (this.PrimitiveNode_HIGHVTBIT != null) {
                n.highVt = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_HIGHVTBIT.get(null));
            }
            if (this.PrimitiveNode_NATIVEBIT != null) {
                n.nativeBit = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_NATIVEBIT.get(null));
            }
            if (this.PrimitiveNode_OD18BIT != null) {
                n.od18 = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_OD18BIT.get(null));
            }
            if (this.PrimitiveNode_OD25BIT != null) {
                n.od25 = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_OD25BIT.get(null));
            }
            if (this.PrimitiveNode_OD33BIT != null) {
                n.od33 = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_OD33BIT.get(null));
            }
            SizeOffset so = null;
            Object sizeOffset = this.PrimitiveNode_getProtoSizeOffset.invoke(pn, new Object[0]);
            if (sizeOffset != null) {
                so = new SizeOffset((Double)this.SizeOffset_getLowXOffset.invoke(sizeOffset, new Object[0]), (Double)this.SizeOffset_getHighXOffset.invoke(sizeOffset, new Object[0]), (Double)this.SizeOffset_getLowYOffset.invoke(sizeOffset, new Object[0]), (Double)this.SizeOffset_getHighYOffset.invoke(sizeOffset, new Object[0]));
            }
            if (so.getLowXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getHighYOffset() == 0.0) {
                so = null;
            }
            double minWidth = 0.0;
            double minHeight = 0.0;
            String minSizeRule = null;
            if (this.classPrimitiveNodeNodeSizeRule != null) {
                Object rule = this.PrimitiveNode_getMinSizeRule.invoke(pn, new Object[0]);
                if (rule != null) {
                    minWidth = (Double)this.PrimitiveNodeNodeSizeRule_getWidth.invoke(rule, new Object[0]);
                    minHeight = (Double)this.PrimitiveNodeNodeSizeRule_getHeight.invoke(rule, new Object[0]);
                    minSizeRule = (String)this.PrimitiveNodeNodeSizeRule_getRuleName.invoke(rule, new Object[0]);
                }
            } else {
                minWidth = (Double)this.PrimitiveNode_getMinWidth.invoke(pn, new Object[0]);
                minHeight = (Double)this.PrimitiveNode_getMinHeight.invoke(pn, new Object[0]);
                minSizeRule = (String)this.PrimitiveNode_getMinSizeRule.invoke(pn, new Object[0]);
                if (minWidth == -1.0 && minHeight == -1.0 && minSizeRule.equals("")) {
                    minSizeRule = null;
                }
            }
            if (minSizeRule != null) {
                n.nodeSizeRule = new PrimitiveNode.NodeSizeRule(minWidth, minHeight, minSizeRule);
                minFullSize = EPoint.fromLambda(0.5 * minWidth, 0.5 * minHeight);
            } else {
                minFullSize = EPoint.fromLambda(0.5 * defWidth, 0.5 * defHeight);
            }
            if (so != null) {
                EPoint p2 = EPoint.fromGrid(minFullSize.getGridX() - (so.getLowXGridOffset() + so.getHighXGridOffset() >> 1), minFullSize.getGridY() - (so.getLowYGridOffset() + so.getHighYGridOffset() >> 1));
                n.diskOffset.put(1, minFullSize);
                n.diskOffset.put(2, p2);
            } else {
                n.diskOffset.put(2, minFullSize);
            }
            n.defaultWidth.value = TechExplorer.round(defWidth - 2.0 * minFullSize.getLambdaX());
            n.defaultHeight.value = TechExplorer.round(defHeight - 2.0 * minFullSize.getLambdaY());
            n.sizeOffset = so;
            List<Object> nodeLayers = Arrays.asList(nodeLayersArray);
            Object[] electricalNodeLayersArray = (Object[])this.PrimitiveNode_getElectricalLayers.invoke(pn, new Object[0]);
            List<Object> electricalNodeLayers = nodeLayers;
            if (electricalNodeLayersArray != null) {
                electricalNodeLayers = Arrays.asList(electricalNodeLayersArray);
            }
            boolean isSerp = (Integer)this.PrimitiveNode_getSpecialType.invoke(pn, new Object[0]) == 1;
            int m = 0;
            for (Object nld : electricalNodeLayers) {
                int j = nodeLayers.indexOf(nld);
                if (j < 0) {
                    n.nodeLayers.add(this.makeNodeLayerDetails(nld, isSerp, minFullSize, false, true));
                    continue;
                }
                while (m < j) {
                    n.nodeLayers.add(this.makeNodeLayerDetails(nodeLayers.get(m++), isSerp, minFullSize, true, false));
                }
                n.nodeLayers.add(this.makeNodeLayerDetails(nodeLayers.get(m++), isSerp, minFullSize, true, true));
            }
            while (m < nodeLayers.size()) {
                n.nodeLayers.add(this.makeNodeLayerDetails(nodeLayers.get(m++), isSerp, minFullSize, true, false));
            }
            Iterator pit = (Iterator)this.PrimitiveNode_getPorts.invoke(pn, new Object[0]);
            while (pit.hasNext()) {
                Object[] connections;
                Object pp = pit.next();
                Xml.PrimitivePort ppd = new Xml.PrimitivePort();
                ppd.name = (String)this.PrimitivePort_getName.invoke(pp, new Object[0]);
                ppd.portAngle = (Integer)this.PrimitivePort_getAngle.invoke(pp, new Object[0]);
                if (this.PrimitivePort_getAngleRange != null) {
                    ppd.portRange = (Integer)this.PrimitivePort_getAngleRange.invoke(pp, new Object[0]);
                } else {
                    int PORTARANGE = 130560;
                    int PORTARANGESH = 9;
                    ppd.portRange = ((Integer)this.PrimitivePort_lowLevelGetUserbits.invoke(pp, new Object[0]) & 0x1FE00) >> 9;
                }
                ppd.portTopology = (Integer)this.PrimitivePort_getTopology.invoke(pp, new Object[0]);
                Object lx = this.PrimitivePort_getLeft.invoke(pp, new Object[0]);
                Object hx = this.PrimitivePort_getRight.invoke(pp, new Object[0]);
                Object ly = this.PrimitivePort_getBottom.invoke(pp, new Object[0]);
                Object hy = this.PrimitivePort_getTop.invoke(pp, new Object[0]);
                ppd.lx.k = (Double)this.EdgeH_getMultiplier.invoke(lx, new Object[0]) * 2.0;
                ppd.lx.value = TechExplorer.round((Double)this.EdgeH_getAdder.invoke(lx, new Object[0]) + minFullSize.getLambdaX() * ppd.lx.k);
                ppd.hx.k = (Double)this.EdgeH_getMultiplier.invoke(hx, new Object[0]) * 2.0;
                ppd.hx.value = TechExplorer.round((Double)this.EdgeH_getAdder.invoke(hx, new Object[0]) + minFullSize.getLambdaX() * ppd.hx.k);
                ppd.ly.k = (Double)this.EdgeV_getMultiplier.invoke(ly, new Object[0]) * 2.0;
                ppd.ly.value = TechExplorer.round((Double)this.EdgeV_getAdder.invoke(ly, new Object[0]) + minFullSize.getLambdaY() * ppd.ly.k);
                ppd.hy.k = (Double)this.EdgeV_getMultiplier.invoke(hy, new Object[0]) * 2.0;
                ppd.hy.value = TechExplorer.round((Double)this.EdgeV_getAdder.invoke(hy, new Object[0]) + minFullSize.getLambdaY() * ppd.hy.k);
                for (Object ap : connections = (Object[])this.PrimitivePort_getConnections.invoke(pp, new Object[0])) {
                    String arcName = (String)this.ArcProto_getName.invoke(ap, new Object[0]);
                    if (this.Technology_findArcProto.invoke(tech, arcName) != ap) continue;
                    ppd.portArcs.add(arcName);
                }
                n.ports.add(ppd);
            }
            n.specialType = (Integer)this.PrimitiveNode_getSpecialType.invoke(pn, new Object[0]);
            double[] specialValues = (double[])this.PrimitiveNode_getSpecialValues.invoke(pn, new Object[0]);
            if (specialValues != null) {
                n.specialValues = (double[])specialValues.clone();
            }
            t.nodes.add(n);
        }
        TechExplorer.addSpiceHeader(t, 1, (String[])this.Technology_getSpiceHeaderLevel1.invoke(tech, new Object[0]));
        TechExplorer.addSpiceHeader(t, 2, (String[])this.Technology_getSpiceHeaderLevel2.invoke(tech, new Object[0]));
        TechExplorer.addSpiceHeader(t, 3, (String[])this.Technology_getSpiceHeaderLevel3.invoke(tech, new Object[0]));
        if (this.Technology_getNodesGrouped != null && (origPalette = (Object[][])this.Technology_getNodesGrouped.invoke(tech, new Object[0])) != null) {
            int numRows = origPalette.length;
            int numCols = origPalette[0].length;
            for (Object[] row : origPalette) {
                assert (row.length == numCols);
            }
            t.menuPalette = new Xml.MenuPalette();
            t.menuPalette.numColumns = numCols;
            for (int row = 0; row < numRows; ++row) {
                for (int col = 0; col < numCols; ++col) {
                    Object origEntry = origPalette[row][col];
                    Object newEntry = null;
                    ArrayList<Object> newBox = new ArrayList<Object>();
                    if (origEntry instanceof List) {
                        List list = (List)origEntry;
                        for (Object o : list) {
                            newBox.add(this.makeMenuEntry(t, o));
                        }
                    } else if (origEntry != null) {
                        newBox.add(this.makeMenuEntry(t, origEntry));
                    }
                    t.menuPalette.menuBoxes.add(newBox);
                }
            }
        }
        if (this.Technology_getFoundries != null) {
            Iterator fit;
            Object foundries = this.Technology_getFoundries.invoke(tech, new Object[0]);
            Iterator iterator = fit = foundries instanceof List ? ((List)foundries).iterator() : (Iterator)foundries;
            while (fit.hasNext()) {
                List rules;
                Object foundry = fit.next();
                Xml.Foundry f = new Xml.Foundry();
                f.name = foundry.toString();
                if (this.Foundry_getGDSLayers != null) {
                    Map gdsMap = (Map)this.Foundry_getGDSLayers.invoke(foundry, new Object[0]);
                    for (Map.Entry e : gdsMap.entrySet()) {
                        String gds = (String)e.getValue();
                        if (gds.length() == 0) continue;
                        Object layer = e.getKey();
                        f.layerGds.put((String)this.Layer_getName.invoke(layer, new Object[0]), gds);
                    }
                }
                if ((rules = (List)this.Foundry_getRules.invoke(foundry, new Object[0])) == null) continue;
                for (Object rule : rules) {
                    String ruleName = (String)this.DRCTemplate_ruleName.get(rule);
                    int when = (Integer)this.DRCTemplate_when.get(rule);
                    int TSMC = 4096;
                    int ST = 8192;
                    int MOSIS = 16384;
                    when &= 0xFFFF8FFF;
                    DRCTemplate.DRCRuleType type = (DRCTemplate.DRCRuleType)((Object)this.DRCTemplateDRCRuleTypes.get(this.DRCTemplate_ruleType.get(rule)));
                    if (type == null) continue;
                    double maxWidth = (Double)this.DRCTemplate_maxWidth.get(rule);
                    double minLength = (Double)this.DRCTemplate_minLength.get(rule);
                    String name1 = (String)this.DRCTemplate_name1.get(rule);
                    String name2 = (String)this.DRCTemplate_name2.get(rule);
                    double[] values = null;
                    if (this.DRCTemplate_values != null) {
                        values = (double[])this.DRCTemplate_values.get(rule);
                    } else if (this.DRCTemplate_value1 != null & this.DRCTemplate_value2 != null) {
                        values = new double[]{(Double)this.DRCTemplate_value1.get(rule), (Double)this.DRCTemplate_value2.get(rule)};
                    }
                    values = (double[])values.clone();
                    String nodeName = (String)this.DRCTemplate_nodeName.get(rule);
                    int multiCuts = (Integer)this.DRCTemplate_multiCuts.get(rule);
                    DRCTemplate r = null;
                    r = nodeName != null ? new DRCTemplate(ruleName, when, type, name1, name2, values, nodeName, null) : new DRCTemplate(ruleName, when, type, maxWidth, minLength, name1, name2, values, multiCuts);
                    f.rules.add(r);
                }
                t.foundries.add(f);
            }
        }
        return t;
    }

    private Xml.NodeLayer makeNodeLayerDetails(Object nodeLayer, boolean isSerp, EPoint correction, boolean inLayers, boolean inElectricalLayers) throws IllegalAccessException, InvocationTargetException {
        Xml.NodeLayer nld = new Xml.NodeLayer();
        Object layer = this.TechnologyNodeLayer_getLayer.invoke(nodeLayer, new Object[0]);
        layer = this.Layer_getNonPseudoLayer.invoke(layer, new Object[0]);
        nld.layer = (String)this.Layer_getName.invoke(layer, new Object[0]);
        nld.style = (Poly.Type)((Object)this.PolyTypes.get(this.TechnologyNodeLayer_getStyle.invoke(nodeLayer, new Object[0])));
        nld.portNum = (Integer)this.TechnologyNodeLayer_getPortNum.invoke(nodeLayer, new Object[0]);
        nld.inLayers = inLayers;
        nld.inElectricalLayers = inElectricalLayers;
        nld.representation = (Integer)this.TechnologyNodeLayer_getRepresentation.invoke(nodeLayer, new Object[0]);
        Object[] points = (Object[])this.TechnologyNodeLayer_getPoints.invoke(nodeLayer, new Object[0]);
        if (points != null) {
            if (nld.representation == 1 || nld.representation == 3) {
                Object lx = this.TechnologyTechPoint_getX.invoke(points[0], new Object[0]);
                Object hx = this.TechnologyTechPoint_getX.invoke(points[1], new Object[0]);
                Object ly = this.TechnologyTechPoint_getY.invoke(points[0], new Object[0]);
                Object hy = this.TechnologyTechPoint_getY.invoke(points[1], new Object[0]);
                nld.lx.k = (Double)this.EdgeH_getMultiplier.invoke(lx, new Object[0]) * 2.0;
                nld.lx.value = TechExplorer.round((Double)this.EdgeH_getAdder.invoke(lx, new Object[0]) + correction.getLambdaX() * nld.lx.k);
                nld.hx.k = (Double)this.EdgeH_getMultiplier.invoke(hx, new Object[0]) * 2.0;
                nld.hx.value = TechExplorer.round((Double)this.EdgeH_getAdder.invoke(hx, new Object[0]) + correction.getLambdaX() * nld.hx.k);
                nld.ly.k = (Double)this.EdgeV_getMultiplier.invoke(ly, new Object[0]) * 2.0;
                nld.ly.value = TechExplorer.round((Double)this.EdgeV_getAdder.invoke(ly, new Object[0]) + correction.getLambdaY() * nld.ly.k);
                nld.hy.k = (Double)this.EdgeV_getMultiplier.invoke(hy, new Object[0]) * 2.0;
                nld.hy.value = TechExplorer.round((Double)this.EdgeV_getAdder.invoke(hy, new Object[0]) + correction.getLambdaY() * nld.hy.k);
            } else {
                for (Object p : points) {
                    nld.techPoints.add(this.correction(p, correction));
                }
            }
        }
        if (this.TechnologyNodeLayer_getMulticutSizeX != null) {
            nld.sizex = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSizeX.invoke(nodeLayer, new Object[0]));
            nld.sizey = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSizeY.invoke(nodeLayer, new Object[0]));
            nld.sep1d = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSep1D.invoke(nodeLayer, new Object[0]));
            nld.sep2d = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSep2D.invoke(nodeLayer, new Object[0]));
        }
        if (isSerp) {
            nld.lWidth = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineLWidth.invoke(nodeLayer, new Object[0]));
            nld.rWidth = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineRWidth.invoke(nodeLayer, new Object[0]));
            nld.tExtent = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineExtentT.invoke(nodeLayer, new Object[0]));
            nld.bExtent = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineExtentB.invoke(nodeLayer, new Object[0]));
        }
        return nld;
    }

    private Technology.TechPoint correction(Object p, EPoint correction) throws IllegalAccessException, InvocationTargetException {
        Object oh = this.TechnologyTechPoint_getX.invoke(p, new Object[0]);
        double mx = (Double)this.EdgeH_getMultiplier.invoke(oh, new Object[0]);
        EdgeH h = new EdgeH(mx, (Double)this.EdgeH_getAdder.invoke(oh, new Object[0]) + correction.getLambdaX() * mx * 2.0);
        Object ov = this.TechnologyTechPoint_getY.invoke(p, new Object[0]);
        double my = (Double)this.EdgeV_getMultiplier.invoke(ov, new Object[0]);
        EdgeV v = new EdgeV(my, (Double)this.EdgeV_getAdder.invoke(ov, new Object[0]) + correction.getLambdaY() * my * 2.0);
        return new Technology.TechPoint(h, v);
    }

    private static void addSpiceHeader(Xml.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml.SpiceHeader spiceHeader = new Xml.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    private Object makeMenuEntry(Xml.Technology t, Object entry) throws IllegalAccessException, InvocationTargetException {
        if (this.classArcProto.isInstance(entry)) {
            return t.findArc((String)this.ArcProto_getName.invoke(entry, new Object[0]));
        }
        if (this.classPrimitiveNode.isInstance(entry)) {
            return t.findNode((String)this.PrimitiveNode_getName.invoke(entry, new Object[0]));
        }
        if (this.classNodeInst.isInstance(entry)) {
            Xml.MenuNodeInst n = new Xml.MenuNodeInst();
            n.protoName = (String)this.PrimitiveNode_getName.invoke(this.NodeInst_getProto.invoke(entry, new Object[0]), new Object[0]);
            n.function = (PrimitiveNode.Function)((Object)this.PrimitiveNodeFunctions.get(this.NodeInst_getFunction.invoke(entry, new Object[0])));
            Iterator it = (Iterator)this.ElectricObject_getVariables.invoke(entry, new Object[0]);
            while (it.hasNext()) {
                Object var = it.next();
                n.text = (String)this.Variable_getObject.invoke(var, new Object[0]);
                Object td = this.Variable_getTextDescriptor.invoke(var, new Object[0]);
                n.fontSize = (Double)this.TextDescriptorSize_getSize.invoke(this.TextDescriptor_getSize.invoke(td, new Object[0]), new Object[0]);
            }
            return n;
        }
        assert (entry instanceof String);
        return entry;
    }

    private static double round(double v) {
        v = DBMath.round(v);
        return v;
    }
}

