/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class ChangeCurrentLib
extends EDialog {
    private JList changeList;
    private DefaultListModel changeListModel;
    private JButton cancel;
    private JLabel currentLibrary;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JButton ok;

    public static void showDialog() {
        ChangeCurrentLib dialog = new ChangeCurrentLib((Frame)TopLevel.getCurrentJFrame(), false);
        dialog.setVisible(true);
    }

    private ChangeCurrentLib(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        Library currentLib = Library.getCurrent();
        if (currentLib != null) {
            this.currentLibrary.setText("Current Library: '" + Library.getCurrent().getName() + "'");
        } else {
            this.currentLibrary.setText("No Current Library Selected");
        }
        this.changeListModel = new DefaultListModel();
        this.changeList = new JList(this.changeListModel);
        this.changeList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.changeList);
        this.changeListModel.clear();
        for (Library lib : Library.getVisibleLibraries()) {
            this.changeListModel.addElement(lib.getName());
        }
        this.changeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChangeCurrentLib.this.okActionPerformed(null);
                }
            }
        });
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void initComponents() {
        this.currentLibrary = new JLabel();
        this.ok = new JButton();
        this.jLabel2 = new JLabel();
        this.cancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Set Current Library");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ChangeCurrentLib.this.closeDialog(evt);
            }
        });
        this.currentLibrary.setText("Current Library:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.currentLibrary, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeCurrentLib.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel2.setText("Switch to Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeCurrentLib.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(200, 200));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.pack();
    }

    public static void repaintAllAfterCurLibAction() {
        WindowFrame.wantToRedoTitleNames();
        WindowFrame.wantToRedoLibraryTree();
        EditWindow.repaintAll();
    }

    private void okActionPerformed(ActionEvent evt) {
        String libName = (String)this.changeList.getSelectedValue();
        Library lib = Library.findLibrary(libName);
        if (lib != null && lib != Library.getCurrent()) {
            lib.setCurrent();
            ChangeCurrentLib.repaintAllAfterCurLibAction();
        }
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

