/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.Routing;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SeaOfGates {
    private static final boolean DEBUGFAILURE = false;
    private static final boolean SEARCHINJUMPS = true;
    private static final boolean FASTERJUMPS = true;
    private static final int COSTALTERNATINGMETAL = 50;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 2;
    private static final int COSTUNFAVORED = 10;
    private static final int COSTTURNING = 1;
    private Cell cell;
    private Technology tech;
    private Map<Layer, RTNode> metalTrees;
    private Map<Layer, RTNode> viaTrees;
    private Map<ArcInst, Integer> netIDs;
    private int numMetalLayers;
    private Layer[] metalLayers;
    private Layer[] viaLayers;
    private ArcProto[] metalArcs;
    private boolean[] favorArcs;
    private boolean[] preventArcs;
    private MetalVias[] metalVias;
    private double[] layerSurround;
    private double[] viaSurround;
    private Map<Integer, Map<Integer, SearchVertex>>[] searchVertexPlanes;
    private int destX;
    private int destY;
    private int destZ;
    private double totalWireLength;
    private boolean firstFailure;

    public static void seaOfGatesRoute() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        Netlist netList = cell.acquireUserNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
            return;
        }
        Set<Network> nets = null;
        boolean didSelection = false;
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd != null && (nets = wnd.getHighlightedNetworks()).size() > 0) {
            didSelection = true;
        }
        if (!didSelection) {
            nets = new HashSet<Network>();
            Iterator<Network> it = netList.getNetworks();
            while (it.hasNext()) {
                nets.add(it.next());
            }
        }
        HashSet<Network> netsToRoute = new HashSet<Network>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            Network net;
            ArcInst ai = it.next();
            if (ai.getProto() != Generic.tech.unrouted_arc || !nets.contains(net = netList.getNetwork(ai, 0))) continue;
            netsToRoute.add(net);
        }
        if (netsToRoute.size() <= 0) {
            ui.showErrorMessage(didSelection ? "Must select one or more Unrouted Arcs" : "There are no Unrouted Arcs in this cell", "Routing Error");
            return;
        }
        ArrayList<NetsToRoute> orderedNetsToRoute = new ArrayList<NetsToRoute>();
        for (Network net : netsToRoute) {
            boolean isPwrGnd = false;
            Iterator<Export> it2 = net.getExports();
            while (it2.hasNext()) {
                Export e = it2.next();
                if (!e.isGround() && !e.isPower()) continue;
                isPwrGnd = true;
                break;
            }
            double length = 0.0;
            Iterator<ArcInst> it3 = net.getArcs();
            while (it3.hasNext()) {
                ArcInst ai = it3.next();
                length += ai.getLambdaLength();
                PortProto headPort = ai.getHeadPortInst().getPortProto();
                PortProto tailPort = ai.getTailPortInst().getPortProto();
                if (!headPort.isGround() && !headPort.isPower() && !tailPort.isGround() && !tailPort.isPower()) continue;
                isPwrGnd = true;
            }
            NetsToRoute ntr = new NetsToRoute(net, length, isPwrGnd);
            orderedNetsToRoute.add(ntr);
        }
        Collections.sort(orderedNetsToRoute, new NetsToRouteByLength());
        ArrayList<ArcInst> arcsToRoute = new ArrayList<ArcInst>();
        block5: for (NetsToRoute ntr : orderedNetsToRoute) {
            Iterator<ArcInst> it4 = ntr.net.getArcs();
            while (it4.hasNext()) {
                ArcInst ai = it4.next();
                if (ai.getProto() != Generic.tech.unrouted_arc) continue;
                arcsToRoute.add(ai);
                continue block5;
            }
        }
        new SeaOfGatesJob(cell, arcsToRoute);
    }

    public void routeIt(Job job, Cell cell, List<ArcInst> arcsToRoute) {
        if (this.initializeDesignRules(cell)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        Job.getUserInterface().startProgressDialog("Routing " + arcsToRoute.size() + " nets", null);
        Job.getUserInterface().setProgressNote("Building blockage information...");
        this.metalTrees = new HashMap<Layer, RTNode>();
        this.viaTrees = new HashMap<Layer, RTNode>();
        this.netIDs = new HashMap<ArcInst, Integer>();
        BlockageVisitor visitor = new BlockageVisitor(arcsToRoute);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, visitor);
        this.addBlockagesAtPorts(arcsToRoute);
        int numFailedRoutes = 0;
        int numRoutedSegments = 0;
        int numSegments = 0;
        this.firstFailure = true;
        this.totalWireLength = 0.0;
        int numToRoute = arcsToRoute.size();
        for (int a = 0; a < numToRoute; ++a) {
            if (job.checkAbort()) {
                System.out.println("Sea-of-gates routing aborted");
                break;
            }
            ArcInst ai = arcsToRoute.get(a);
            Netlist netList = cell.acquireUserNetlist();
            if (netList == null) {
                System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
                break;
            }
            Network net = netList.getNetwork(ai, 0);
            Job.getUserInterface().setProgressValue(a * 100 / numToRoute);
            Job.getUserInterface().setProgressNote("Network " + net.getName());
            System.out.println("Routing network " + net.getName() + "...");
            HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
            HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
            List<Connection> netEnds = Routing.findNetEnds(net, arcsToDelete, nodesToDelete, netList, true);
            List<PortInst> orderedPorts = this.makeOrderedPorts(net, netEnds);
            if (orderedPorts == null) {
                System.out.println("No valid connection points found on the network.");
                continue;
            }
            double minWidth = this.getMinWidth(orderedPorts);
            boolean allRouted = true;
            boolean[] segRouted = new boolean[orderedPorts.size() - 1];
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null) {
                netID = netIDI;
            }
            for (int i = 0; i < orderedPorts.size() - 1; ++i) {
                PortInst fromPi = orderedPorts.get(i);
                PortInst toPi = orderedPorts.get(i + 1);
                ++numSegments;
                if (this.inValidPort(fromPi) || this.inValidPort(toPi)) {
                    allRouted = false;
                    continue;
                }
                segRouted[i] = this.findPath(netID, fromPi, toPi, minWidth);
                if (segRouted[i]) {
                    ++numRoutedSegments;
                    continue;
                }
                allRouted = false;
            }
            if (allRouted) {
                for (ArcInst aiKill : arcsToDelete) {
                    aiKill.kill();
                }
                cell.killNodes(nodesToDelete);
                continue;
            }
            ++numFailedRoutes;
            for (ArcInst aiKill : arcsToDelete) {
                int headPort = -1;
                int tailPort = -1;
                for (int i = 0; i < orderedPorts.size(); ++i) {
                    PortInst pi = orderedPorts.get(i);
                    if (aiKill.getHeadPortInst() == pi) {
                        headPort = i;
                        continue;
                    }
                    if (aiKill.getTailPortInst() != pi) continue;
                    tailPort = i;
                }
                if (headPort < 0 || tailPort < 0) continue;
                boolean failed = false;
                if (headPort > tailPort) {
                    int swap = headPort;
                    headPort = tailPort;
                    tailPort = swap;
                }
                for (int i = headPort; i < tailPort; ++i) {
                    if (segRouted[i]) continue;
                    failed = true;
                }
                if (failed) continue;
                aiKill.kill();
            }
        }
        long stopTime = System.currentTimeMillis();
        Job.getUserInterface().stopProgressDialog();
        System.out.println("Routed " + numRoutedSegments + " out of " + numSegments + " segments; total length of routed wires is " + TextUtils.formatDouble(this.totalWireLength) + "; took " + TextUtils.getElapsedTime(stopTime - startTime));
        if (numFailedRoutes > 0) {
            System.out.println("NOTE: " + numFailedRoutes + " nets were not routed");
        }
    }

    private boolean initializeDesignRules(Cell c) {
        int i;
        this.cell = c;
        this.tech = this.cell.getTechnology();
        this.numMetalLayers = this.tech.getNumMetals();
        this.metalLayers = new Layer[this.numMetalLayers];
        this.metalArcs = new ArcProto[this.numMetalLayers];
        this.favorArcs = new boolean[this.numMetalLayers];
        this.preventArcs = new boolean[this.numMetalLayers];
        this.viaLayers = new Layer[this.numMetalLayers - 1];
        this.metalVias = new MetalVias[this.numMetalLayers - 1];
        for (int i2 = 0; i2 < this.numMetalLayers - 1; ++i2) {
            this.metalVias[i2] = new MetalVias();
        }
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            int layerIndex;
            Layer lay = it.next();
            if (!lay.getFunction().isMetal() || lay.isPseudoLayer() || (layerIndex = lay.getFunction().getLevel() - 1) >= this.numMetalLayers) continue;
            this.metalLayers[layerIndex] = lay;
        }
        boolean hasFavorites = false;
        Iterator<ArcProto> it2 = this.tech.getArcs();
        block2: while (it2.hasNext()) {
            ArcProto ap = it2.next();
            for (int i3 = 0; i3 < this.numMetalLayers; ++i3) {
                if (ap.getLayer(0) != this.metalLayers[i3]) continue;
                this.metalArcs[i3] = ap;
                this.favorArcs[i3] = Routing.isSeaOfGatesFavor(ap);
                if (this.favorArcs[i3]) {
                    hasFavorites = true;
                }
                this.preventArcs[i3] = Routing.isSeaOfGatesPrevent(ap);
                continue block2;
            }
        }
        if (!hasFavorites) {
            for (int i4 = 0; i4 < this.numMetalLayers; ++i4) {
                this.favorArcs[i4] = true;
            }
        }
        Iterator<PrimitiveNode> it22 = this.tech.getNodes();
        block5: while (it22.hasNext()) {
            PrimitiveNode np = it22.next();
            if (np.isNotUsed() || np.getFunction() != PrimitiveNode.Function.CONTACT) continue;
            ArcProto[] conns = np.getPort(0).getConnections();
            for (int i5 = 0; i5 < this.numMetalLayers - 1; ++i5) {
                if ((conns[0] != this.metalArcs[i5] || conns[1] != this.metalArcs[i5 + 1]) && (conns[1] != this.metalArcs[i5] || conns[0] != this.metalArcs[i5 + 1])) continue;
                this.metalVias[i5].addVia(np, 0);
                boolean square = true;
                boolean offCenter = false;
                NodeInst dummyNi = NodeInst.makeDummyInstance(np);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    Layer conLayer = conPoly.getLayer();
                    Layer.Function lFun = conLayer.getFunction();
                    if (lFun.isMetal()) {
                        Rectangle2D conRect = conPoly.getBounds2D();
                        if (conRect.getWidth() != conRect.getHeight()) {
                            square = false;
                        }
                        if (conRect.getCenterX() == 0.0 && conRect.getCenterY() == 0.0) continue;
                        offCenter = true;
                        continue;
                    }
                    if (!lFun.isContact()) continue;
                    this.viaLayers[i5] = conLayer;
                }
                if (offCenter) {
                    this.metalVias[i5].addVia(np, 90);
                    this.metalVias[i5].addVia(np, 180);
                    this.metalVias[i5].addVia(np, 270);
                    continue block5;
                }
                if (square) continue block5;
                this.metalVias[i5].addVia(np, 90);
                continue block5;
            }
        }
        for (i = 0; i < this.numMetalLayers; ++i) {
            if (this.metalLayers[i] == null) {
                System.out.println("ERROR: Cannot find layer for Metal " + (i + 1));
                return true;
            }
            if (this.metalArcs[i] == null) {
                System.out.println("ERROR: Cannot find arc for Metal " + (i + 1));
                return true;
            }
            if (i >= this.numMetalLayers - 1) continue;
            if (this.metalVias[i].getVias().size() == 0) {
                System.out.println("ERROR: Cannot find contact node between Metal " + (i + 1) + " and Metal " + (i + 2));
                return true;
            }
            if (this.viaLayers[i] != null) continue;
            System.out.println("ERROR: Cannot find contact layer between Metal " + (i + 1) + " and Metal " + (i + 2));
            return true;
        }
        this.layerSurround = new double[this.numMetalLayers];
        for (i = 0; i < this.numMetalLayers; ++i) {
            Layer lay = this.metalLayers[i];
            this.layerSurround[i] = 1.0;
            double arcWidth = this.metalArcs[i].getDefaultLambdaBaseWidth();
            DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, arcWidth, 50.0);
            if (rule == null) continue;
            this.layerSurround[i] = rule.getValue(0);
        }
        this.viaSurround = new double[this.numMetalLayers - 1];
        for (i = 0; i < this.numMetalLayers - 1; ++i) {
            Layer lay = this.viaLayers[i];
            double spacing = 2.0;
            double arcWidth = this.metalArcs[i].getDefaultLambdaBaseWidth();
            DRCTemplate ruleSpacing = DRC.getSpacingRule(lay, null, lay, null, false, -1, arcWidth, 50.0);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            double width = 2.0;
            DRCTemplate ruleWidth = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                width = ruleWidth.getValue(0);
            }
            this.viaSurround[i] = spacing + width;
        }
        return false;
    }

    private double getMinWidth(List<PortInst> orderedPorts) {
        double minWidth = 0.0;
        for (PortInst pi : orderedPorts) {
            double widestAtPort = this.getWidestMetalArcOnPort(pi);
            if (!(widestAtPort > minWidth)) continue;
            minWidth = widestAtPort;
        }
        if (minWidth > Routing.getSeaOfGatesMaxWidth()) {
            minWidth = Routing.getSeaOfGatesMaxWidth();
        }
        return minWidth;
    }

    private double getWidestMetalArcOnPort(PortInst pi) {
        Export export;
        PortInst exportedInst;
        double width2;
        double width = 0.0;
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (!ai.getProto().getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
            width = width2;
        }
        return width;
    }

    private boolean inValidPort(PortInst pi) {
        ArcProto[] conns = pi.getPortProto().getBasePort().getConnections();
        boolean valid = false;
        for (int j = 0; j < conns.length; ++j) {
            ArcProto ap = conns[j];
            if (ap.getTechnology() != this.tech || !ap.getFunction().isMetal() || this.preventArcs[conns[j].getFunction().getLevel() - 1]) continue;
            valid = true;
            break;
        }
        if (!valid) {
            System.out.println("Cannot connect to port " + pi.getPortProto().getName() + " on node " + pi.getNodeInst().describe(false) + " because all connecting layers have been prevented by Routing Preferences");
            return true;
        }
        return false;
    }

    private void addBlockagesAtPorts(List<ArcInst> arcsToRoute) {
        Netlist netList = this.cell.acquireUserNetlist();
        if (netList == null) {
            return;
        }
        for (ArcInst ai : arcsToRoute) {
            HashSet<NodeInst> nodesToDelete;
            HashSet<ArcInst> arcsToDelete;
            List<Connection> netEnds;
            Network net;
            List<PortInst> orderedPorts;
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null) {
                netID = netIDI;
            }
            if ((orderedPorts = this.makeOrderedPorts(net = netList.getNetwork(ai, 0), netEnds = Routing.findNetEnds(net, arcsToDelete = new HashSet<ArcInst>(), nodesToDelete = new HashSet<NodeInst>(), netList, true))) == null) continue;
            double minWidth = this.getMinWidth(orderedPorts);
            for (PortInst pi : orderedPorts) {
                Poly poly = pi.getPoly();
                Rectangle2D polyBounds = poly.getBounds2D();
                ArcProto[] poss = pi.getPortProto().getBasePort().getConnections();
                int lowMetal = -1;
                int highMetal = -1;
                for (int i = 0; i < poss.length; ++i) {
                    if (poss[i].getTechnology() != this.tech || !poss[i].getFunction().isMetal()) continue;
                    int level = poss[i].getFunction().getLevel();
                    if (lowMetal < 0) {
                        lowMetal = highMetal = level;
                        continue;
                    }
                    lowMetal = Math.min(lowMetal, level);
                    highMetal = Math.max(highMetal, level);
                }
                if (lowMetal < 0) continue;
                for (int via = lowMetal - 2; via < highMetal; ++via) {
                    if (via < 0 || via >= this.numMetalLayers - 1) continue;
                    MetalVia mv = this.metalVias[via].getVias().get(0);
                    PrimitiveNode np = mv.via;
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst dummy = NodeInst.makeDummyInstance(np, EPoint.ORIGIN, wid, hei, Orientation.IDENT);
                    Poly[] polys = this.tech.getShapeOfNode(dummy);
                    for (int i = 0; i < polys.length; ++i) {
                        Rectangle2D viaBounds;
                        SOGBound already;
                        Poly viaPoly = polys[i];
                        Layer layer = viaPoly.getLayer();
                        if (!layer.getFunction().isMetal() || (already = this.getMetalBlockage(netID, layer, (viaBounds = viaPoly.getBounds2D()).getWidth() / 2.0, viaBounds.getHeight() / 2.0, polyBounds.getMinX(), polyBounds.getMinY())) != null) continue;
                        Rectangle2D.Double bounds = new Rectangle2D.Double(viaBounds.getMinX() + polyBounds.getCenterX(), viaBounds.getMinY() + polyBounds.getCenterY(), viaBounds.getWidth(), viaBounds.getHeight());
                        this.addRectangle(bounds, layer, netID);
                    }
                }
            }
        }
    }

    private List<PortInst> makeOrderedPorts(Network net, List<Connection> netEnds) {
        HashSet<PortInst> portEndSet = new HashSet<PortInst>();
        for (int i = 0; i < netEnds.size(); ++i) {
            PortInst pi = netEnds.get(i).getPortInst();
            if (!pi.getNodeInst().isCellInstance() && ((PrimitiveNode)pi.getNodeInst().getProto()).getTechnology() == Generic.tech) continue;
            portEndSet.add(pi);
        }
        int count = portEndSet.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            System.out.println("Error: Network " + net.describe(false) + " has only one end");
            return null;
        }
        PortInst[] portEnds = new PortInst[count];
        int k = 0;
        for (PortInst pi : portEndSet) {
            portEnds[k++] = pi;
        }
        int closest1 = 0;
        int closest2 = 0;
        double closestDist = Double.MAX_VALUE;
        for (int i = 0; i < count; ++i) {
            Poly poly1 = portEnds[i].getPoly();
            for (int j = i + 1; j < count; ++j) {
                Poly poly2 = portEnds[j].getPoly();
                double dist = poly1.getCenter().distance(poly2.getCenter());
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closest1 = i;
                closest2 = j;
            }
        }
        ArrayList<PortInst> orderedPorts = new ArrayList<PortInst>();
        orderedPorts.add(portEnds[closest1]);
        orderedPorts.add(portEnds[closest2]);
        portEnds[closest1] = null;
        portEnds[closest2] = null;
        while (true) {
            boolean foundsome = false;
            double closestDist1 = Double.MAX_VALUE;
            double closestDist2 = Double.MAX_VALUE;
            for (int i = 0; i < count; ++i) {
                double dist2;
                if (portEnds[i] == null) continue;
                Poly poly = portEnds[i].getPoly();
                Poly poly1 = ((PortInst)orderedPorts.get(0)).getPoly();
                Poly poly2 = ((PortInst)orderedPorts.get(orderedPorts.size() - 1)).getPoly();
                double dist1 = poly.getCenter().distance(poly1.getCenter());
                if (dist1 < closestDist1) {
                    closestDist1 = dist1;
                    closest1 = i;
                    foundsome = true;
                }
                if (!((dist2 = poly.getCenter().distance(poly2.getCenter())) < closestDist2)) continue;
                closestDist2 = dist2;
                closest2 = i;
                foundsome = true;
            }
            if (!foundsome) break;
            if (closestDist1 < closestDist2) {
                orderedPorts.add(0, portEnds[closest1]);
                portEnds[closest1] = null;
                continue;
            }
            orderedPorts.add(portEnds[closest2]);
            portEnds[closest2] = null;
        }
        return orderedPorts;
    }

    private boolean findPath(int netID, PortInst fromPi, PortInst toPi, double minWidth) {
        int fromY;
        int toY;
        int fromX;
        int toX;
        ArcProto fromArc = null;
        ArcProto[] fromArcs = fromPi.getPortProto().getBasePort().getConnections();
        for (int i = 0; i < fromArcs.length; ++i) {
            if (!fromArcs[i].getFunction().isMetal()) continue;
            fromArc = fromArcs[i];
            break;
        }
        if (fromArc == null) {
            System.out.println("ERROR: Cannot connect port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " because the first port has no metal connection");
            return false;
        }
        EPoint fromLoc = fromPi.getPoly().getCenter();
        ArcProto toArc = null;
        ArcProto[] toArcs = toPi.getPortProto().getBasePort().getConnections();
        for (int i = 0; i < toArcs.length; ++i) {
            if (!toArcs[i].getFunction().isMetal()) continue;
            toArc = toArcs[i];
            break;
        }
        if (toArc == null) {
            System.out.println("ERROR: Cannot connect port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " because the second port has no metal connection");
            return false;
        }
        EPoint toLoc = toPi.getPoly().getCenter();
        if (toLoc.getX() < fromLoc.getX()) {
            toX = (int)Math.ceil(toLoc.getX());
            fromX = (int)Math.floor(fromLoc.getX());
        } else {
            toX = (int)Math.floor(toLoc.getX());
            fromX = (int)Math.ceil(fromLoc.getX());
        }
        if (toLoc.getY() < fromLoc.getY()) {
            toY = (int)Math.ceil(toLoc.getY());
            fromY = (int)Math.floor(fromLoc.getY());
        } else {
            toY = (int)Math.floor(toLoc.getY());
            fromY = (int)Math.ceil(fromLoc.getY());
        }
        int fromZ = fromArc.getFunction().getLevel() - 1;
        int toZ = toArc.getFunction().getLevel() - 1;
        if (fromArc.getTechnology() != this.tech || toArc.getTechnology() != this.tech) {
            System.out.println("Route from port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " on arc " + fromArc.describe() + " cannot connect to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " on arc " + toArc.describe());
            return false;
        }
        double metalSpacing = Math.max(this.metalArcs[fromZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0 + this.layerSurround[fromZ];
        SOGBound block = this.getMetalBlockage(netID, this.metalLayers[fromZ], metalSpacing, metalSpacing, fromX, fromY);
        if (block != null) {
            System.out.println("CANNOT Route to port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " because it is blocked on layer " + this.metalLayers[fromZ].getName() + " [needs " + TextUtils.formatDouble(metalSpacing) + " all around, has blockage at (" + TextUtils.formatDouble(block.bound.getCenterX()) + "," + TextUtils.formatDouble(block.bound.getCenterY()) + ") that is " + TextUtils.formatDouble(block.bound.getWidth()) + "x" + TextUtils.formatDouble(block.bound.getHeight()) + "]");
            return false;
        }
        metalSpacing = Math.max(this.metalArcs[toZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0 + this.layerSurround[toZ];
        block = this.getMetalBlockage(netID, this.metalLayers[toZ], metalSpacing, metalSpacing, toX, toY);
        if (block != null) {
            System.out.println("CANNOT Route to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " because it is blocked on layer " + this.metalLayers[toZ].getName() + " [needs " + TextUtils.formatDouble(metalSpacing) + " all around, has blockage at (" + TextUtils.formatDouble(block.bound.getCenterX()) + "," + TextUtils.formatDouble(block.bound.getCenterY()) + ") that is " + TextUtils.formatDouble(block.bound.getWidth()) + "x" + TextUtils.formatDouble(block.bound.getHeight()) + "]");
            return false;
        }
        List<SearchVertex> vertices = this.doDijkstra(fromX, fromY, fromZ, toX, toY, toZ, netID, minWidth);
        Object saveD1Planes = null;
        List<SearchVertex> verticesRev = this.doDijkstra(toX, toY, toZ, fromX, fromY, fromZ, netID, minWidth);
        int verLength = this.getVertexLength(vertices);
        int verLengthRev = this.getVertexLength(verticesRev);
        if (verLength == Integer.MAX_VALUE && verLengthRev == Integer.MAX_VALUE) {
            if (vertices == null && verticesRev == null) {
                System.out.println("ERROR: search too complex (exceeds complexity limit parameter of " + Routing.getSeaOfGatesComplexityLimit() + ")");
            } else {
                System.out.println("ERROR: Failed to route from port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false));
            }
            return false;
        }
        if (verLength == Integer.MAX_VALUE || verLength > verLengthRev) {
            vertices = verticesRev;
            PortInst pi = toPi;
            toPi = fromPi;
            fromPi = pi;
            int s = toX;
            toX = fromX;
            fromX = s;
            s = toY;
            toY = fromY;
            fromY = s;
            s = toZ;
            toZ = fromZ;
            fromZ = s;
        }
        PortInst lastPort = toPi;
        Poly toPoly = toPi.getPoly();
        if ((toPoly.getCenterX() != (double)toX || toPoly.getCenterY() != (double)toY) && vertices.size() >= 2) {
            NodeInst ni;
            SearchVertex v1 = vertices.get(0);
            SearchVertex v2 = vertices.get(1);
            ArcProto type = this.metalArcs[toZ];
            double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
            PrimitiveNode np = this.metalArcs[toZ].findPinProto();
            if (v1.getX() == v2.getX()) {
                ni = this.makeNodeInst(np, new EPoint((double)v1.getX(), toPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                this.makeArcInst(type, width, ni.getOnlyPortInst(), toPi, netID);
                lastPort = ni.getOnlyPortInst();
            } else if (v1.getY() == v2.getY()) {
                ni = this.makeNodeInst(np, new EPoint(toPoly.getCenterX(), (double)v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                this.makeArcInst(type, width, ni.getOnlyPortInst(), toPi, netID);
                lastPort = ni.getOnlyPortInst();
            }
        }
        for (int i = 0; i < vertices.size(); ++i) {
            SearchVertex sv = vertices.get(i);
            boolean madeContacts = false;
            while (i < vertices.size() - 1) {
                SearchVertex svNext = vertices.get(i + 1);
                if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), svNext.getZ())].getVias();
                int cutNo = sv.getCutNo();
                MetalVia mv = nps.get(cutNo);
                PrimitiveNode np = mv.via;
                Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                SizeOffset so = np.getProtoSizeOffset();
                double xOffset = so.getLowXOffset() + so.getHighXOffset();
                double yOffset = so.getLowYOffset() + so.getHighYOffset();
                double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                NodeInst ni = this.makeNodeInst(np, new EPoint((double)sv.getX(), (double)sv.getY()), wid, hei, orient, this.cell, netID);
                ArcProto type = this.metalArcs[sv.getZ()];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                this.makeArcInst(type, width, lastPort, ni.getOnlyPortInst(), netID);
                lastPort = ni.getOnlyPortInst();
                madeContacts = true;
                sv = svNext;
                ++i;
            }
            if (madeContacts && i != vertices.size() - 1) continue;
            PrimitiveNode np = this.metalArcs[sv.getZ()].findPinProto();
            PortInst pi = null;
            if (i == vertices.size() - 1) {
                pi = fromPi;
                Poly fromPoly = fromPi.getPoly();
                if ((fromPoly.getCenterX() != (double)sv.getX() || fromPoly.getCenterY() != (double)sv.getY()) && vertices.size() >= 2) {
                    PrimitiveNode pNp;
                    SearchVertex v1 = vertices.get(vertices.size() - 2);
                    SearchVertex v2 = vertices.get(vertices.size() - 1);
                    ArcProto type = this.metalArcs[fromZ];
                    double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                    if (v1.getX() == v2.getX()) {
                        pNp = this.metalArcs[fromZ].findPinProto();
                        NodeInst ni = this.makeNodeInst(pNp, new EPoint((double)v1.getX(), fromPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                        this.makeArcInst(type, width, ni.getOnlyPortInst(), fromPi, netID);
                        pi = ni.getOnlyPortInst();
                    } else if (v1.getY() == v2.getY()) {
                        pNp = this.metalArcs[fromZ].findPinProto();
                        NodeInst ni = this.makeNodeInst(pNp, new EPoint(fromPoly.getCenterX(), (double)v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                        this.makeArcInst(type, width, ni.getOnlyPortInst(), fromPi, netID);
                        pi = ni.getOnlyPortInst();
                    }
                }
            } else {
                NodeInst ni = this.makeNodeInst(np, new EPoint((double)sv.getX(), (double)sv.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                pi = ni.getOnlyPortInst();
            }
            if (lastPort != null) {
                ArcProto type = this.metalArcs[sv.getZ()];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                this.makeArcInst(type, width, lastPort, pi, netID);
            }
            lastPort = pi;
        }
        return true;
    }

    private int getVertexLength(List<SearchVertex> vertices) {
        if (vertices == null) {
            return Integer.MAX_VALUE;
        }
        if (vertices.size() == 0) {
            return Integer.MAX_VALUE;
        }
        int sum = 0;
        SearchVertex last = null;
        for (SearchVertex sv : vertices) {
            if (last != null) {
                sum += Math.abs(sv.getX() - last.getX()) + Math.abs(sv.getY() - last.getY()) + Math.abs(sv.getZ() - last.getZ()) * 10;
            }
            last = sv;
        }
        return sum;
    }

    private NodeInst makeNodeInst(NodeProto np, EPoint loc, double wid, double hei, Orientation orient, Cell cell, int netID) {
        NodeInst ni = NodeInst.makeInstance(np, loc, wid, hei, cell, orient, null, 0);
        if (ni != null) {
            Poly[] nodeInstPolyList = this.tech.getShapeOfNode(ni, true, false, null);
            for (int i = 0; i < nodeInstPolyList.length; ++i) {
                Poly poly = nodeInstPolyList[i];
                if (poly.getPort() == null) continue;
                this.addLayer(poly, GenMath.MATID, netID, false);
            }
        }
        return ni;
    }

    private ArcInst makeArcInst(ArcProto type, double wid, PortInst from, PortInst to, int netID) {
        ArcInst ai = ArcInst.makeInstanceBase(type, wid, from, to);
        if (ai != null) {
            Poly[] polys = this.tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                this.addLayer(polys[i], GenMath.MATID, netID, false);
            }
            Poly fromPoly = from.getPoly();
            Poly toPoly = to.getPoly();
            double length = fromPoly.getCenter().distance(toPoly.getCenter());
            this.totalWireLength += length;
        }
        return ai;
    }

    private List<SearchVertex> doDijkstra(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int netID, double minWidth) {
        ERectangle bounds = this.cell.getBounds();
        int lowX = (int)Math.floor(bounds.getMinX());
        int highX = (int)Math.ceil(((RectangularShape)bounds).getMaxX());
        int lowY = (int)Math.floor(bounds.getMinY());
        int highY = (int)Math.ceil(((RectangularShape)bounds).getMaxY());
        Rectangle jumpBound = new Rectangle(Math.min(fromX, toX), Math.min(fromY, toY), Math.abs(fromX - toX), Math.abs(fromY - toY));
        this.searchVertexPlanes = new Map[this.numMetalLayers];
        this.destX = toX;
        this.destY = toY;
        this.destZ = toZ;
        int numSearchVertices = 0;
        SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, 0);
        svStart.cost = 0;
        this.setVertex(fromX, fromY, fromZ, svStart);
        TreeSet<SearchVertex> active = new TreeSet<SearchVertex>();
        active.add(svStart);
        SearchVertex thread = null;
        while (active.size() > 0) {
            SearchVertex svCurrent = (SearchVertex)active.first();
            active.remove(svCurrent);
            int curX = svCurrent.getX();
            int curY = svCurrent.getY();
            int curZ = svCurrent.getZ();
            for (int i = 0; i < 6; ++i) {
                int dx = 0;
                int dy = 0;
                int dz = 0;
                switch (i) {
                    case 0: {
                        dx = -1;
                        break;
                    }
                    case 1: {
                        dx = 1;
                        break;
                    }
                    case 2: {
                        dy = -1;
                        break;
                    }
                    case 3: {
                        dy = 1;
                        break;
                    }
                    case 4: {
                        dz = -1;
                        break;
                    }
                    case 5: {
                        dz = 1;
                    }
                }
                if (dz == 0) {
                    boolean goFarther = false;
                    if (dx != 0) {
                        if ((toX - curX) * dx > 0) {
                            goFarther = true;
                        }
                    } else if ((toY - curY) * dy > 0) {
                        goFarther = true;
                    }
                    if (goFarther) {
                        int jumpSize = this.getJumpSize(curX, curY, curZ, dx, dy, jumpBound, netID, minWidth);
                        if (dx > 0) {
                            if (jumpSize <= 0) continue;
                            dx = jumpSize;
                        }
                        if (dx < 0) {
                            if (jumpSize >= 0) continue;
                            dx = jumpSize;
                        }
                        if (dy > 0) {
                            if (jumpSize <= 0) continue;
                            dy = jumpSize;
                        }
                        if (dy < 0) {
                            if (jumpSize >= 0) continue;
                            dy = jumpSize;
                        }
                    }
                }
                int nX = curX + dx;
                int nY = curY + dy;
                int nZ = curZ + dz;
                if (nX < lowX || nX > highX || nY < lowY || nY > highY || nZ < 0 || nZ >= this.numMetalLayers || this.preventArcs[nZ] || this.getVertex(nX, nY, nZ) != null) continue;
                int cutIndex = 0;
                if (dz == 0) {
                    double width = Math.max(this.metalArcs[nZ].getDefaultLambdaBaseWidth(), minWidth);
                    double metalSpacing = width / 2.0 + this.layerSurround[nZ];
                    SOGBound sb = this.getMetalBlockage(netID, this.metalLayers[nZ], metalSpacing, metalSpacing, nX, nY);
                    if (sb != null) {
                        continue;
                    }
                } else {
                    int lowMetal = Math.min(curZ, nZ);
                    int highMetal = Math.max(curZ, nZ);
                    List<MetalVia> nps = this.metalVias[lowMetal].getVias();
                    cutIndex = -1;
                    for (int cutNo = 0; cutNo < nps.size(); ++cutNo) {
                        MetalVia mv = nps.get(cutNo);
                        PrimitiveNode np = mv.via;
                        Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                        SizeOffset so = np.getProtoSizeOffset();
                        double conWid = Math.max(np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset(), minWidth) + so.getLowXOffset() + so.getHighXOffset();
                        double conHei = Math.max(np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset(), minWidth) + so.getLowYOffset() + so.getHighYOffset();
                        NodeInst dummyNi = NodeInst.makeDummyInstance(np, new EPoint((double)nX, (double)nY), conWid, conHei, orient);
                        Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                        AffineTransform trans = null;
                        if (orient != Orientation.IDENT) {
                            trans = dummyNi.rotateOut();
                        }
                        boolean failed = false;
                        for (int p = 0; p < conPolys.length; ++p) {
                            SearchVertex lastSv;
                            Rectangle2D conRect;
                            Layer conLayer;
                            Layer.Function lFun;
                            Poly conPoly = conPolys[p];
                            if (trans != null) {
                                conPoly.transform(trans);
                            }
                            if ((lFun = (conLayer = conPoly.getLayer()).getFunction()).isMetal()) {
                                conRect = conPoly.getBounds2D();
                                int metalNo = lFun.getLevel() - 1;
                                if (this.getMetalBlockage(netID, conLayer, conRect.getWidth() / 2.0 + this.layerSurround[metalNo], conRect.getHeight() / 2.0 + this.layerSurround[metalNo], conRect.getCenterX(), conRect.getCenterY()) == null) continue;
                                failed = true;
                                break;
                            }
                            if (!lFun.isContact()) continue;
                            double surround = this.viaSurround[lowMetal];
                            conRect = conPoly.getBounds2D();
                            if (this.getViaBlockage(netID, conLayer, surround, surround, conRect.getCenterX(), conRect.getCenterY()) != null) {
                                failed = true;
                                break;
                            }
                            SearchVertex sv = svCurrent;
                            while (sv != null && (lastSv = sv.last) != null) {
                                if (Math.min(sv.getZ(), lastSv.getZ()) == lowMetal && Math.max(sv.getZ(), lastSv.getZ()) == highMetal && (double)Math.abs(sv.getX() - nX) < surround && (double)Math.abs(sv.getY() - nY) < surround) {
                                    failed = true;
                                    break;
                                }
                                sv = sv.last;
                            }
                            if (failed) break;
                        }
                        if (failed) continue;
                        cutIndex = cutNo;
                        break;
                    }
                    if (cutIndex < 0) continue;
                }
                SearchVertex svNext = new SearchVertex(nX, nY, nZ, cutIndex);
                svNext.last = svCurrent;
                if (nX == toX && nY == toY && nZ == toZ) {
                    thread = svNext;
                    break;
                }
                if (++numSearchVertices > Routing.getSeaOfGatesComplexityLimit()) {
                    return null;
                }
                svNext.cost = svCurrent.cost;
                if (dx != 0) {
                    if (toX == curX) {
                        svNext.cost += 1;
                    } else if ((toX - curX) * dx < 0) {
                        svNext.cost += 2;
                    }
                    if (nZ % 2 == 0) {
                        svNext.cost += 50;
                    }
                }
                if (dy != 0) {
                    if (toY == curY) {
                        svNext.cost += 1;
                    } else if ((toY - curY) * dy < 0) {
                        svNext.cost += 2;
                    }
                    if (nZ % 2 != 0) {
                        svNext.cost += 50;
                    }
                }
                if (dz != 0) {
                    if (toZ == curZ) {
                        svNext.cost += 8;
                    } else if ((toZ - curZ) * dz < 0) {
                        svNext.cost += 16;
                    }
                } else {
                    int jumpSize1 = Math.abs(this.getJumpSize(nX, nY, nZ, dx, dy, jumpBound, netID, minWidth));
                    int jumpSize2 = Math.abs(this.getJumpSize(curX, curY, curZ, -dx, -dy, jumpBound, netID, minWidth));
                    if (jumpSize1 > 1 && jumpSize2 > 1) {
                        svNext.cost += jumpSize1 * jumpSize2 / 10;
                    }
                    if (svCurrent.last != null) {
                        int lastDx = svCurrent.getX() - svCurrent.last.getX();
                        int lastDy = svCurrent.getY() - svCurrent.last.getY();
                        if (lastDx != dx || lastDy != dy) {
                            svNext.cost += 1;
                        }
                    }
                }
                if (!this.favorArcs[nZ]) {
                    svNext.cost += 18 * Math.abs(dz) + 10 * Math.abs(dx + dy);
                }
                this.setVertex(nX, nY, nZ, svNext);
                active.add(svNext);
            }
            if (thread == null) continue;
            break;
        }
        ArrayList<SearchVertex> realVertices = new ArrayList<SearchVertex>();
        if (thread != null) {
            SearchVertex lastVertex = thread;
            realVertices.add(lastVertex);
            thread = thread.last;
            while (thread != null) {
                if (lastVertex.getZ() != thread.getZ()) {
                    realVertices.add(thread);
                    lastVertex = thread;
                    thread = thread.last;
                    continue;
                }
                int dx = thread.getX() - lastVertex.getX();
                int dy = thread.getY() - lastVertex.getY();
                lastVertex = thread;
                thread = thread.last;
                while (thread != null && thread.getX() - lastVertex.getX() == dx && thread.getY() - lastVertex.getY() == dy) {
                    lastVertex = thread;
                    thread = thread.last;
                }
                realVertices.add(lastVertex);
            }
            for (int i = 1; i < realVertices.size() - 1; ++i) {
                SearchVertex last = (SearchVertex)realVertices.get(i - 1);
                SearchVertex cur = (SearchVertex)realVertices.get(i);
                SearchVertex next = (SearchVertex)realVertices.get(i + 1);
                if (last.getZ() != cur.getZ() || next.getZ() != cur.getZ() || (last.getX() != cur.getX() || next.getX() != cur.getX()) && (last.getY() != cur.getY() || next.getY() != cur.getY())) continue;
                realVertices.remove(i);
                --i;
            }
        }
        return realVertices;
    }

    private int getJumpSize(int curX, int curY, int curZ, int dx, int dy, Rectangle jumpBound, int netID, double minWidth) {
        double width = Math.max(this.metalArcs[curZ].getDefaultLambdaBaseWidth(), minWidth);
        double metalSpacing = width / 2.0 + this.layerSurround[curZ];
        double lX = (double)curX - metalSpacing;
        double hX = (double)curX + metalSpacing;
        double lY = (double)curY - metalSpacing;
        double hY = (double)curY + metalSpacing;
        if (dx > 0) {
            hX = jumpBound.getMaxX() + metalSpacing;
        } else if (dx < 0) {
            lX = jumpBound.getMinX() - metalSpacing;
        } else if (dy > 0) {
            hY = jumpBound.getMaxY() + metalSpacing;
        } else if (dy < 0) {
            lY = jumpBound.getMinY() - metalSpacing;
        }
        RTNode rtree = this.metalTrees.get(this.metalLayers[curZ]);
        if (rtree != null) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
            RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
            while (sea.hasNext()) {
                Rectangle2D bound;
                SOGBound sBound = (SOGBound)sea.next();
                if (sBound.getNetID() == netID || (bound = sBound.getBounds()).getMinX() >= hX || bound.getMaxX() <= lX || bound.getMinY() >= hY || bound.getMaxY() <= lY) continue;
                if (dx > 0 && bound.getMinX() < hX) {
                    hX = bound.getMinX();
                }
                if (dx < 0 && bound.getMaxX() > lX) {
                    lX = bound.getMaxX();
                }
                if (dy > 0 && bound.getMinY() < hY) {
                    hY = bound.getMinY();
                }
                if (dy >= 0 || !(bound.getMaxY() > lY)) continue;
                lY = bound.getMaxY();
            }
        }
        if (dx > 0) {
            dx = (int)Math.floor(hX - metalSpacing) - curX;
            return dx;
        }
        if (dx < 0) {
            dx = (int)Math.ceil(lX + metalSpacing) - curX;
            return dx;
        }
        if (dy > 0) {
            dy = (int)Math.floor(hY - metalSpacing) - curY;
            return dy;
        }
        if (dy < 0) {
            dy = (int)Math.ceil(lY + metalSpacing) - curY;
            return dy;
        }
        return 0;
    }

    private SOGBound getMetalBlockage(int netID, Layer layer, double halfWidth, double halfHeight, double x, double y) {
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        double lX = x - halfWidth;
        double hX = x + halfWidth;
        double lY = y - halfHeight;
        double hY = y + halfHeight;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, halfWidth * 2.0, halfHeight * 2.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            PolyBase poly;
            Rectangle2D bound;
            SOGBound sBound = (SOGBound)sea.next();
            if (sBound.getNetID() == netID || (bound = sBound.getBounds()).getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY || sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(searchArea)) continue;
            return sBound;
        }
        return null;
    }

    private SOGVia getViaBlockage(int netID, Layer layer, double halfWidth, double halfHeight, double x, double y) {
        RTNode rtree = this.viaTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x - halfWidth, y - halfHeight, halfWidth * 2.0, halfHeight * 2.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGVia sLoc = (SOGVia)sea.next();
            if (sLoc.getNetID() == netID && sLoc.loc.getX() == x && sLoc.loc.getY() == y) continue;
            return sLoc;
        }
        return null;
    }

    private void addLayer(PolyBase poly, AffineTransform trans, int netID, boolean canPlacePseudo) {
        if (!canPlacePseudo && poly.isPseudoLayer()) {
            return;
        }
        Layer layer = poly.getLayer();
        if (canPlacePseudo) {
            layer = layer.getNonPseudoLayer();
        } else if (layer.isPseudoLayer()) {
            return;
        }
        Layer.Function fun = layer.getFunction();
        if (fun.isMetal()) {
            poly.transform(trans);
            Rectangle2D bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, layer, netID);
            } else {
                this.addRectangle(bounds, layer, netID);
            }
        } else if (fun.isContact()) {
            Rectangle2D bounds = poly.getBounds2D();
            GenMath.transformRect(bounds, trans);
            this.addVia(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), layer, netID);
        }
    }

    private void addRectangle(Rectangle2D bounds, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root = this.metalTrees.get(layer);
        if (root == null) {
            root = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root);
        }
        if ((newRoot = RTNode.linkGeom(null, root, new SOGBound(bounds, netID))) != root) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addPolygon(PolyBase poly, Layer layer, int netID) {
        Rectangle2D bounds;
        RTNode newRoot;
        RTNode root = this.metalTrees.get(layer);
        if (root == null) {
            root = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root);
        }
        if ((newRoot = RTNode.linkGeom(null, root, new SOGPoly(bounds = poly.getBounds2D(), netID, poly))) != root) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addVia(Point2D loc, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root = this.viaTrees.get(layer);
        if (root == null) {
            root = RTNode.makeTopLevel();
            this.viaTrees.put(layer, root);
        }
        if ((newRoot = RTNode.linkGeom(null, root, new SOGVia(loc, netID))) != root) {
            this.viaTrees.put(layer, newRoot);
        }
    }

    private SearchVertex getVertex(int x, int y, int z) {
        Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
        if (plane == null) {
            return null;
        }
        Map<Integer, SearchVertex> row = plane.get(y);
        if (row == null) {
            return null;
        }
        SearchVertex item = row.get(x);
        return item;
    }

    private void setVertex(int x, int y, int z, SearchVertex sv) {
        Map<Integer, SearchVertex> row;
        Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
        if (plane == null) {
            this.searchVertexPlanes[z] = plane = new HashMap<Integer, Map<Integer, SearchVertex>>();
        }
        if ((row = plane.get(y)) == null) {
            row = new HashMap<Integer, SearchVertex>();
            plane.put(y, row);
        }
        row.put(x, sv);
    }

    private void showSearchVertices(Map<Integer, Map<Integer, SearchVertex>>[] planes, boolean horiz) {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        for (int i = 0; i < this.numMetalLayers; ++i) {
            double offset = i;
            offset -= (double)(this.numMetalLayers - 2) / 2.0;
            offset /= (double)(this.numMetalLayers + 2);
            Map<Integer, Map<Integer, SearchVertex>> plane = planes[i];
            if (plane == null) continue;
            for (Integer y : plane.keySet()) {
                double yv = y.doubleValue();
                Map<Integer, SearchVertex> row = plane.get(y);
                for (Integer x : row.keySet()) {
                    Point2D.Double pt2;
                    Point2D.Double pt1;
                    double xv = x.doubleValue();
                    if (horiz) {
                        pt1 = new Point2D.Double(xv - 0.5, yv + offset);
                        pt2 = new Point2D.Double(xv + 0.5, yv + offset);
                    } else {
                        pt1 = new Point2D.Double(xv + offset, yv - 0.5);
                        pt2 = new Point2D.Double(xv + offset, yv + 0.5);
                    }
                    wnd.addHighlightLine(pt1, pt2, this.cell, false);
                }
            }
        }
    }

    private class SearchVertex
    implements Comparable {
        private int xv;
        private int yv;
        private int zv;
        private int cost;
        private SearchVertex last;

        SearchVertex(int x, int y, int z, int cutNo) {
            this.xv = x;
            this.yv = y;
            this.zv = (z << 8) + (cutNo & 0xFF);
        }

        int getX() {
            return this.xv;
        }

        int getY() {
            return this.yv;
        }

        int getZ() {
            return this.zv >> 8;
        }

        int getCutNo() {
            return this.zv & 0xFF;
        }

        public int compareTo(Object svo) {
            SearchVertex sv = (SearchVertex)svo;
            int diff = this.cost - sv.cost;
            if (diff != 0) {
                return diff;
            }
            int thisDist = Math.abs(this.xv - SeaOfGates.this.destX) + Math.abs(this.yv - SeaOfGates.this.destY) + Math.abs(this.zv - SeaOfGates.this.destZ);
            int otherDist = Math.abs(sv.xv - SeaOfGates.this.destX) + Math.abs(sv.yv - SeaOfGates.this.destY) + Math.abs(sv.zv - SeaOfGates.this.destZ);
            return thisDist - otherDist;
        }
    }

    private static class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(PrimitiveNode pn, int o) {
            this.vias.add(new MetalVia(pn, o));
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        PrimitiveNode via;
        int orientation;

        MetalVia(PrimitiveNode v, int o) {
            this.via = v;
            this.orientation = o;
        }
    }

    private class BlockageVisitor
    extends HierarchyEnumerator.Visitor {
        private List<ArcInst> arcsToRoute;
        private boolean didTopLevel;

        public BlockageVisitor(List<ArcInst> arcsToRoute) {
            this.arcsToRoute = arcsToRoute;
            this.didTopLevel = false;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Netlist nl = info.getNetlist();
            AffineTransform trans = info.getTransformToRoot();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                int netID = -1;
                Network net = nl.getNetwork(ai, 0);
                if (net != null) {
                    netID = info.getNetID(net);
                }
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i = 0; i < polys.length; ++i) {
                    SeaOfGates.this.addLayer(polys[i], trans, netID, false);
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni;
            if (info.isRootCell() && !this.didTopLevel) {
                this.didTopLevel = true;
                if (this.arcsToRoute != null) {
                    Netlist nl = info.getNetlist();
                    for (ArcInst ai : this.arcsToRoute) {
                        Network net = nl.getNetwork(ai, 0);
                        int netID = info.getNetID(net);
                        SeaOfGates.this.netIDs.put(ai, new Integer(netID));
                    }
                }
            }
            if (!(ni = no.getNodeInst()).isCellInstance()) {
                Netlist nl = info.getNetlist();
                AffineTransform trans = info.getTransformToRoot();
                AffineTransform nodeTrans = ni.rotateOut(trans);
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                boolean canPlacePseudo = info.isRootCell();
                if (!ni.hasExports()) {
                    canPlacePseudo = false;
                }
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    Network net;
                    Poly poly = nodeInstPolyList[i];
                    int netID = -1;
                    if (poly.getPort() != null && (net = nl.getNetwork(no, poly.getPort(), 0)) != null) {
                        netID = info.getNetID(net);
                    }
                    SeaOfGates.this.addLayer(poly, nodeTrans, netID, canPlacePseudo);
                }
            }
            return true;
        }
    }

    private static class SOGVia
    implements RTBounds {
        private Point2D loc;
        private int netID;

        SOGVia(Point2D loc, int netID) {
            this.loc = loc;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGVia on net " + this.netID;
        }
    }

    private static class SOGPoly
    extends SOGBound {
        private PolyBase poly;

        SOGPoly(Rectangle2D bound, int netID, PolyBase poly) {
            super(bound, netID);
            this.poly = poly;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    private static class SOGBound
    implements RTBounds {
        private Rectangle2D bound;
        private int netID;

        SOGBound(Rectangle2D bound, int netID) {
            this.bound = bound;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return this.bound;
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGBound on net " + this.netID;
        }
    }

    private static class SeaOfGatesJob
    extends Job {
        private Cell cell;
        private List<ArcInst> arcsToRoute;

        protected SeaOfGatesJob(Cell cell, List<ArcInst> arcsToRoute) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.arcsToRoute = arcsToRoute;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            SeaOfGates router = new SeaOfGates();
            router.routeIt(this, this.cell, this.arcsToRoute);
            return true;
        }
    }

    public static class NetsToRouteByLength
    implements Comparator<NetsToRoute> {
        @Override
        public int compare(NetsToRoute ntr1, NetsToRoute ntr2) {
            if (ntr1.isPwrGnd != ntr2.isPwrGnd) {
                if (ntr1.isPwrGnd) {
                    return -1;
                }
                return 1;
            }
            if (ntr1.length < ntr2.length) {
                return -1;
            }
            if (ntr1.length > ntr2.length) {
                return 1;
            }
            return 0;
        }
    }

    private static class NetsToRoute {
        private Network net;
        private double length;
        private boolean isPwrGnd;

        NetsToRoute(Network net, double length, boolean isPwrGnd) {
            this.net = net;
            this.length = length;
            this.isPwrGnd = isPwrGnd;
        }
    }
}

