/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.change;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.ElectricObject;

public class DatabaseChangeEvent {
    public final Snapshot oldSnapshot;
    public final Snapshot newSnapshot;

    public DatabaseChangeEvent(Snapshot oldSnapshot, Snapshot newSnapshot) {
        this.oldSnapshot = oldSnapshot;
        this.newSnapshot = newSnapshot;
    }

    public boolean objectChanged(ElectricObject eObj) {
        return true;
    }

    public boolean cellTreeChanged() {
        if (!this.newSnapshot.getChangedLibraries(this.oldSnapshot).isEmpty()) {
            return true;
        }
        for (CellId cellId : this.newSnapshot.getChangedCells(this.oldSnapshot)) {
            CellBackup oldBackup = this.oldSnapshot.getCell(cellId);
            CellBackup newBackup = this.newSnapshot.getCell(cellId);
            if (oldBackup == null || newBackup == null) {
                return true;
            }
            if (oldBackup.modified != newBackup.modified) {
                return true;
            }
            ImmutableCell oldD = oldBackup.d;
            ImmutableCell newD = newBackup.d;
            if (oldD.groupName != newD.groupName) {
                return true;
            }
            if (oldD.getVar(Cell.MULTIPAGE_COUNT_KEY) == newD.getVar(Cell.MULTIPAGE_COUNT_KEY)) continue;
            return true;
        }
        return false;
    }
}

