/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Stimuli;
import java.awt.geom.Rectangle2D;

public class AnalogSignal
extends Signal {
    private static final int BASICSIGNAL = 0;
    private static final int SWEEPSIGNAL = 1;
    private static final int INTERVALSIGNAL = 2;
    private int signalType;
    private double[] values;
    private double[][] sweepValues;
    private double[] highIntervalValues;

    public AnalogSignal(Stimuli sd) {
        super(sd);
    }

    public void buildValues(int numEvents) {
        this.signalType = 0;
        this.values = new double[numEvents];
    }

    public void setNumSweeps(int numSweeps) {
        this.signalType = 1;
        this.sweepValues = new double[numSweeps][];
    }

    public void buildSweepValues(int sweep, int numEvents) {
        this.sweepValues[sweep] = new double[numEvents];
    }

    public void buildIntervalValues(int numEvents) {
        this.signalType = 2;
        this.values = new double[numEvents];
        this.highIntervalValues = new double[numEvents];
    }

    public void setValue(int index, double value) {
        if (this.signalType != 0) {
            System.out.println("Setting complex data into basic signal");
            return;
        }
        this.values[index] = value;
        this.boundsCurrent = false;
    }

    public void setSweepValue(int sweep, int index, double value) {
        if (this.signalType != 1) {
            System.out.println("Setting sweep data into non-sweep signal");
            return;
        }
        this.sweepValues[sweep][index] = value;
        this.boundsCurrent = false;
    }

    public void setIntervalValue(int index, double lowValue, double highValue) {
        if (this.signalType != 2) {
            System.out.println("Setting interval data into non-interval signal");
            return;
        }
        this.values[index] = lowValue;
        this.highIntervalValues[index] = highValue;
        this.boundsCurrent = false;
    }

    public double getValue(int index) {
        if (this.signalType != 0) {
            System.out.println("Getting basic data from non-basic signal");
            return 0.0;
        }
        return this.values[index];
    }

    public double getSweepValue(int sweep, int index) {
        if (this.signalType != 1) {
            System.out.println("Getting sweep data from non-sweep signal");
            return 0.0;
        }
        return this.sweepValues[sweep][index];
    }

    public double getIntervalLowValue(int index) {
        if (this.signalType != 2) {
            System.out.println("Getting interval data from non-interval signal");
            return 0.0;
        }
        return this.values[index];
    }

    public double getIntervalHighValue(int index) {
        if (this.signalType != 2) {
            System.out.println("Getting interval data from non-interval signal");
            return 0.0;
        }
        return this.highIntervalValues[index];
    }

    public int getNumEvents() {
        switch (this.signalType) {
            case 0: {
                return this.values.length;
            }
            case 1: {
                return this.sweepValues[0].length;
            }
            case 2: {
                return this.values.length;
            }
        }
        return 0;
    }

    public int getNumEvents(int sweep) {
        if (this.signalType != 1) {
            return 0;
        }
        return this.sweepValues[sweep].length;
    }

    public int getNumSweeps() {
        if (this.signalType != 1) {
            return 0;
        }
        return this.sweepValues.length;
    }

    public boolean isBasic() {
        return this.signalType == 0;
    }

    public boolean isSweep() {
        return this.signalType == 1;
    }

    public boolean isInterval() {
        return this.signalType == 2;
    }

    protected void calcBounds() {
        double lowTime = 0.0;
        double highTime = 0.0;
        double lowValue = 0.0;
        double highValue = 0.0;
        boolean first = true;
        if (this.isBasic()) {
            for (int i = 0; i < this.values.length; ++i) {
                double time = this.getTime(i);
                double value = this.values[i];
                if (first) {
                    first = false;
                    lowTime = highTime = time;
                    lowValue = highValue = value;
                    continue;
                }
                if (time < lowTime) {
                    lowTime = time;
                }
                if (time > highTime) {
                    highTime = time;
                }
                if (value < lowValue) {
                    lowValue = value;
                }
                if (!(value > highValue)) continue;
                highValue = value;
            }
        } else if (this.isSweep()) {
            for (int s = 0; s < this.sweepValues.length; ++s) {
                for (int i = 0; i < this.sweepValues[s].length; ++i) {
                    double time = this.getTime(i, s);
                    double value = this.sweepValues[s][i];
                    if (first) {
                        first = false;
                        lowTime = highTime = time;
                        lowValue = highValue = value;
                        continue;
                    }
                    if (time < lowTime) {
                        lowTime = time;
                    }
                    if (time > highTime) {
                        highTime = time;
                    }
                    if (value < lowValue) {
                        lowValue = value;
                    }
                    if (!(value > highValue)) continue;
                    highValue = value;
                }
            }
        } else if (this.isInterval()) {
            for (int i = 0; i < this.values.length; ++i) {
                double time = this.getTime(i);
                double lowVal = this.values[i];
                double highVal = this.values[i];
                if (first) {
                    first = false;
                    lowTime = highTime = time;
                    lowValue = lowVal;
                    highValue = highVal;
                    continue;
                }
                if (time < lowTime) {
                    lowTime = time;
                }
                if (time > highTime) {
                    highTime = time;
                }
                if (lowVal < lowValue) {
                    lowValue = lowVal;
                }
                if (!(highVal > highValue)) continue;
                highValue = highVal;
            }
        }
        this.bounds = new Rectangle2D.Double(lowTime, lowValue, highTime - lowTime, highValue - lowValue);
    }
}

