/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.HelpMenu;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class Main {
    private static boolean DEBUG;
    static /* synthetic */ Class class$com$sun$electric$tool$user$ui$TopLevel;

    private Main() {
    }

    public static void main(String[] args) {
        MacOSXInterface.registerMacOSXApplication();
        SplashWindow sw = new SplashWindow();
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argsList.add(args[i]);
        }
        if (Main.hasCommandLineOption(argsList, "-debug")) {
            DEBUG = true;
        }
        TopLevel.OSInitialize(!Main.hasCommandLineOption(argsList, "-m"));
        new InitDatabase(argsList, sw);
    }

    private static boolean hasCommandLineOption(List argsList, String option) {
        for (int i = 0; i < argsList.size(); ++i) {
            if (!((String)argsList.get(i)).equals(option)) continue;
            argsList.remove(i);
            return true;
        }
        return false;
    }

    private static String getCommandLineOption(List argsList, String option) {
        for (int i = 0; i < argsList.size() - 1; ++i) {
            if (!((String)argsList.get(i)).equals(option)) continue;
            argsList.remove(i);
            if (((String)argsList.get(i)).startsWith("-")) {
                System.out.println("Bad command line option: " + option + " " + argsList.get(i + 1));
                return null;
            }
            return (String)argsList.remove(i);
        }
        return null;
    }

    private static void openCommandLineLibs(List argsList) {
        ArrayList<URL> fileURLs = new ArrayList<URL>();
        for (int i = 0; i < argsList.size(); ++i) {
            String arg = (String)argsList.get(i);
            if (arg.startsWith("-")) {
                System.out.println("Command line option " + arg + " not understood, ignoring.");
                continue;
            }
            URL url = TextUtils.makeURLToFile(arg);
            if (url == null) continue;
            fileURLs.add(url);
        }
        FileMenu.ReadInitialELIBs job = new FileMenu.ReadInitialELIBs(fileURLs);
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    static class MacOSXInterface
    extends ApplicationAdapter {
        private static MacOSXInterface adapter = null;
        private static Application application = null;

        private MacOSXInterface() {
        }

        public void handleAbout(ApplicationEvent ae) {
            ae.setHandled(true);
            HelpMenu.aboutCommand();
        }

        public void handlePreferences(ApplicationEvent ae) {
            ae.setHandled(true);
            PreferencesFrame.preferencesCommand();
        }

        public void handleQuit(ApplicationEvent ae) {
            ae.setHandled(false);
            FileMenu.quitCommand();
        }

        public static void registerMacOSXApplication() {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Electric");
            if (application == null) {
                application = new Application();
            }
            if (adapter == null) {
                adapter = new MacOSXInterface();
            }
            application.addApplicationListener(adapter);
            application.setEnabledPreferencesMenu(true);
        }
    }

    private static class InitDatabase
    extends Job {
        List argsList;
        SplashWindow sw;

        protected InitDatabase(List argsList, SplashWindow sw) {
            super("Init database", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.argsList = argsList;
            this.sw = sw;
            this.startJob();
        }

        public boolean doIt() {
            Undo.changesQuiet(true);
            Technology.initAllTechnologies();
            Tool.initAllTools();
            Layout con = Layout.getConstraint();
            Constraints.setCurrent(con);
            if (Main.hasCommandLineOption(this.argsList, "-NOMINMEM")) {
                // empty if block
            }
            String beanShellScript = Main.getCommandLineOption(this.argsList, "-s");
            Main.openCommandLineLibs(this.argsList);
            if (beanShellScript != null) {
                EvalJavaBsh.runScript(beanShellScript);
            }
            this.sw.removeNotify();
            Undo.changesQuiet(false);
            return true;
        }
    }

    private static class WindowsEvents
    implements WindowListener {
        SplashWindow sw;

        WindowsEvents(SplashWindow sw) {
            this.sw = sw;
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
            this.sw.toFront();
        }
    }

    private static class SplashWindow
    extends JFrame {
        public SplashWindow() {
            this.setUndecorated(true);
            JPanel whole = new JPanel();
            whole.setBorder(BorderFactory.createLineBorder(new Color(0, 170, 0), 5));
            whole.setLayout(new BorderLayout());
            JLabel l = new JLabel(Resources.getResource(class$com$sun$electric$tool$user$ui$TopLevel == null ? (class$com$sun$electric$tool$user$ui$TopLevel = Main.class$("com.sun.electric.tool.user.ui.TopLevel")) : class$com$sun$electric$tool$user$ui$TopLevel, "SplashImage.gif"));
            whole.add((Component)l, "Center");
            JLabel v = new JLabel("Version " + Version.getVersion(), 0);
            whole.add((Component)v, "South");
            Font font = new Font(User.getDefaultFont(), 1, 24);
            v.setFont(font);
            v.setForeground(Color.BLACK);
            v.setBackground(Color.WHITE);
            this.getContentPane().add((Component)whole, "South");
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            WindowsEvents windowsEvents = new WindowsEvents(this);
            this.addWindowListener(windowsEvents);
            this.setVisible(true);
        }
    }
}

