/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import java.util.List;
import org.eclipse.swt.SWT;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.event.DragDropEvent;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.event.MouseWheelEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.status.IStatusMachine;
import org.xmind.gef.status.StatusMachine2;
import org.xmind.gef.tool.IDragDropHandler;
import org.xmind.gef.tool.ITool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTool
implements ITool,
IDragDropHandler {
    private EditDomain domain = null;
    private IStatusMachine statusMachine = null;
    private String contextId = null;

    @Override
    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @Override
    public EditDomain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(EditDomain domain) {
        this.domain = domain;
    }

    public IViewer getTargetViewer() {
        return this.getDomain().getTargetViewer();
    }

    public void setTargetViewer(IViewer viewer) {
        this.getDomain().setTargetViewer(viewer);
    }

    @Override
    public final void activate(ITool prevTool) {
        if (this.getStatus().isStatus(1)) {
            return;
        }
        this.getStatus().setStatus(1, true);
        this.onActivated(prevTool);
    }

    @Override
    public final void deactivate(ITool nextTool) {
        if (!this.getStatus().isStatus(1)) {
            return;
        }
        this.getStatus().setStatus(1, false);
        this.onDeactivated(nextTool);
    }

    protected void onActivated(ITool prevTool) {
    }

    protected void onDeactivated(ITool nextTool) {
        if (nextTool != null) {
            this.copyStatus(nextTool);
        }
    }

    protected ITool copyStatus(ITool next) {
        if (next instanceof AbstractTool) {
            IStatusMachine nextStatus = ((AbstractTool)next).getStatus();
            IStatusMachine status = this.getStatus();
            this.copyStatus(4, status, nextStatus);
            this.copyStatus(8, status, nextStatus);
            this.copyStatus(2, status, nextStatus);
            ((AbstractTool)next).setTargetViewer(this.getTargetViewer());
        }
        return next;
    }

    public IStatusMachine getStatus() {
        if (this.statusMachine == null) {
            this.statusMachine = new StatusMachine2();
        }
        return this.statusMachine;
    }

    private void copyStatus(int key, IStatusMachine fromStatus, IStatusMachine toStatus) {
        toStatus.setStatus(key, fromStatus.isStatus(key));
    }

    public ITool changeActiveTool(String toolType) {
        this.domain.setActiveTool(toolType);
        return this.domain.getActiveTool();
    }

    protected ITool getTool(String toolType) {
        return this.domain.getTool(toolType);
    }

    @Override
    public void focusGained(IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleFocusGained();
    }

    protected boolean handleFocusGained() {
        return false;
    }

    @Override
    public void focusLost(IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleFocusLost();
    }

    protected boolean handleFocusLost() {
        return false;
    }

    @Override
    public void keyDown(KeyEvent ke, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(ke, true);
        this.handleKeyDown(ke);
    }

    protected boolean handleKeyDown(KeyEvent ke) {
        return false;
    }

    @Override
    public void keyUp(KeyEvent ke, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(ke, false);
        this.handleKeyUp(ke);
    }

    protected boolean handleKeyUp(KeyEvent ke) {
        return false;
    }

    protected void captureModifier(KeyEvent ke, boolean pressed) {
        if ((ke.keyCode & SWT.MOD1) != 0) {
            this.getStatus().setStatus(4, pressed);
        }
        if ((ke.keyCode & SWT.MOD2) != 0) {
            this.getStatus().setStatus(8, pressed);
        }
        if ((ke.keyCode & SWT.MOD3) != 0) {
            this.getStatus().setStatus(2, pressed);
        }
    }

    protected void captureModifier(MouseEvent me) {
        this.getStatus().setStatus(4, me.isState(SWT.MOD1));
        this.getStatus().setStatus(8, me.isState(SWT.MOD2));
        this.getStatus().setStatus(2, me.isState(SWT.MOD3));
    }

    @Override
    public void keyTraversed(KeyEvent ke, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleKeyTraversed(ke);
    }

    protected boolean handleKeyTraversed(KeyEvent ke) {
        return false;
    }

    @Override
    public void mouseDoubleClick(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseDoubleClick(me);
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseDown(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseDown(me);
    }

    protected boolean handleMouseDown(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseLongPressed(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleLongPressed(me);
    }

    protected boolean handleLongPressed(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseDrag(MouseDragEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseDrag(me);
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        return false;
    }

    @Override
    public void mouseHover(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseHover(me);
    }

    protected boolean handleMouseHover(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseMove(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseMove(me);
    }

    protected boolean handleMouseMove(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseUp(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseUp(me);
    }

    protected boolean handleMouseUp(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseEntered(me);
    }

    protected boolean handleMouseEntered(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseExited(MouseEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleMouseExited(me);
    }

    protected boolean handleMouseExited(MouseEvent me) {
        return false;
    }

    @Override
    public void mouseWheelScrolled(MouseWheelEvent me, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.captureModifier(me);
        this.handleWheelScrolled(me);
    }

    protected boolean handleWheelScrolled(MouseWheelEvent me) {
        return false;
    }

    @Override
    public void dragEntered(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDragEntered(de);
    }

    protected boolean handleDragEntered(DragDropEvent de) {
        return false;
    }

    @Override
    public void dragExited(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDragExited(de);
    }

    protected boolean handleDragExited(DragDropEvent de) {
        return false;
    }

    @Override
    public void dragOver(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDragOver(de);
    }

    protected boolean handleDragOver(DragDropEvent de) {
        return false;
    }

    @Override
    public void dragOperationChanged(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDragOperationChanged(de);
    }

    protected boolean handleDragOperationChanged(DragDropEvent de) {
        return false;
    }

    @Override
    public void drop(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDrop(de);
    }

    protected boolean handleDrop(DragDropEvent de) {
        return false;
    }

    @Override
    public void dropAccept(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDropAccept(de);
    }

    protected boolean handleDropAccept(DragDropEvent de) {
        return false;
    }

    @Override
    public void dragDismissed(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDragDismissed(de);
    }

    protected boolean handleDragDismissed(DragDropEvent de) {
        return false;
    }

    @Override
    public void dragStarted(DragDropEvent de, IViewer viewer) {
        this.setTargetViewer(viewer);
        this.handleDragStarted(de);
    }

    protected boolean handleDragStarted(DragDropEvent de) {
        return false;
    }

    @Override
    public final void handleRequest(String requestType, IViewer targetViewer) {
        this.getDomain().handleRequest(requestType, targetViewer);
    }

    @Override
    public final void handleRequest(Request request) {
        this.setTargetViewer(request.getTargetViewer());
        this.internalHandleRequest(request);
    }

    protected void internalHandleRequest(Request request) {
        if (request.hasTargets()) {
            this.handleTargetedRequest(request);
        } else {
            this.handleNonTargetedRequest(request);
        }
    }

    protected void handleTargetedRequest(Request request) {
        IPart target = request.getPrimaryTarget();
        String role = this.getDomain().getPartRoles().getRole(request.getType());
        if ((target == null || target instanceof IRootPart) && role != null) {
            target = this.findPartByRole(role, target == null ? request.getTargetViewer().getRootPart() : target);
        }
        if (target != null) {
            target.handleRequest(request, role);
        }
    }

    protected void handleNonTargetedRequest(Request request) {
        IPart part;
        String type = request.getType();
        String role = this.getDomain().getPartRoles().getRole(type);
        if (role != null && (part = this.findPartByRole(role, request.getTargetViewer().getRootPart())) != null && part.hasRole(role)) {
            part.handleRequest(request, role);
        }
    }

    protected IPart findPartByRole(String role, IPart parent) {
        for (IPart p : parent.getChildren()) {
            if (p.hasRole(role)) {
                return p;
            }
            IPart child = this.findPartByRole(role, p);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    protected Request createTargetedRequest(String type, IViewer viewer, boolean includeRootPartIfEmpty) {
        return this.fillTargets(new Request(type).setViewer(viewer).setDomain(this.getDomain()), viewer, includeRootPartIfEmpty);
    }

    protected Request fillTargets(Request request, IViewer viewer, boolean includeRootPartIfEmpty) {
        List<IPart> parts = this.getSelectedParts(viewer);
        if (parts.isEmpty()) {
            if (includeRootPartIfEmpty) {
                request.setPrimaryTarget(viewer.getRootPart());
            }
        } else {
            request.setTargets(parts);
        }
        return request;
    }

    protected List<IPart> getSelectedParts(IViewer viewer) {
        return viewer.getSelectionSupport().getPartSelection();
    }
}

