/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.graphics;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.xmind.gef.draw2d.graphics.GradientPattern;
import org.xmind.gef.draw2d.graphics.ImagePattern;

public class Rotate90Graphics
extends Graphics {
    private Graphics graphics;
    private Pattern lastBgPattern = null;
    private Pattern lastFgPattern = null;

    public Rotate90Graphics(Graphics realGraphics) {
        this.graphics = realGraphics;
    }

    protected Graphics getGraphics() {
        return this.graphics;
    }

    protected float[] rotate(float x, float y) {
        return new float[]{-y, x};
    }

    protected int[] rotate(int x, int y) {
        return new int[]{-y, x};
    }

    protected Rectangle rotate(Rectangle r) {
        return new Rectangle(-r.y - r.height, r.x, r.height, r.width);
    }

    protected Point rotate(Point p) {
        return new Point(-p.y, p.x);
    }

    protected Path rotate(Path path) {
        PathData data = path.getPathData();
        Path newPath = new Path(path.getDevice());
        int index = 0;
        float[] points = data.points;
        byte[] byArray = data.types;
        int n = data.types.length;
        int n2 = 0;
        while (n2 < n) {
            byte type = byArray[n2];
            switch (type) {
                case 1: {
                    float x = points[index++];
                    float y = points[index++];
                    newPath.moveTo(-y, x);
                    break;
                }
                case 2: {
                    float x = points[index++];
                    float y = points[index++];
                    newPath.lineTo(-y, x);
                    break;
                }
                case 4: {
                    float x = points[index++];
                    float y = points[index++];
                    float cx1 = points[index++];
                    float cy1 = points[index++];
                    float cx2 = points[index++];
                    float cy2 = points[index++];
                    newPath.cubicTo(-y, x, -cy1, cx1, -cy2, cx2);
                    break;
                }
                case 3: {
                    float x = points[index++];
                    float y = points[index++];
                    float cx1 = points[index++];
                    float cy1 = points[index++];
                    newPath.quadTo(-y, x, -cy1, cx1);
                    break;
                }
                case 5: {
                    newPath.close();
                }
            }
            ++n2;
        }
        return newPath;
    }

    protected int[] rotate(int[] points) {
        int[] newPoints = new int[points.length];
        int i = 0;
        while (i < points.length) {
            newPoints[i] = -points[i + 1];
            newPoints[i + 1] = points[i];
            i += 2;
        }
        return newPoints;
    }

    protected PointList rotate(PointList points) {
        int size = points.size();
        PointList newPoints = new PointList(size);
        int i = 0;
        while (i < size) {
            Point p = points.getPoint(i);
            newPoints.setPoint(this.rotate(p), i);
            ++i;
        }
        return newPoints;
    }

    private Pattern rotate(GradientPattern p) {
        GradientPattern p2 = new GradientPattern(p.getDevice(), -p.y1, p.x1, -p.y2, p.x2, p.color1, p.alpha1, p.color2, p.alpha2);
        return p2;
    }

    private Pattern rotate(ImagePattern p) {
        ImagePattern p2 = new ImagePattern(p.getDevice(), this.rotate(p.image));
        return p2;
    }

    private Image rotate(Image image) {
        return image;
    }

    public void clipRect(Rectangle r) {
        this.graphics.clipRect(this.rotate(r));
    }

    public void clipPath(Path path) {
        Path p2 = this.rotate(path);
        this.graphics.clipPath(p2);
        p2.dispose();
    }

    public void dispose() {
        if (this.lastBgPattern != null) {
            this.lastBgPattern.dispose();
            this.lastBgPattern = null;
        }
        if (this.lastFgPattern != null) {
            this.lastFgPattern.dispose();
            this.lastFgPattern = null;
        }
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        this.graphics.drawArc(-y - h, x, h, w, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.graphics.drawFocus(-y - h, x, h, w);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.drawImage(srcImage, x1, y1, w1, h1, x2, y2, w2, h2);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawImage(Image srcImage, int x, int y) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.drawImage(srcImage, x, y);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(-y1, x1, -y2, x2);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.graphics.drawOval(-y - h, x, h, w);
    }

    public void drawPath(Path path) {
        Path p2 = this.rotate(path);
        this.graphics.drawPath(p2);
        p2.dispose();
    }

    public void drawPoint(int x, int y) {
        this.graphics.drawPoint(-y, x);
    }

    public void drawPolygon(int[] points) {
        this.graphics.drawPolygon(this.rotate(points));
    }

    public void drawPolygon(PointList points) {
        this.graphics.drawPolygon(this.rotate(points));
    }

    public void drawPolyline(int[] points) {
        this.graphics.drawPolyline(this.rotate(points));
    }

    public void drawPolyline(PointList points) {
        this.graphics.drawPolyline(this.rotate(points));
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.graphics.drawRectangle(-y - height, x, height, width);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRectangle(this.rotate(r), arcHeight, arcWidth);
    }

    public void drawString(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.drawString(s, x, y);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawText(String s, int x, int y, int style) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.drawText(s, x, y, style);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawText(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.drawText(s, x, y);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.drawTextLayout(layout, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        this.graphics.fillArc(-y - h, x, h, w, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.graphics.fillGradient(-y - h, x, h, w, !vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.graphics.fillOval(-y - h, x, h, w);
    }

    public void fillPath(Path path) {
        Path p2 = this.rotate(path);
        this.graphics.fillPath(p2);
        p2.dispose();
    }

    public void fillPolygon(int[] points) {
        this.graphics.fillPolygon(this.rotate(points));
    }

    public void fillPolygon(PointList points) {
        this.graphics.fillPolygon(this.rotate(points));
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.graphics.fillRectangle(-y - height, x, height, width);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRectangle(this.rotate(r), arcHeight, arcWidth);
    }

    public void fillString(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.fillString(s, x, y);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void fillText(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.graphics.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.graphics.rotate(90.0f);
        this.graphics.fillText(s, x, y);
        this.graphics.rotate(-90.0f);
        if (statePushed) {
            try {
                this.graphics.restoreState();
                this.graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public double getAbsoluteScale() {
        return this.graphics.getAbsoluteScale();
    }

    public int getAlpha() {
        return this.graphics.getAlpha();
    }

    public int getAntialias() {
        return this.graphics.getAntialias();
    }

    public Color getBackgroundColor() {
        return this.graphics.getBackgroundColor();
    }

    public Rectangle getClip(Rectangle rect) {
        rect = this.graphics.getClip(rect);
        int rx = rect.y;
        int ry = -rect.x - rect.width;
        int rw = rect.height;
        int rh = rect.width;
        rect.x = rx;
        rect.y = ry;
        rect.width = rw;
        rect.height = rh;
        return rect;
    }

    public int getFillRule() {
        return this.graphics.getFillRule();
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.graphics.getForegroundColor();
    }

    public int getInterpolation() {
        return this.graphics.getInterpolation();
    }

    public int getLineCap() {
        return this.graphics.getLineCap();
    }

    public int getLineJoin() {
        return this.graphics.getLineJoin();
    }

    public int getLineStyle() {
        return this.graphics.getLineStyle();
    }

    public int getLineWidth() {
        return this.graphics.getLineWidth();
    }

    public int getTextAntialias() {
        return this.graphics.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.graphics.getXORMode();
    }

    public void popState() {
        this.graphics.popState();
    }

    public void pushState() {
        this.graphics.pushState();
    }

    public void restoreState() {
        this.graphics.restoreState();
    }

    public void rotate(float degrees) {
        this.graphics.rotate(degrees);
    }

    public void scale(double amount) {
        this.graphics.scale(amount);
    }

    public void scale(float horizontal, float vertical) {
        this.graphics.scale(horizontal, vertical);
    }

    public void setAlpha(int alpha) {
        this.graphics.setAlpha(alpha);
    }

    public void setAntialias(int value) {
        this.graphics.setAntialias(value);
    }

    public void setBackgroundColor(Color rgb) {
        this.graphics.setBackgroundColor(rgb);
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.lastBgPattern != null) {
            this.lastBgPattern.dispose();
            this.lastBgPattern = null;
        }
        if (pattern instanceof GradientPattern) {
            Pattern p = this.rotate((GradientPattern)pattern);
            this.graphics.setBackgroundPattern(p);
            this.lastBgPattern = p;
        } else if (pattern instanceof ImagePattern) {
            Pattern p = this.rotate((ImagePattern)pattern);
            this.graphics.setBackgroundPattern(p);
            this.lastBgPattern = p;
        } else {
            this.graphics.setBackgroundPattern(pattern);
        }
    }

    public void setClip(Path path) {
        Path p2 = this.rotate(path);
        this.graphics.setClip(p2);
        p2.dispose();
    }

    public void setClip(Rectangle r) {
        this.graphics.setClip(this.rotate(r));
    }

    public void setFillRule(int rule) {
        this.graphics.setFillRule(rule);
    }

    public void setFont(Font f) {
        this.graphics.setFont(f);
    }

    public void setForegroundColor(Color rgb) {
        this.graphics.setForegroundColor(rgb);
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.lastFgPattern != null) {
            this.lastFgPattern.dispose();
            this.lastFgPattern = null;
        }
        if (pattern instanceof GradientPattern) {
            Pattern p = this.rotate((GradientPattern)pattern);
            this.graphics.setForegroundPattern(p);
            this.lastFgPattern = p;
        } else if (pattern instanceof ImagePattern) {
            Pattern p = this.rotate((ImagePattern)pattern);
            this.graphics.setForegroundPattern(p);
            this.lastFgPattern = p;
        } else {
            this.graphics.setForegroundPattern(pattern);
        }
    }

    public void setInterpolation(int interpolation) {
        this.graphics.setInterpolation(interpolation);
    }

    public void setLineCap(int cap) {
        this.graphics.setLineCap(cap);
    }

    public void setLineDash(int[] dash) {
        this.graphics.setLineDash(dash);
    }

    public void setLineJoin(int join) {
        this.graphics.setLineJoin(join);
    }

    public void setLineStyle(int style) {
        this.graphics.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.graphics.setLineWidth(width);
    }

    public void setTextAntialias(int value) {
        this.graphics.setTextAntialias(value);
    }

    public void setXORMode(boolean b) {
        this.graphics.setXORMode(b);
    }

    public void shear(float horz, float vert) {
        this.graphics.shear(horz, vert);
    }

    public void translate(float dx, float dy) {
        this.graphics.translate(-dy, dx);
    }

    public void translate(int dx, int dy) {
        this.graphics.translate(-dy, dx);
    }

    public boolean getAdvanced() {
        return this.graphics.getAdvanced();
    }

    public float getLineWidthFloat() {
        return this.graphics.getLineWidthFloat();
    }

    public LineAttributes getLineAttributes() {
        return this.graphics.getLineAttributes();
    }

    public float getLineMiterLimit() {
        return this.graphics.getLineMiterLimit();
    }

    public void setAdvanced(boolean advanced) {
        this.graphics.setAdvanced(advanced);
    }

    public void setLineMiterLimit(float miterLimit) {
        this.graphics.setLineMiterLimit(miterLimit);
    }

    public void setLineWidthFloat(float width) {
        this.graphics.setLineWidthFloat(width);
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.graphics.setLineAttributes(attributes);
    }

    public void setLineDash(float[] value) {
        this.graphics.setLineDash(value);
    }
}

