/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xmind.core.internal.runtime.BundleResourceFinder;

public final class BundleResource {
    private static final String SCHEME_PLATFORM = "platform";
    private static final String TYPE_PLUGIN = "plugin";
    private final Bundle bundle;
    private final IPath path;

    public BundleResource(Bundle bundle, IPath path) {
        Assert.isNotNull((Object)bundle);
        this.bundle = bundle;
        this.path = path == null ? Path.EMPTY : path;
    }

    public BundleResource(URL platformURL) {
        Assert.isNotNull((Object)platformURL);
        Assert.isLegal((boolean)SCHEME_PLATFORM.equals(platformURL.getProtocol()));
        String fullPathString = platformURL.getPath();
        Assert.isLegal((fullPathString != null && !"".equals(fullPathString) ? 1 : 0) != 0);
        Path fullPath = new Path(fullPathString);
        String type = fullPath.segment(0);
        Assert.isLegal((boolean)TYPE_PLUGIN.equals(type));
        fullPath = fullPath.removeFirstSegments(1);
        String bundleId = fullPath.segment(0);
        Assert.isLegal((bundleId != null && !"".equals(bundleId) ? 1 : 0) != 0);
        Bundle bundle = Platform.getBundle((String)bundleId);
        Assert.isLegal((bundle != null ? 1 : 0) != 0);
        this.bundle = bundle;
        this.path = fullPath.removeFirstSegments(1);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public IPath getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BundleResource)) {
            return false;
        }
        BundleResource that = (BundleResource)obj;
        return this.bundle.equals(that.bundle) && this.path.equals((Object)that.path);
    }

    public int hashCode() {
        return 0x25 ^ this.bundle.hashCode() ^ this.path.hashCode();
    }

    public String toString() {
        return this.toPlatformURL().toExternalForm();
    }

    public URL toPlatformURL() {
        IPath urlPath = Path.ROOT.append(TYPE_PLUGIN).addTrailingSeparator().append(this.bundle.getSymbolicName()).addTrailingSeparator().append(this.path);
        try {
            return new URL(SCHEME_PLATFORM, null, urlPath.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(String.format("Failed to construct platform URL: bundle=%s, path=%s", this.bundle.getSymbolicName(), this.path), e);
        }
    }

    public BundleResource resolve() {
        return BundleResourceFinder.resolve(this);
    }
}

