/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.net.util.LinkUtils;

public class BetaVerifier {
    private static long BETA_EXPIRY_TIME = 0L;
    private static long LAUNCH_TIME = System.currentTimeMillis();
    private final Display display;
    private final String brandingVersion;
    private final String buildId;

    public BetaVerifier(Display display) {
        this.display = display;
        this.brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
        this.buildId = System.getProperty("org.xmind.product.buildid", "X.x.x");
    }

    public boolean shouldExitAfterBetaExpired() {
        String licenseRestrictions;
        if (BetaVerifier.isBeta() && BetaVerifier.isBetaExpired()) {
            this.promptBetaExpiry();
            return true;
        }
        if (BetaVerifier.isBeta() && ((licenseRestrictions = System.getProperty("org.xmind.product.license.restrictions")) == null || "".equals(licenseRestrictions))) {
            licenseRestrictions = NLS.bind((String)WorkbenchMessages.About_BetaExpiryMessage_withExpiryTime, (Object)new SimpleDateFormat("MMM d, yyyy").format(new Date(BETA_EXPIRY_TIME)));
            System.setProperty("org.xmind.product.license.restrictions", licenseRestrictions);
        }
        return false;
    }

    private int openMessageDialog(String message, int dialogType, String[] buttonLabels) {
        URL titleIconURL = Platform.getBundle((String)"org.xmind.cathy").getResource("icons/xmind.16.png");
        Image titleIcon = null;
        try {
            titleIcon = new Image((Device)this.display, titleIconURL.openStream());
        }
        catch (IOException iOException) {}
        try {
            MessageDialog dialog = new MessageDialog(null, WorkbenchMessages.BetaVerifier_BetaExpiredPromptDialog_windowTitle, titleIcon, message, dialogType, buttonLabels, 0);
            int n = dialog.open();
            return n;
        }
        finally {
            if (titleIcon != null) {
                titleIcon.dispose();
            }
        }
    }

    private void promptBetaExpiry() {
        int selection = this.openMessageDialog(NLS.bind((String)WorkbenchMessages.BetaVerifier_BetaExpiredPromptDialog_message_withBrandingVersion_andBuildId, (Object)this.brandingVersion, (Object)this.buildId), 2, new String[]{WorkbenchMessages.BetaVerifier_BetaExpiredPromptDialog_CheckAndInstallButton_text, WorkbenchMessages.BetaVerifier_BetaExpiredPromptDialog_ExitButton_text});
        if (selection == 0) {
            this.openDownloadSite();
        }
    }

    private void openDownloadSite() {
        Program.launch((String)(String.valueOf(LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/xmind/beta-expired/")) + this.buildId.replace("qualifier", "000000000000")));
    }

    public static boolean isBeta() {
        return BETA_EXPIRY_TIME > 0L;
    }

    public static boolean isBetaExpired() {
        return LAUNCH_TIME > BETA_EXPIRY_TIME;
    }
}

