/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.URLWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRefFactory;

public class WorkbookRefFactoryManager
implements IWorkbookRefFactory,
IRegistryEventListener {
    private List<WorkbookRefFactoryDescriptor> factories = null;
    private IExtensionRegistry registry = null;

    @Override
    public synchronized IWorkbookRef createWorkbookRef(URI uri, IMemento state) {
        IWorkbookRefFactory factory = this.getWorkbookRefFactoryForURI(uri);
        if (factory != null) {
            return factory.createWorkbookRef(uri, state);
        }
        return URLWorkbookRef.create(uri, state);
    }

    private synchronized IWorkbookRefFactory getWorkbookRefFactoryForURI(URI uri) {
        this.ensureLoaded();
        String scheme = uri.getScheme();
        for (WorkbookRefFactoryDescriptor factory : this.factories) {
            if (!factory.isAvailableForURIScheme(scheme)) continue;
            return factory.getInstance();
        }
        return null;
    }

    private synchronized void ensureLoaded() {
        if (this.factories != null) {
            return;
        }
        this.factories = new ArrayList<WorkbookRefFactoryDescriptor>();
        this.registry = Platform.getExtensionRegistry();
        if (this.registry == null) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Extension registry is not available"));
            return;
        }
        IExtensionPoint extPoint = this.registry.getExtensionPoint("org.xmind.ui", "workbookRefFactories");
        if (extPoint == null) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Extension point 'org.xmind.ui.workbookRefFactories' not found."));
            return;
        }
        this.registry.addListener((IRegistryEventListener)this, extPoint.getUniqueIdentifier());
        this.readExtensions(extPoint.getExtensions());
    }

    private void readExtensions(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("factory".equals(element.getName())) {
                    WorkbookRefFactoryDescriptor desc = new WorkbookRefFactoryDescriptor(element);
                    this.factories.add(desc);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public synchronized void dispose() {
        if (this.factories != null) {
            Object[] objectArray = this.factories.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((WorkbookRefFactoryDescriptor)o).dispose();
                ++n2;
            }
            this.factories.clear();
            this.factories = null;
        }
        if (this.registry != null) {
            this.registry.removeListener((IRegistryEventListener)this);
            this.registry = null;
        }
    }

    public void added(IExtension[] extensions) {
        this.readExtensions(extensions);
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            Object[] objectArray = this.factories.toArray();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object o = objectArray[n4];
                if (((WorkbookRefFactoryDescriptor)o).isFromExtension(ext)) {
                    this.factories.remove(o);
                    ((WorkbookRefFactoryDescriptor)o).dispose();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private static class WorkbookRefFactoryDescriptor {
        private IConfigurationElement element;
        private final Set<String> schemes;
        private volatile IWorkbookRefFactory factoryInstance;

        private WorkbookRefFactoryDescriptor(IConfigurationElement element) {
            if (element.getAttribute("class") == null) {
                throw new IllegalArgumentException("No 'class' attribute on factory element (contributed by " + element.getContributor().getName() + ")");
            }
            this.element = element;
            this.schemes = new HashSet<String>();
            IConfigurationElement[] iConfigurationElementArray = element.getChildren("availableForURIScheme");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement schemeTag = iConfigurationElementArray[n2];
                String scheme = schemeTag.getAttribute("scheme");
                if (scheme != null) {
                    this.schemes.add(scheme);
                }
                ++n2;
            }
        }

        public synchronized IWorkbookRefFactory getInstance() {
            if (this.factoryInstance == null && this.element != null) {
                Object ins = null;
                try {
                    ins = this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    MindMapUIPlugin.getDefault().getLog().log(e.getStatus());
                }
                if (ins != null && ins instanceof IWorkbookRefFactory) {
                    this.factoryInstance = (IWorkbookRefFactory)ins;
                }
            }
            return this.factoryInstance;
        }

        public synchronized void dispose() {
            this.schemes.clear();
            this.element = null;
            this.factoryInstance = null;
        }

        public boolean isAvailableForURIScheme(String scheme) {
            return this.schemes.contains(scheme);
        }

        public boolean isFromExtension(IExtension ext) {
            return this.element != null && ext != null && ext.equals((Object)this.element.getDeclaringExtension());
        }
    }
}

