/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.Core;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIdeasToGroupCommand
extends SourceCommand {
    private ITopic rootTopic;
    private String groupName;
    private List<ITopicExtensionElement> noGroupIdeas;
    private String groupId;
    private ITopicExtensionElement groupParent;
    private ITopicExtensionElement addedGroup;
    private int groupIndex;
    private String oldGroupId;

    public AddIdeasToGroupCommand(ITopic rootTopic, String groupName, List<ITopicExtensionElement> noGroupIdeas) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.groupName = groupName == null ? "" : groupName;
        Assert.isLegal((noGroupIdeas != null && noGroupIdeas.size() > 0 ? 1 : 0) != 0);
        this.noGroupIdeas = new ArrayList<ITopicExtensionElement>(noGroupIdeas);
        this.groupId = Core.getIdFactory().createId();
        this.setLabel(IdeaFactoryMessages.AddIdeasToGroupCommand_Label);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        ITopicExtension ext = this.rootTopic.createExtension("org.xmind.ui.ideafactory");
        ITopicExtensionElement content = ext.getContent();
        this.groupParent = (ITopicExtensionElement)content.getCreatedChild("groups");
        if (this.addedGroup == null) {
            this.addedGroup = (ITopicExtensionElement)this.groupParent.createChild("group");
            this.addedGroup.setAttribute("id", this.groupId);
            this.addedGroup.setTextContent(this.groupName);
            this.groupIndex = this.groupParent.getChildren().size();
        } else {
            this.groupParent.addChild((IExtensionElement)this.addedGroup, this.groupIndex);
        }
        if (this.oldGroupId == null) {
            this.oldGroupId = this.noGroupIdeas.get(0).getAttribute("group_id");
        }
        for (ITopicExtensionElement idea : this.noGroupIdeas) {
            idea.setAttribute("group_id", this.groupId);
        }
        this.fireCoreEvent(this.rootTopic, "addIdeasToGroup");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.groupParent.deleteChild((IExtensionElement)this.addedGroup);
        for (ITopicExtensionElement idea : this.noGroupIdeas) {
            idea.setAttribute("group_id", this.oldGroupId);
        }
        this.fireCoreEvent(this.rootTopic, "removeIdeasFromGroup");
        super.undo();
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)topic, eventType, (Object)this.addedGroup, this.groupIndex - 1);
        }
    }
}

