/* winCounts.h was originally generated by the autoSql program, which also 
 * generated winCounts.c  It was extensively modified to meet the needs of
 * this program.
 */

#ifndef WINCOUNTS_H
#define WINCOUNTS_H

#include "common.h"
#include <stdio.h>

struct winCounts
/* Counts collected for a fixed, non-overlaping window.  Note that
 * the array of letter pairs are in alphabetical order (AA, AC, ... TT),
 * as this seems to be the format most widely prefered (at least with our
 * collaborators).  This is not the same as dnautil.h ordering of bases.
 */
    {
    struct winCounts *next;  /* Next in singly linked list. */
    char *chrom;	     /* chromosome */
    unsigned chromStart;     /* Start position in chromosome */
    unsigned chromEnd;	     /* End position in chromosome */
    unsigned numCounts;	     /* Number of non-n-base counts */
    unsigned baseCounts[16]; /* 4x4 matrix of counts, AA AC, ... TT */
    unsigned firstCountPos;  /* Positions of first/last count in window */
    unsigned lastCountPos;
    };

struct winCounts *winCountsNew(char *chrom);
/* Allocate a new winCounts object. */

void winCountsFree(struct winCounts **pEl);
/* Free a single dynamically allocated winCounts such as created
 * with winCountsLoad(). */

void winCountsFreeList(struct winCounts **pList);
/* Free a list of dynamically allocated winCounts's */

void winCountsReset(struct winCounts *el);
/* Reset counts in a winCounts object. */

void winCountsIncrCount(struct winCounts *el, char base0, char base1, unsigned pos);
/* Increment the count of occurances of base1 aligned to base0 */

int winCountsGetCount(struct winCounts *el, char base0, char base1);
/* Get the count of occurances of base1 aligned to base0 */

void winCountsSum(struct winCounts *dest, struct winCounts *src);
/* Sum src counts with dest counts, storing in dest counts. */

void winCountsStaticLoad(char **row, struct winCounts *ret);
/* Load a row from winCounts table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct winCounts *winCountsLoad(char **row);
/* Load a winCounts from row fetched with select * from winCounts
 * from database.  Dispose of this with winCountsFree(). */

struct winCounts *winCountsLoadAll(char *fileName);
/* Load all winCounts from a tab-separated file.
 * Dispose of this with winCountsFreeList(). */

void winCountsTabHeaderOut(FILE *f);
/* Print out header for tab-separated file. */

void winCountsTabOut(struct winCounts *el, FILE *f, boolean tightCoords, char *winVal);
/* Print out winCounts as a line in a tab-separated file.
 * If tight coords is true, output start/end of counts rather than windows. */
#endif /* WINCOUNTS_H */

