# stsInfo.sql was originally generated by the autoSql program, which also 
# generated stsInfo.c and stsInfo.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Constant STS marker information
CREATE TABLE stsInfo (
    identNo int unsigned not null,	# UCSC identification number
    name varchar(255) not null,	# Official UCSC name
    gbCount int unsigned not null,	# Number of related GenBank accessions
    genbank longblob,			# Related GeneBank accessions
    gdbCount int unsigned not null,	# Number of related GDB identifiers
    gdb longblob,			# Related GDB identifies
    nameCount int unsigned not null,	# Number of alias names
    otherNames longblob,		# Alias names
    dbSTSid int unsigned not null,	# ID number in UniSTS or dbSTS
    otherDbstsCount int unsigned not null,	# Number of related dbSTS IDs
    otherDbSTS longblob,		# Related dbSTS IDs
    leftPrimer varchar(255),		# 5' primer sequence
    rightPrimer varchar(255),		# 3' primer sequence
    distance varchar(255),		# Length of STS sequence
    organism varchar(255) not null,	# Organism for which STS discovered
    sequence int unsigned not null,	# Whether the full sequence is available (1) or not (0) for STS
    otherUCSCcount int unsigned not null,	# Number of related active UCSC ids
    otherUCSC longblob,			# Related active UCSC ids
    mergeUCSCcount int unsigned not null,	# Number of merged inactive UCSC ids
    mergeUCSC longblob,			# Related merged inactive UCSC ids
    genethonName varchar(255),		# Name in Genethon map
    genethonChr varchar(255),		# Chromosome in Genethon map
    genethonPos float not null,		# Position in Genethon map
    genethonLOD float not null,		# LOD score in Genethon map
    marshfieldName varchar(255),	# Name in Marshfield map
    marshfieldChr varchar(255),		# Chromosome in Marshfield map
    marshfieldPos float not null,	# Position in Marshfield map
    marshfieldLOD float not null,	# LOD score in Marshfield map
    wiyacName varchar(255),		# Name in WI YAC map
    wiyacChr varchar(255),		# Chromosome in WI YAC map
    wiyacPos float not null,		# Position in WI YAC map
    wiyacLOD float not null,		# LOD score in WI YAC map
    wirhName varchar(255),		# Name in WI RH map
    wirhChr varchar(255),		# Chromosome in WI RH map
    wirhPos float not null,		# Position in WI RH map
    wirhLOD float not null,		# LOD score in WI RH map
    gm99gb4Name varchar(255),		# Name in GeneMap99 GB4 map
    gm99gb4Chr varchar(255),		# Chromosome in GeneMap99 GB4 map
    gm99gb4Pos float not null,		# Position in GeneMap99 GB4 map
    gm99gb4LOD float not null,		# LOD score in GeneMap99 GB4 map
    gm99g3Name varchar(255),		# Name in GeneMap99 G3 map
    gm99g3Chr varchar(255),		# Chromosome in GeneMap99 G3 map
    gm99g3Pos float not null,		# Position in GeneMap99 G3 map
    gm99g3LOD float not null,		# LOD score in GenMap99 G3 map
    tngName varchar(255),		# Name in Stanford TNG map
    tngChr varchar(255),		# Chromosome in Stanford TNG map
    tngPos float not null,		# Position in Stanford TNG map
    tngLOD float not null,		# LOD score in Stanford TNG map
              #Indices
    PRIMARY KEY(identNo)
);

