# first.sql was originally generated by the autoSql program, which also 
# generated first.c and first.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Summary of large genomic Duplications (>1KB >90% similar)
CREATE TABLE genomicSuperDups (
    bin smallint not null,      # Index field
    chrom varchar(255) not null,	# Human chromosome or FPC contig
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Other chromosome involved
    score int unsigned not null,	# Score from 900-1000. 1000 is the best
    strand char(1) not null,	# Value should be + or -
    otherChrom varchar(255) not null,	# Other chromosome or scaffold
    otherStart int unsigned not null,	# Start in other sequence
    otherEnd int unsigned not null,	# End in other sequence
    otherSize int unsigned not null,	# Total size of other sequence (otherEnd - otherStart)
    uid int unsigned not null,	# Unique id shared by the query and subject of a hit
    posBasesHit int unsigned not null,	# For future use
    testResult varchar(255) not null,	# For future use
    verdict varchar(255) not null,	# For future use
    chits varchar(255) not null, 	# For future use
    ccov varchar(255) not null,		# For future use
    alignfile varchar(255) not null,	# alignment file path
    alignL int unsigned not null,	# spaces/positions in alignment
    indelN int unsigned not null,	# number of indels
    indelS int unsigned not null,	# indel spaces
    alignB int unsigned not null,	# bases Aligned
    matchB int unsigned not null,	# aligned bases that match
    mismatchB int unsigned not null,	# aligned bases that do not match
    transitionsB int unsigned not null,	# number of transitions
    transversionsB int unsigned not null,	# number of transversions
    fracMatch float not null,	# fraction of matching bases
    fracMatchIndel float not null,	# fraction of matching bases with indels
    jcK float not null,	# K-value calculated with Jukes-Cantor
    k2K float not null,	# Kimura K
              #Indices
    INDEX (name(32)),
    INDEX (chrom(8), bin),
    INDEX (chrom(8), chromStart)
);
