/* stsMapMouse.h was originally generated by the autoSql program, which also 
 * generated stsMapMouse.c and stsMapMouse.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef STSMAPMOUSE_H
#define STSMAPMOUSE_H

struct stsMapMouse
/* STS marker and its position on mouse assembly */
    {
    struct stsMapMouse *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome or 'unknown' */
    int chromStart;	/* Start position in chrom - negative 1 if unpositioned */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* Name of STS marker */
    unsigned score;     /* Score of a marker = 1000/(#placements) when placed uniquely, else 1500/(#placements) when placed in multiple locations */
    unsigned identNo;	/* UCSC Id No. */
    unsigned probeId;	/* Probe Identification number of STS */
    unsigned markerId;	/* Marker Identification number of STS */
    };

void stsMapMouseStaticLoad(char **row, struct stsMapMouse *ret);
/* Load a row from stsMapMouse table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct stsMapMouse *stsMapMouseLoad(char **row);
/* Load a stsMapMouse from row fetched with select * from stsMapMouse
 * from database.  Dispose of this with stsMapMouseFree(). */

struct stsMapMouse *stsMapMouseLoadAll(char *fileName);
/* Load all stsMapMouse from a tab-separated file.
 * Dispose of this with stsMapMouseFreeList(). */

struct stsMapMouse *stsMapMouseLoadWhere(struct sqlConnection *conn, char *table, char *where);
/* Load all stsMapMouse from table that satisfy where clause. The
 * where clause may be NULL in which case whole table is loaded
 * Dispose of this with stsMapMouseFreeList(). */

struct stsMapMouse *stsMapMouseCommaIn(char **pS, struct stsMapMouse *ret);
/* Create a stsMapMouse out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stsMapMouse */

void stsMapMouseFree(struct stsMapMouse **pEl);
/* Free a single dynamically allocated stsMapMouse such as created
 * with stsMapMouseLoad(). */

void stsMapMouseFreeList(struct stsMapMouse **pList);
/* Free a list of dynamically allocated stsMapMouse's */

void stsMapMouseOutput(struct stsMapMouse *el, FILE *f, char sep, char lastSep);
/* Print out stsMapMouse.  Separate fields with sep. Follow last field with lastSep. */

#define stsMapMouseTabOut(el,f) stsMapMouseOutput(el,f,'\t','\n');
/* Print out stsMapMouse as a line in a tab-separated file. */

#define stsMapMouseCommaOut(el,f) stsMapMouseOutput(el,f,',',',');
/* Print out stsMapMouse as a comma separated list including final comma. */

#endif /* STSMAPMOUSE_H */

