/* cnpSharp2.h was originally generated by the autoSql program, which also 
 * generated cnpSharp2.c and cnpSharp2.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CNPSHARP2_H
#define CNPSHARP2_H

#define CNPSHARP2_NUM_COLS 5

struct cnpSharp2
/* CNP data from Sharp lab */
    {
    struct cnpSharp2 *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* BAC name */
    char *variationType;	/* Gain, Loss, Gain and Loss */
    };

void cnpSharp2StaticLoad(char **row, struct cnpSharp2 *ret);
/* Load a row from cnpSharp2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cnpSharp2 *cnpSharp2Load(char **row);
/* Load a cnpSharp2 from row fetched with select * from cnpSharp2
 * from database.  Dispose of this with cnpSharp2Free(). */

struct cnpSharp2 *cnpSharp2LoadAll(char *fileName);
/* Load all cnpSharp2 from whitespace-separated file.
 * Dispose of this with cnpSharp2FreeList(). */

struct cnpSharp2 *cnpSharp2LoadAllByChar(char *fileName, char chopper);
/* Load all cnpSharp2 from chopper separated file.
 * Dispose of this with cnpSharp2FreeList(). */

#define cnpSharp2LoadAllByTab(a) cnpSharp2LoadAllByChar(a, '\t');
/* Load all cnpSharp2 from tab separated file.
 * Dispose of this with cnpSharp2FreeList(). */

struct cnpSharp2 *cnpSharp2CommaIn(char **pS, struct cnpSharp2 *ret);
/* Create a cnpSharp2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSharp2 */

void cnpSharp2Free(struct cnpSharp2 **pEl);
/* Free a single dynamically allocated cnpSharp2 such as created
 * with cnpSharp2Load(). */

void cnpSharp2FreeList(struct cnpSharp2 **pList);
/* Free a list of dynamically allocated cnpSharp2's */

void cnpSharp2Output(struct cnpSharp2 *el, FILE *f, char sep, char lastSep);
/* Print out cnpSharp2.  Separate fields with sep. Follow last field with lastSep. */

#define cnpSharp2TabOut(el,f) cnpSharp2Output(el,f,'\t','\n');
/* Print out cnpSharp2 as a line in a tab-separated file. */

#define cnpSharp2CommaOut(el,f) cnpSharp2Output(el,f,',',',');
/* Print out cnpSharp2 as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CNPSHARP2_H */

