/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.UnreadableFile;
import com.google.jstestdriver.config.UnreadableFilesException;
import com.google.jstestdriver.hooks.FileParsePostProcessor;
import com.google.jstestdriver.util.DisplayPathSanitizer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.oro.io.GlobFilenameFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathResolver {
    private final Set<FileParsePostProcessor> processors;
    private final File basePath;
    private DisplayPathSanitizer sanitizer;

    @Inject
    public PathResolver(@Named(value="basePath") File basePath, Set<FileParsePostProcessor> processors, DisplayPathSanitizer sanitizer) {
        this.basePath = basePath;
        this.processors = processors;
        this.sanitizer = sanitizer;
    }

    public File resolvePath(String filePath) {
        return !filePath.startsWith(File.separator) && this.basePath != null ? new File(this.basePath.getAbsoluteFile(), filePath) : new File(filePath);
    }

    private Set<FileInfo> consolidatePatches(Set<FileInfo> resolvedFilesLoad) {
        LinkedHashSet<FileInfo> consolidated = new LinkedHashSet<FileInfo>(resolvedFilesLoad.size());
        FileInfo currentNonPatch = null;
        for (FileInfo fileInfo : resolvedFilesLoad) {
            if (fileInfo.isPatch()) {
                if (currentNonPatch == null) {
                    throw new IllegalStateException("Patch " + fileInfo + " without a core file to patch");
                }
                currentNonPatch.addPatch(fileInfo);
                continue;
            }
            consolidated.add(fileInfo);
            currentNonPatch = fileInfo;
        }
        return consolidated;
    }

    public Set<FileInfo> resolve(Set<FileInfo> unresolvedFiles) {
        Set<FileInfo> resolvedFiles = new LinkedHashSet<FileInfo>();
        LinkedList<UnreadableFile> unreadable = Lists.newLinkedList();
        for (FileInfo fileInfo : unresolvedFiles) {
            String[] expandedFileNames;
            String filePath = fileInfo.getFilePath();
            if (fileInfo.isWebAddress()) {
                resolvedFiles.add(fileInfo.fromResolvedPath(filePath, filePath, -1L));
                continue;
            }
            File file = this.resolvePath(filePath);
            File absoluteDir = file.getParentFile().getAbsoluteFile();
            for (String fileName : expandedFileNames = this.expandGlob(absoluteDir.getAbsolutePath(), file.getName(), absoluteDir)) {
                File sourceFile = new File(absoluteDir, fileName);
                if (!sourceFile.canRead()) {
                    unreadable.add(new UnreadableFile(fileInfo.getFilePath(), sourceFile.getAbsolutePath()));
                    continue;
                }
                String absolutePath = sourceFile.getAbsolutePath();
                String displayPath = this.sanitizer.sanitize(absolutePath);
                File resolvedFile = new File(absolutePath);
                long timestamp = resolvedFile.lastModified();
                FileInfo newFileInfo = fileInfo.fromResolvedPath(absolutePath, displayPath, timestamp);
                resolvedFiles.add(newFileInfo);
            }
        }
        if (!unreadable.isEmpty()) {
            throw new UnreadableFilesException(unreadable);
        }
        resolvedFiles = this.postProcessFiles(resolvedFiles);
        return this.consolidatePatches(resolvedFiles);
    }

    private String[] expandGlob(String filePath, String fileNamePattern, File dir) {
        String[] filteredFiles = dir.list(new GlobFilenameFilter(fileNamePattern, 1));
        if (filteredFiles == null || filteredFiles.length == 0) {
            try {
                String error = "The patterns/paths " + filePath + " (" + dir + ") " + " used in the configuration" + " file didn't match any file, the files patterns/paths need to" + " be relative " + this.basePath.getCanonicalPath();
                throw new IllegalArgumentException(error);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Arrays.sort(filteredFiles, String.CASE_INSENSITIVE_ORDER);
        return filteredFiles;
    }

    public List<Plugin> resolve(List<Plugin> plugins) {
        LinkedList<UnreadableFile> unreadable = Lists.newLinkedList();
        LinkedList<Plugin> resolved = Lists.newLinkedList();
        for (Plugin plugin : plugins) {
            File resolvedFile = this.resolvePath(plugin.getPathToJar());
            if (!resolvedFile.canRead()) {
                unreadable.add(new UnreadableFile(plugin.getPathToJar(), resolvedFile.getAbsolutePath()));
                continue;
            }
            resolved.add(plugin.getPluginFromPath(resolvedFile.getAbsolutePath()));
        }
        if (!unreadable.isEmpty()) {
            throw new UnreadableFilesException(unreadable);
        }
        return resolved;
    }

    private Set<FileInfo> postProcessFiles(Set<FileInfo> resolvedFiles) {
        Set<FileInfo> processedFiles = resolvedFiles;
        for (FileParsePostProcessor processor : this.processors) {
            processedFiles = processor.process(resolvedFiles);
        }
        return processedFiles;
    }
}

