/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AutomaticGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.groups.WordKeywordGroup;
import org.jabref.model.util.OptionalUtil;

public class AutomaticPersonsGroup
extends AutomaticGroup {
    private String field;

    public AutomaticPersonsGroup(String name, GroupHierarchyType context, String field2) {
        super(name, context);
        this.field = field2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutomaticPersonsGroup that = (AutomaticPersonsGroup)o;
        return Objects.equals(this.field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field);
    }

    @Override
    public AbstractGroup deepCopy() {
        return new AutomaticPersonsGroup(this.name, this.context, this.field);
    }

    @Override
    public Set<GroupTreeNode> createSubgroups(BibEntry entry) {
        Optional<AuthorList> authorList = entry.getLatexFreeField(this.field).map(AuthorList::parse);
        return OptionalUtil.flatMap(authorList, AuthorList::getAuthors).map(Author::getLast).filter(Optional::isPresent).map(Optional::get).filter(lastName -> !lastName.isEmpty()).map(lastName -> new WordKeywordGroup((String)lastName, GroupHierarchyType.INDEPENDENT, this.field, (String)lastName, true, Character.valueOf(' '), true)).map(GroupTreeNode::new).collect(Collectors.toSet());
    }

    public String getField() {
        return this.field;
    }
}

