/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.event;

import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.EntryChangedEvent;
import org.jabref.model.entry.event.EntryEventSource;

public class FieldChangedEvent
extends EntryChangedEvent {
    private final String fieldName;
    private final String newValue;
    private final String oldValue;
    private int delta = 0;

    public FieldChangedEvent(BibEntry bibEntry, String fieldName, String newValue, String oldValue, EntryEventSource location) {
        super(bibEntry, location);
        this.fieldName = fieldName;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.delta = this.computeDelta(oldValue, newValue);
    }

    public FieldChangedEvent(BibEntry bibEntry, String fieldName, String newValue, String oldValue) {
        super(bibEntry);
        this.fieldName = fieldName;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.delta = this.computeDelta(oldValue, newValue);
    }

    public FieldChangedEvent(FieldChange fieldChange, EntryEventSource location) {
        super(fieldChange.getEntry(), location);
        this.fieldName = fieldChange.getField();
        this.newValue = fieldChange.getNewValue();
        this.oldValue = fieldChange.getOldValue();
        this.delta = this.computeDelta(this.oldValue, this.newValue);
    }

    public FieldChangedEvent(FieldChange fieldChange) {
        this(fieldChange, EntryEventSource.LOCAL);
    }

    private int computeDelta(String oldValue, String newValue) {
        if (oldValue == newValue) {
            return 0;
        }
        if (oldValue == null && newValue != null) {
            return newValue.length();
        }
        if (newValue == null && oldValue != null) {
            return oldValue.length();
        }
        return Math.abs(newValue.length() - oldValue.length());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public int getDelta() {
        return this.delta;
    }
}

