/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.entry.BibtexSingleField;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.specialfields.SpecialField;

public class InternalBibtexFields {
    public static final List<String> DEFAULT_GENERAL_FIELDS = Arrays.asList("crossref", "keywords", "file", "doi", "url", "groups", "owner", "timestamp");
    private static final List<String> INTEGER_FIELDS = Arrays.asList("ctlmax_names_forced_etal", "ctlnames_show_etal", "ctlalt_stretch_factor", "volumes", "pmid");
    private static final List<String> YES_NO_FIELDS = Arrays.asList("ctluse_article_number", "ctluse_paper", "ctluse_url", "ctluse_forced_etal", "ctluse_alt_spacing", "ctldash_repeated_names");
    private static final List<String> DATE_FIELDS = Arrays.asList("date", "eventdate", "origdate", "urldate");
    private static final List<String> PERSON_NAME_FIELDS = Arrays.asList("author", "editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "bookauthor", "holder", "shortauthor", "shorteditor", "sortname", "nameaddon", "assignee");
    private static final List<String> EDITOR_TYPE_FIELDS = Arrays.asList("editortype", "editoratype", "editorbtype", "editorctype");
    private static final List<String> PAGINATION_FIELDS = Arrays.asList("pagination", "bookpagination");
    private static final List<String> JOURNAL_NAME_FIELDS = Arrays.asList("journal", "journaltitle", "journalsubtitle");
    private static final List<String> BOOK_NAME_FIELDS = Arrays.asList("booktitle", "maintitle", "mainsubtitle", "maintitleaddon", "booksubtitle", "booktitleaddon");
    private static final List<String> LANGUAGE_FIELDS = Arrays.asList("language", "origlanguage");
    private static final List<String> MULTI_KEY_FIELDS = Arrays.asList("related", "entryset");
    private static final List<String> VERBATIM_FIELDS = Arrays.asList("url", "file", "ctlname_format_string", "ctlname_latex_cmd", "ctlname_url_prefix");
    private static final List<String> SPECIAL_FIELDS = Arrays.asList(SpecialField.PRINTED.getFieldName(), SpecialField.PRIORITY.getFieldName(), SpecialField.QUALITY.getFieldName(), SpecialField.RANKING.getFieldName(), SpecialField.READ_STATUS.getFieldName(), SpecialField.RELEVANCE.getFieldName());
    private static InternalBibtexFields RUNTIME = new InternalBibtexFields();
    private final Map<String, BibtexSingleField> fieldSet = new HashMap<String, BibtexSingleField>();
    private String timeStampField;

    private InternalBibtexFields() {
        BibtexSingleField field2;
        this.add(new BibtexSingleField("address"));
        this.add(new BibtexSingleField("annote"));
        this.add(new BibtexSingleField("author", true, 280));
        this.add(new BibtexSingleField("booktitle", true, 175));
        this.add(new BibtexSingleField("chapter"));
        this.add(new BibtexSingleField("crossref").withProperties(FieldProperty.SINGLE_ENTRY_LINK, new FieldProperty[0]));
        this.add(new BibtexSingleField("edition"));
        this.add(new BibtexSingleField("editor", true, 280));
        this.add(new BibtexSingleField("eprint").withProperties(FieldProperty.EPRINT, new FieldProperty[0]));
        this.add(new BibtexSingleField("howpublished"));
        this.add(new BibtexSingleField("institution"));
        this.add(new BibtexSingleField("isbn").withProperties(FieldProperty.ISBN, new FieldProperty[0]));
        this.add(new BibtexSingleField("issn"));
        this.add(new BibtexSingleField("journal").withProperties(FieldProperty.JOURNAL_NAME, new FieldProperty[0]));
        this.add(new BibtexSingleField("journaltitle").withProperties(FieldProperty.JOURNAL_NAME, new FieldProperty[0]));
        this.add(new BibtexSingleField("key"));
        this.add(new BibtexSingleField("month").withProperties(FieldProperty.MONTH, new FieldProperty[0]));
        this.add(new BibtexSingleField("monthfiled").withProperties(FieldProperty.MONTH, new FieldProperty[0]));
        this.add(new BibtexSingleField("note"));
        this.add(new BibtexSingleField("number", true, 60).setNumeric());
        this.add(new BibtexSingleField("organization"));
        this.add(new BibtexSingleField("pages"));
        this.add(new BibtexSingleField("publisher"));
        this.add(new BibtexSingleField("school"));
        this.add(new BibtexSingleField("series"));
        this.add(new BibtexSingleField("title", true, 400));
        this.add(new BibtexSingleField("type").withProperties(FieldProperty.TYPE, new FieldProperty[0]));
        this.add(new BibtexSingleField("language"));
        this.add(new BibtexSingleField("volume", true, 60).setNumeric());
        this.add(new BibtexSingleField("year", true, 60).setNumeric());
        for (String fieldName : SPECIAL_FIELDS) {
            BibtexSingleField field3 = new BibtexSingleField(fieldName, false);
            field3.setPrivate();
            field3.setWriteable(false);
            field3.setDisplayable(false);
            this.add(field3);
        }
        BibtexSingleField tempField = new BibtexSingleField("bibtexkey").withProperties(FieldProperty.KEY, new FieldProperty[0]);
        tempField.setPrivate();
        this.add(tempField);
        this.add(new BibtexSingleField("doi").withProperties(FieldProperty.DOI, new FieldProperty[0]));
        this.add(new BibtexSingleField("eid"));
        this.add(new BibtexSingleField("date").withProperties(FieldProperty.DATE, new FieldProperty[0]));
        this.add(new BibtexSingleField("pmid", false, 60).setNumeric());
        this.add(new BibtexSingleField("location", false));
        this.add(new BibtexSingleField("abstract", false, 400).withProperties(FieldProperty.MULTILINE_TEXT, new FieldProperty[0]));
        this.add(new BibtexSingleField("url", false).withProperties(FieldProperty.EXTERNAL, FieldProperty.VERBATIM));
        this.add(new BibtexSingleField("comment", false));
        this.add(new BibtexSingleField("keywords", false));
        this.add(new BibtexSingleField("file", false).withProperties(FieldProperty.FILE_EDITOR, FieldProperty.VERBATIM));
        this.add(new BibtexSingleField("related", false).withProperties(FieldProperty.MULTIPLE_ENTRY_LINK, new FieldProperty[0]));
        this.add(new BibtexSingleField("gender").withProperties(FieldProperty.GENDER, new FieldProperty[0]));
        this.add(new BibtexSingleField("pubstate").withProperties(FieldProperty.PUBLICATION_STATE, new FieldProperty[0]));
        tempField = new BibtexSingleField("#", false, 32);
        tempField.setPrivate();
        tempField.setWriteable(false);
        tempField.setDisplayable(false);
        this.add(tempField);
        tempField = new BibtexSingleField("owner", false).withProperties(FieldProperty.OWNER, new FieldProperty[0]);
        tempField.setPrivate();
        this.add(tempField);
        this.timeStampField = "timestamp";
        tempField = new BibtexSingleField("timestamp", false).withProperties(FieldProperty.DATE, new FieldProperty[0]);
        tempField.setPrivate();
        this.add(tempField);
        tempField = new BibtexSingleField("entrytype", false, 75);
        tempField.setPrivate();
        this.add(tempField);
        tempField = new BibtexSingleField("__search", false);
        tempField.setPrivate();
        tempField.setWriteable(false);
        tempField.setDisplayable(false);
        this.add(tempField);
        tempField = new BibtexSingleField("__groupsearch", false);
        tempField.setPrivate();
        tempField.setWriteable(false);
        tempField.setDisplayable(false);
        this.add(tempField);
        tempField = new BibtexSingleField("__markedentry", false);
        tempField.setPrivate();
        tempField.setWriteable(true);
        tempField.setDisplayable(false);
        this.add(tempField);
        for (String yesNoField : YES_NO_FIELDS) {
            field2 = new BibtexSingleField(yesNoField, false).withProperties(FieldProperty.YES_NO, new FieldProperty[0]);
            this.add(field2);
        }
        for (String numericField : INTEGER_FIELDS) {
            field2 = this.fieldSet.get(numericField);
            if (field2 == null) {
                field2 = new BibtexSingleField(numericField, true).setNumeric();
            }
            field2.getProperties().add(FieldProperty.INTEGER);
            this.add(field2);
        }
        for (String fieldText : VERBATIM_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText, true);
            }
            field2.getProperties().add(FieldProperty.VERBATIM);
            this.add(field2);
        }
        for (String fieldText : PERSON_NAME_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText, true);
            }
            field2.getProperties().add(FieldProperty.PERSON_NAMES);
            this.add(field2);
        }
        for (String fieldText : EDITOR_TYPE_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText, true);
            }
            field2.getProperties().add(FieldProperty.EDITOR_TYPE);
            this.add(field2);
        }
        for (String fieldText : PAGINATION_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText, true);
            }
            field2.getProperties().add(FieldProperty.PAGINATION);
            this.add(field2);
        }
        for (String fieldText : DATE_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText);
            }
            field2.getProperties().add(FieldProperty.DATE);
            field2.getProperties().add(FieldProperty.ISO_DATE);
            this.add(field2);
        }
        for (String fieldText : JOURNAL_NAME_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText);
            }
            field2.getProperties().add(FieldProperty.JOURNAL_NAME);
            this.add(field2);
        }
        for (String fieldText : BOOK_NAME_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText);
            }
            field2.getProperties().add(FieldProperty.BOOK_NAME);
            this.add(field2);
        }
        for (String fieldText : LANGUAGE_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText);
            }
            field2.getProperties().add(FieldProperty.LANGUAGE);
            this.add(field2);
        }
        for (String fieldText : MULTI_KEY_FIELDS) {
            field2 = this.fieldSet.get(fieldText);
            if (field2 == null) {
                field2 = new BibtexSingleField(fieldText);
            }
            field2.getProperties().add(FieldProperty.MULTIPLE_ENTRY_LINK);
            this.add(field2);
        }
    }

    public static void updateTimeStampField(String timeStampFieldName) {
        InternalBibtexFields.getField(InternalBibtexFields.RUNTIME.timeStampField).ifPresent(field2 -> {
            field2.setName(timeStampFieldName);
            InternalBibtexFields.RUNTIME.timeStampField = timeStampFieldName;
        });
    }

    public static void updateSpecialFields(boolean serializeSpecialFields) {
        for (String fieldName : SPECIAL_FIELDS) {
            InternalBibtexFields.getField(fieldName).ifPresent(field2 -> {
                if (serializeSpecialFields) {
                    field2.setPublic();
                } else {
                    field2.setPrivate();
                }
                field2.setWriteable(serializeSpecialFields);
                field2.setDisplayable(serializeSpecialFields);
            });
        }
    }

    public static void setNumericFields(List<String> numFields) {
        BibtexSingleField field2;
        if (numFields.isEmpty()) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        names.addAll(numFields);
        for (String fieldName : InternalBibtexFields.RUNTIME.fieldSet.keySet()) {
            field2 = InternalBibtexFields.RUNTIME.fieldSet.get(fieldName);
            if (!field2.isNumeric() && names.contains(fieldName)) {
                field2.setNumeric();
            }
            names.remove(fieldName);
        }
        for (String fieldName : names) {
            field2 = new BibtexSingleField(fieldName, false);
            field2.setNumeric();
            InternalBibtexFields.RUNTIME.fieldSet.put(fieldName, field2);
        }
    }

    public static Set<FieldProperty> getFieldProperties(String name) {
        return InternalBibtexFields.getField(name).map(BibtexSingleField::getProperties).orElse(EnumSet.noneOf(FieldProperty.class));
    }

    private static Optional<BibtexSingleField> getField(String name) {
        if (name != null) {
            return Optional.ofNullable(InternalBibtexFields.RUNTIME.fieldSet.get(name.toLowerCase(Locale.ENGLISH)));
        }
        return Optional.empty();
    }

    public static int getFieldLength(String name) {
        return InternalBibtexFields.getField(name).map(BibtexSingleField::getLength).orElse(100);
    }

    public static List<String> getAllPublicFieldNames() {
        ArrayList<String> publicFields = new ArrayList<String>();
        for (BibtexSingleField field2 : InternalBibtexFields.RUNTIME.fieldSet.values()) {
            if (field2.isPrivate()) continue;
            publicFields.add(field2.getName());
        }
        Collections.sort(publicFields);
        return publicFields;
    }

    public static boolean isWriteableField(String field2) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field2);
        return !sField.isPresent() || sField.get().isWriteable();
    }

    public static boolean isDisplayableField(String field2) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field2);
        return !sField.isPresent() || sField.get().isDisplayable();
    }

    public static boolean isStandardField(String field2) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field2);
        return sField.isPresent() && sField.get().isStandard();
    }

    public static boolean isNumeric(String field2) {
        Optional<BibtexSingleField> sField = InternalBibtexFields.getField(field2);
        return sField.isPresent() && sField.get().isNumeric();
    }

    public static boolean isInternalField(String field2) {
        return field2.startsWith("__");
    }

    public static List<String> getJournalNameFields() {
        return InternalBibtexFields.getFieldsWithProperty(FieldProperty.JOURNAL_NAME);
    }

    public static List<String> getAllPublicAndInternalFieldNames() {
        ArrayList<String> publicAndInternalFields = new ArrayList<String>();
        publicAndInternalFields.addAll(InternalBibtexFields.getAllPublicFieldNames());
        publicAndInternalFields.add("all");
        publicAndInternalFields.add("all-text-fields");
        Collections.sort(publicAndInternalFields);
        return publicAndInternalFields;
    }

    public static List<String> getBookNameFields() {
        return InternalBibtexFields.getFieldsWithProperty(FieldProperty.BOOK_NAME);
    }

    public static List<String> getPersonNameFields() {
        return InternalBibtexFields.getFieldsWithProperty(FieldProperty.PERSON_NAMES);
    }

    public static List<String> getFieldsWithProperty(FieldProperty property) {
        return InternalBibtexFields.RUNTIME.fieldSet.values().stream().filter(field2 -> !field2.isPrivate()).filter(field2 -> field2.getProperties().contains((Object)property)).map(BibtexSingleField::getName).sorted().collect(Collectors.toList());
    }

    public static List<String> getIEEETranBSTctlYesNoFields() {
        return YES_NO_FIELDS;
    }

    private void add(BibtexSingleField field2) {
        this.fieldSet.put(field2.getName(), field2);
    }
}

