/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Optional;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;

public class BracketChecker
implements ValueChecker {
    @Override
    public Optional<String> checkValue(String value) {
        if (StringUtil.isBlank(value)) {
            return Optional.empty();
        }
        int counter = 0;
        for (char a : value.trim().toCharArray()) {
            if (a == '{') {
                ++counter;
                continue;
            }
            if (a != '}') continue;
            if (counter == 0) {
                return Optional.of(Localization.lang("unexpected closing curly bracket", new String[0]));
            }
            --counter;
        }
        if (counter > 0) {
            return Optional.of(Localization.lang("unexpected opening curly bracket", new String[0]));
        }
        return Optional.empty();
    }
}

