/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.collections.ObservableList;
import org.jabref.logic.importer.ImportException;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BibTeXMLImporter;
import org.jabref.logic.importer.fileformat.BiblioscapeImporter;
import org.jabref.logic.importer.fileformat.BibtexImporter;
import org.jabref.logic.importer.fileformat.CopacImporter;
import org.jabref.logic.importer.fileformat.CustomImporter;
import org.jabref.logic.importer.fileformat.EndnoteImporter;
import org.jabref.logic.importer.fileformat.EndnoteXmlImporter;
import org.jabref.logic.importer.fileformat.FreeCiteImporter;
import org.jabref.logic.importer.fileformat.InspecImporter;
import org.jabref.logic.importer.fileformat.IsiImporter;
import org.jabref.logic.importer.fileformat.MedlineImporter;
import org.jabref.logic.importer.fileformat.MedlinePlainImporter;
import org.jabref.logic.importer.fileformat.ModsImporter;
import org.jabref.logic.importer.fileformat.MsBibImporter;
import org.jabref.logic.importer.fileformat.OvidImporter;
import org.jabref.logic.importer.fileformat.PdfContentImporter;
import org.jabref.logic.importer.fileformat.PdfXmpImporter;
import org.jabref.logic.importer.fileformat.RepecNepImporter;
import org.jabref.logic.importer.fileformat.RisImporter;
import org.jabref.logic.importer.fileformat.SilverPlatterImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.model.database.BibDatabases;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;

public class ImportFormatReader {
    public static final String BIBTEX_FORMAT = "BibTeX";
    private final SortedSet<Importer> formats = new TreeSet<Importer>();
    private ImportFormatPreferences importFormatPreferences;

    public void resetImportFormats(ImportFormatPreferences newImportFormatPreferences, XmpPreferences xmpPreferences, FileUpdateMonitor fileMonitor) {
        this.importFormatPreferences = newImportFormatPreferences;
        this.formats.clear();
        this.formats.add(new BiblioscapeImporter());
        this.formats.add(new BibtexImporter(this.importFormatPreferences, fileMonitor));
        this.formats.add(new BibTeXMLImporter());
        this.formats.add(new CopacImporter());
        this.formats.add(new EndnoteImporter(this.importFormatPreferences));
        this.formats.add(new EndnoteXmlImporter(this.importFormatPreferences));
        this.formats.add(new FreeCiteImporter(this.importFormatPreferences));
        this.formats.add(new InspecImporter());
        this.formats.add(new IsiImporter());
        this.formats.add(new MedlineImporter());
        this.formats.add(new MedlinePlainImporter());
        this.formats.add(new ModsImporter(this.importFormatPreferences));
        this.formats.add(new MsBibImporter());
        this.formats.add(new OvidImporter());
        this.formats.add(new PdfContentImporter(this.importFormatPreferences));
        this.formats.add(new PdfXmpImporter(xmpPreferences));
        this.formats.add(new RepecNepImporter(this.importFormatPreferences));
        this.formats.add(new RisImporter());
        this.formats.add(new SilverPlatterImporter());
        for (CustomImporter importer : this.importFormatPreferences.getCustomImportList()) {
            this.formats.add(importer);
        }
    }

    private Optional<Importer> getByCliId(String cliId) {
        for (Importer format : this.formats) {
            if (!format.getId().equals(cliId)) continue;
            return Optional.of(format);
        }
        return Optional.empty();
    }

    public ParserResult importFromFile(String format, Path file) throws ImportException {
        Optional<Importer> importer = this.getByCliId(format);
        if (!importer.isPresent()) {
            throw new ImportException(Localization.lang("Unknown import format", new String[0]) + ": " + format);
        }
        try {
            return importer.get().importDatabase(file, this.importFormatPreferences.getEncoding());
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
    }

    public SortedSet<Importer> getImportFormats() {
        return this.formats;
    }

    public String getImportFormatList() {
        StringBuilder sb = new StringBuilder();
        for (Importer imFo : this.formats) {
            int pad = Math.max(0, 14 - imFo.getName().length());
            sb.append("  ");
            sb.append(imFo.getName());
            sb.append(StringUtil.repeatSpaces(pad));
            sb.append(" : ");
            sb.append(imFo.getId());
            sb.append('\n');
        }
        return sb.toString();
    }

    public UnknownFormatImport importUnknownFormat(Path filePath, FileUpdateMonitor fileMonitor) throws ImportException {
        Objects.requireNonNull(filePath);
        try {
            ParserResult parserResult = OpenDatabase.loadDatabase(filePath.toFile(), this.importFormatPreferences, fileMonitor);
            if (parserResult.getDatabase().hasEntries() || !parserResult.getDatabase().hasNoStrings()) {
                parserResult.setFile(filePath.toFile());
                return new UnknownFormatImport(BIBTEX_FORMAT, parserResult);
            }
        }
        catch (IOException parserResult) {
            // empty catch block
        }
        UnknownFormatImport unknownFormatImport = this.importUnknownFormat((Importer importer) -> importer.importDatabase(filePath, this.importFormatPreferences.getEncoding()), (Importer importer) -> importer.isRecognizedFormat(filePath, this.importFormatPreferences.getEncoding()));
        unknownFormatImport.parserResult.setFile(filePath.toFile());
        return unknownFormatImport;
    }

    private UnknownFormatImport importUnknownFormat(CheckedFunction<Importer, ParserResult> importDatabase, CheckedFunction<Importer, Boolean> isRecognizedFormat) throws ImportException {
        ObservableList<BibEntry> bestResult = null;
        int bestResultCount = 0;
        String bestFormatName = null;
        for (Importer imFo : this.getImportFormats()) {
            try {
                if (!isRecognizedFormat.apply(imFo).booleanValue()) continue;
                ParserResult parserResult = importDatabase.apply(imFo);
                ObservableList<BibEntry> entries = parserResult.getDatabase().getEntries();
                BibDatabases.purgeEmptyEntries(entries);
                int entryCount = entries.size();
                if (entryCount <= bestResultCount) continue;
                bestResult = entries;
                bestResultCount = entryCount;
                bestFormatName = imFo.getName();
            }
            catch (IOException iOException) {}
        }
        if (bestResult != null) {
            ParserResult parserResult = new ParserResult((Collection<BibEntry>)bestResult);
            return new UnknownFormatImport(bestFormatName, parserResult);
        }
        throw new ImportException(Localization.lang("Could not find a suitable import format.", new String[0]));
    }

    public UnknownFormatImport importUnknownFormat(String data) throws ImportException {
        Objects.requireNonNull(data);
        return this.importUnknownFormat((Importer importer) -> importer.importDatabase(data), (Importer importer) -> importer.isRecognizedFormat(data));
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    public static class UnknownFormatImport {
        public final String format;
        public final ParserResult parserResult;

        public UnknownFormatImport(String format, ParserResult parserResult) {
            this.format = format;
            this.parserResult = parserResult;
        }
    }
}

