/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.CleanupJob;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryConverter;
import org.jabref.model.strings.StringUtil;

public class ConvertToBiblatexCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (Map.Entry<String, String> alias : EntryConverter.FIELD_ALIASES_TEX_TO_LTX.entrySet()) {
            String oldFieldName = alias.getKey();
            String newFieldName = alias.getValue();
            entry.getField(oldFieldName).ifPresent(oldValue -> {
                if (!oldValue.isEmpty() && !entry.getField(newFieldName).isPresent()) {
                    entry.setField(newFieldName, (String)oldValue).ifPresent(changes::add);
                    entry.clearField(oldFieldName).ifPresent(changes::add);
                }
            });
        }
        if (StringUtil.isBlank(entry.getField("date"))) {
            entry.getFieldOrAlias("date").ifPresent(newDate -> {
                entry.setField("date", (String)newDate).ifPresent(changes::add);
                entry.clearField("year").ifPresent(changes::add);
                entry.clearField("month").ifPresent(changes::add);
            });
        }
        return changes;
    }
}

