/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util.component;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.component.Tag;
import org.jabref.model.strings.StringUtil;

public class TagBar<T>
extends HBox {
    private final ListProperty<T> tags = new SimpleListProperty(FXCollections.observableArrayList());
    private StringConverter<T> stringConverter;
    @FXML
    private TextField inputTextField;
    @FXML
    private HBox tagList;
    private BiConsumer<T, MouseEvent> onTagClicked;

    public TagBar() {
        this.tags.addListener(this::onTagsChanged);
        ControlHelper.loadFXMLForControl((Parent)this);
        this.getStylesheets().add(0, (Object)TagBar.class.getResource("TagBar.css").toExternalForm());
    }

    public TextField getInputTextField() {
        return this.inputTextField;
    }

    public ObservableList<T> getTags() {
        return (ObservableList)this.tags.get();
    }

    public void setTags(Collection<T> newTags) {
        this.tags.setAll(this.tags);
    }

    public ListProperty<T> tagsProperty() {
        return this.tags;
    }

    private void onTagsChanged(ListChangeListener.Change<? extends T> change) {
        while (change.next()) {
            if (change.wasRemoved()) {
                this.tagList.getChildren().subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                continue;
            }
            if (!change.wasAdded()) continue;
            this.tagList.getChildren().addAll(change.getFrom(), (Collection)change.getAddedSubList().stream().map(this::createTag).collect(Collectors.toList()));
        }
    }

    private Tag<T> createTag(T item) {
        Tag<Object> tag = new Tag<Object>(arg_0 -> this.stringConverter.toString(arg_0));
        tag.setOnTagRemoved(arg_0 -> this.tags.remove(arg_0));
        tag.setValue(item);
        if (this.onTagClicked != null) {
            tag.setOnMouseClicked(event -> this.onTagClicked.accept(item, (MouseEvent)event));
        }
        return tag;
    }

    @FXML
    private void addTextAsNewTag(ActionEvent event) {
        Object newTag;
        String inputText = this.inputTextField.getText();
        if (StringUtil.isNotBlank(inputText) && (newTag = this.stringConverter.fromString(inputText)) != null && !this.tags.contains(newTag)) {
            this.tags.add(newTag);
            this.inputTextField.clear();
        }
    }

    public void setStringConverter(StringConverter<T> stringConverter) {
        this.stringConverter = stringConverter;
    }

    public void setOnTagClicked(BiConsumer<T, MouseEvent> onTagClicked) {
        this.onTagClicked = onTagClicked;
    }
}

