/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util.comparator;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jabref.model.entry.BibEntry;

public class IconComparator
implements Comparator<BibEntry> {
    private final List<String> fields;

    public IconComparator(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public int compare(BibEntry e1, BibEntry e2) {
        for (String field2 : this.fields) {
            Optional<String> val1 = e1.getField(field2);
            Optional<String> val2 = e2.getField(field2);
            if (val1.isPresent()) {
                if (val2.isPresent()) {
                    int compareToRes = val1.get().compareTo(val2.get());
                    if (compareToRes == 0) continue;
                    return compareToRes;
                }
                return -1;
            }
            if (!val2.isPresent()) continue;
            return 1;
        }
        return 0;
    }
}

