/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.stage.FileChooser;
import org.jabref.gui.util.FileFilterConverter;
import org.jabref.logic.util.FileType;

public class FileDialogConfiguration {
    private final List<FileChooser.ExtensionFilter> extensionFilters;
    private final Path initialDirectory;
    private final FileChooser.ExtensionFilter defaultExtension;
    private final String initialFileName;
    private FileChooser.ExtensionFilter selectedExtensionFilter;

    private FileDialogConfiguration(Path initialDirectory, List<FileChooser.ExtensionFilter> extensionFilters, FileChooser.ExtensionFilter defaultExtension, String initialFileName) {
        this.initialDirectory = initialDirectory;
        this.extensionFilters = Objects.requireNonNull(extensionFilters);
        this.defaultExtension = defaultExtension;
        this.initialFileName = initialFileName;
    }

    public Optional<Path> getInitialDirectory() {
        return Optional.ofNullable(this.initialDirectory);
    }

    public FileChooser.ExtensionFilter getDefaultExtension() {
        return this.defaultExtension;
    }

    public String getInitialFileName() {
        return this.initialFileName;
    }

    public List<FileChooser.ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public FileChooser.ExtensionFilter getSelectedExtensionFilter() {
        return this.selectedExtensionFilter;
    }

    public void setSelectedExtensionFilter(FileChooser.ExtensionFilter selectedExtensionFilter) {
        this.selectedExtensionFilter = selectedExtensionFilter;
    }

    public static class Builder {
        private final List<FileChooser.ExtensionFilter> extensionFilters = new ArrayList<FileChooser.ExtensionFilter>();
        private Path initialDirectory;
        private FileChooser.ExtensionFilter defaultExtension;
        private String initialFileName;

        public FileDialogConfiguration build() {
            return new FileDialogConfiguration(this.initialDirectory, this.extensionFilters, this.defaultExtension, this.initialFileName);
        }

        public Builder withInitialDirectory(Path directory) {
            if (directory == null) {
                this.initialDirectory = null;
            } else {
                if (!Files.isDirectory(directory, new LinkOption[0])) {
                    directory = directory.getParent();
                }
                if (directory != null && !Files.exists(directory, new LinkOption[0])) {
                    directory = null;
                }
                this.initialDirectory = directory;
            }
            return this;
        }

        public Builder withInitialDirectory(String directory) {
            if (directory != null) {
                this.withInitialDirectory(Paths.get(directory, new String[0]));
            } else {
                this.initialDirectory = null;
            }
            return this;
        }

        public Builder withInitialFileName(String initialFileName) {
            this.initialFileName = initialFileName;
            return this;
        }

        public Builder withDefaultExtension(FileChooser.ExtensionFilter extensionFilter) {
            this.defaultExtension = extensionFilter;
            return this;
        }

        public Builder withDefaultExtension(FileType fileType) {
            this.defaultExtension = FileFilterConverter.toExtensionFilter(fileType);
            return this;
        }

        public Builder withDefaultExtension(String description, FileType fileType) {
            this.defaultExtension = FileFilterConverter.toExtensionFilter(description, fileType);
            return this;
        }

        public Builder withDefaultExtension(String fileTypeDescription) {
            this.extensionFilters.stream().filter(type -> type.getDescription().equalsIgnoreCase(fileTypeDescription)).findFirst().ifPresent(extensionFilter -> {
                this.defaultExtension = extensionFilter;
            });
            return this;
        }

        public Builder addExtensionFilter(FileChooser.ExtensionFilter filter) {
            this.extensionFilters.add(filter);
            return this;
        }

        public Builder addExtensionFilter(List<FileChooser.ExtensionFilter> filters) {
            this.extensionFilters.addAll(filters);
            return this;
        }

        public Builder addExtensionFilter(FileType ... fileTypes) {
            Stream.of(fileTypes).map(FileFilterConverter::toExtensionFilter).forEachOrdered(this::addExtensionFilter);
            return this;
        }

        public Builder addExtensionFilter(String description, FileType fileType) {
            this.extensionFilters.add(FileFilterConverter.toExtensionFilter(description, fileType));
            return this;
        }
    }
}

