/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmacsKeyBindings {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmacsKeyBindings.class);
    private static final String KILL_LINE_ACTION = "emacs-kill-line";
    private static final String KILL_RING_SAVE_ACTION = "emacs-kill-ring-save";
    private static final String KILL_REGION_ACTION = "emacs-kill-region";
    private static final String BACKWARD_KILL_WORD_ACTION = "emacs-backward-kill-word";
    private static final String CAPITALIZE_WORD_ACTION = "emacs-capitalize-word";
    private static final String DOWNCASE_WORD_ACTION = "emacs-downcase-word";
    private static final String KILL_WORD_ACTION = "emacs-kill-word";
    private static final String SET_MARK_COMMAND_ACTION = "emacs-set-mark-command";
    private static final String YANK_ACTION = "emacs-yank";
    private static final String YANK_POP_ACTION = "emacs-yank-pop";
    private static final String UPCASE_WORD_ACTION = "emacs-upcase-word";
    private static final JTextComponent.KeyBinding[] EMACS_KEY_BINDINGS_BASE = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(69, 2), "caret-end-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 2), "delete-next"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(78, 2), "caret-down"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(80, 2), "caret-up"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 8), "caret-previous-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 8), "caret-begin"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(153, 9), "caret-end"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 8), "caret-next-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(66, 2), "caret-backward"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(68, 8), "emacs-kill-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(8, 8), "emacs-backward-kill-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(32, 2), "emacs-set-mark-command"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 8), "emacs-kill-ring-save"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(87, 2), "emacs-kill-region"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(75, 2), "emacs-kill-line"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 2), "emacs-yank"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(89, 8), "emacs-yank-pop"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, 8), "emacs-capitalize-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(76, 8), "emacs-downcase-word"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(85, 8), "emacs-upcase-word")};
    private static final JTextComponent.KeyBinding EMACS_KEY_BINDING_C_A = new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, 2), "caret-begin-line");
    private static final JTextComponent.KeyBinding EMACS_KEY_BINDING_C_F = new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(70, 2), "caret-forward");
    private static final TextAction[] EMACS_ACTIONS = new TextAction[]{new KillWordAction("emacs-kill-word"), new BackwardKillWordAction("emacs-backward-kill-word"), new SetMarkCommandAction("emacs-set-mark-command"), new KillRingSaveAction("emacs-kill-ring-save"), new KillRegionAction("emacs-kill-region"), new KillLineAction("emacs-kill-line"), new YankAction("emacs-yank"), new YankPopAction("emacs-yank-pop"), new CapitalizeWordAction("emacs-capitalize-word"), new DowncaseWordAction("emacs-downcase-word"), new UpcaseWordAction("emacs-upcase-word")};
    private static final JTextComponent[] JTCS = new JTextComponent[]{new JTextArea(), new JTextPane(), new JTextField(), new JEditorPane()};

    private EmacsKeyBindings() {
    }

    public static void load() {
        EmacsKeyBindings.createBackup();
        EmacsKeyBindings.loadEmacsKeyBindings();
    }

    private static void createBackup() {
        Keymap oldBackup = JTextComponent.getKeymap(JTCS[0].getClass().getName());
        if (oldBackup != null) {
            return;
        }
        for (JTextComponent jtc : JTCS) {
            Action[] bound;
            Keymap orig = jtc.getKeymap();
            Keymap backup = JTextComponent.addKeymap(jtc.getClass().getName(), null);
            for (Action aBound : bound = orig.getBoundActions()) {
                KeyStroke[] strokes;
                for (KeyStroke stroke : strokes = orig.getKeyStrokesForAction(aBound)) {
                    backup.addActionForKeyStroke(stroke, aBound);
                }
            }
            backup.setDefaultAction(orig.getDefaultAction());
        }
    }

    public static void unload() {
        for (int i = 0; i < JTCS.length; ++i) {
            Action[] bound;
            Keymap backup = JTextComponent.getKeymap(JTCS[i].getClass().getName());
            if (backup == null) continue;
            Keymap current = JTCS[i].getKeymap();
            current.removeBindings();
            for (Action aBound : bound = backup.getBoundActions()) {
                KeyStroke[] strokes;
                for (KeyStroke stroke : strokes = backup.getKeyStrokesForAction(bound[i])) {
                    current.addActionForKeyStroke(stroke, aBound);
                }
            }
            current.setDefaultAction(backup.getDefaultAction());
        }
    }

    private static void loadEmacsKeyBindings() {
        LOGGER.debug("Loading emacs keybindings");
        for (JTextComponent jtc : JTCS) {
            JTextComponent.KeyBinding[] keybindings;
            Action[] origActions = jtc.getActions();
            Action[] actions2 = new Action[origActions.length + EMACS_ACTIONS.length];
            System.arraycopy(origActions, 0, actions2, 0, origActions.length);
            System.arraycopy(EMACS_ACTIONS, 0, actions2, origActions.length, EMACS_ACTIONS.length);
            Keymap k = jtc.getKeymap();
            boolean rebindCA = JabRefPreferences.getInstance().getBoolean("editorEMACSkeyBindingsRebindCA");
            boolean rebindCF = JabRefPreferences.getInstance().getBoolean("editorEMACSkeyBindingsRebindCF");
            if (rebindCA || rebindCF) {
                int size = EMACS_KEY_BINDINGS_BASE.length;
                int posCA = -1;
                int posCF = -1;
                if (rebindCA) {
                    posCA = size++;
                }
                if (rebindCF) {
                    posCF = size++;
                }
                keybindings = new JTextComponent.KeyBinding[size];
                System.arraycopy(EMACS_KEY_BINDINGS_BASE, 0, keybindings, 0, EMACS_KEY_BINDINGS_BASE.length);
                if (rebindCA) {
                    keybindings[posCA] = EMACS_KEY_BINDING_C_A;
                }
                if (rebindCF) {
                    keybindings[posCF] = EMACS_KEY_BINDING_C_F;
                }
            } else {
                keybindings = EMACS_KEY_BINDINGS_BASE;
            }
            JTextComponent.loadKeymap(k, keybindings, actions2);
        }
    }

    private static void doCopyOrCut(JTextComponent jtc, boolean copy) {
        if (jtc != null) {
            int caretPosition = jtc.getCaretPosition();
            String text = jtc.getSelectedText();
            if (text == null && SetMarkCommandAction.isMarked(jtc)) {
                int beginPos = caretPosition;
                int endPos = SetMarkCommandAction.getCaretPosition();
                if (beginPos > endPos) {
                    int tmp = endPos;
                    endPos = beginPos;
                    beginPos = tmp;
                }
                jtc.select(beginPos, endPos);
                SetMarkCommandAction.reset();
            }
            if ((text = jtc.getSelectedText()) == null) {
                jtc.getToolkit().beep();
            } else {
                if (copy) {
                    jtc.copy();
                    jtc.select(caretPosition, caretPosition);
                } else {
                    int newCaretPos = jtc.getSelectionStart();
                    jtc.cut();
                    jtc.setCaretPosition(newCaretPos);
                }
                KillRing.getInstance().add(text);
            }
        }
    }

    private static int getWordEnd(JTextComponent jtc, int start) throws BadLocationException {
        try {
            return Utilities.getNextWord(jtc, start);
        }
        catch (BadLocationException ble) {
            int end = jtc.getText().length();
            if (start < end) {
                return end;
            }
            throw ble;
        }
    }

    public static class UpcaseWordAction
    extends TextAction {
        public UpcaseWordAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = EmacsKeyBindings.getWordEnd(jtc, start);
                    jtc.setSelectionStart(start);
                    jtc.setSelectionEnd(end);
                    String word = jtc.getText(start, end - start);
                    jtc.replaceSelection(word.toUpperCase(Locale.ROOT));
                    jtc.setCaretPosition(end);
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class DowncaseWordAction
    extends TextAction {
        public DowncaseWordAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = EmacsKeyBindings.getWordEnd(jtc, start);
                    jtc.setSelectionStart(start);
                    jtc.setSelectionEnd(end);
                    String word = jtc.getText(start, end - start);
                    jtc.replaceSelection(word.toLowerCase(Locale.ROOT));
                    jtc.setCaretPosition(end);
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class CapitalizeWordAction
    extends TextAction {
        public CapitalizeWordAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = EmacsKeyBindings.getWordEnd(jtc, start);
                    jtc.setSelectionStart(start);
                    jtc.setSelectionEnd(end);
                    String word = jtc.getText(start, end - start);
                    jtc.replaceSelection(word.toLowerCase(Locale.ROOT));
                    int offs = Utilities.getWordStart(jtc, start);
                    String c = jtc.getText(offs, 1);
                    if (" ".equals(c)) {
                        ++offs;
                        offs = Utilities.getWordStart(jtc, offs);
                        c = jtc.getText(offs, 1);
                    }
                    if (Character.isLetter(c.charAt(0))) {
                        jtc.setSelectionStart(offs);
                        jtc.setSelectionEnd(offs + 1);
                        jtc.replaceSelection(c.toUpperCase(Locale.ROOT));
                    }
                    end = Utilities.getWordEnd(jtc, offs);
                    jtc.setCaretPosition(end);
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class KillRing {
        private static final KillRing INSTANCE = new KillRing();
        private JTextComponent jtc;
        private final LinkedList<String> ring = new LinkedList();
        private Iterator<String> iter = this.ring.iterator();

        public static KillRing getInstance() {
            return INSTANCE;
        }

        public void setCurrentTextComponent(JTextComponent jtc) {
            this.jtc = jtc;
        }

        public JTextComponent getCurrentTextComponent() {
            return this.jtc;
        }

        public void add(String text) {
            if (text.isEmpty()) {
                return;
            }
            this.ring.remove(text);
            this.ring.addFirst(text);
            while (this.ring.size() > 60) {
                this.ring.removeLast();
            }
            this.iter = this.ring.iterator();
            this.iter.next();
        }

        public List<String> getRing() {
            return Collections.unmodifiableList(this.ring);
        }

        public boolean isEmpty() {
            return this.ring.isEmpty();
        }

        public String next() {
            if (this.ring.isEmpty()) {
                return null;
            }
            if (this.iter.hasNext()) {
                return this.iter.next();
            }
            this.iter = this.ring.iterator();
            return this.iter.next();
        }
    }

    public static class YankPopAction
    extends TextAction {
        public YankPopAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean killRingNotEmpty;
            JTextComponent jtc = this.getTextComponent(event);
            boolean jtcNotNull = jtc != null;
            boolean jtcIsCurrentTextComponent = KillRing.getInstance().getCurrentTextComponent() == jtc;
            boolean caretPositionIsEndOfLastYank = jtcNotNull && jtc.getCaretPosition() == YankAction.end;
            boolean bl = killRingNotEmpty = !KillRing.getInstance().isEmpty();
            if (jtcNotNull && jtcIsCurrentTextComponent && caretPositionIsEndOfLastYank && killRingNotEmpty) {
                jtc.setSelectionStart(YankAction.start);
                jtc.setSelectionEnd(YankAction.end);
                String toYank = KillRing.getInstance().next();
                if (toYank == null) {
                    jtc.getToolkit().beep();
                } else {
                    jtc.replaceSelection(toYank);
                    YankAction.end = jtc.getCaretPosition();
                }
            }
        }
    }

    public static class YankAction
    extends TextAction {
        public static int start = -1;
        public static int end = -1;

        public YankAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JTextComponent jtc = this.getTextComponent(event);
            if (jtc != null) {
                try {
                    start = jtc.getCaretPosition();
                    jtc.paste();
                    end = jtc.getCaretPosition();
                    KillRing.getInstance().add(jtc.getText(start, end));
                    KillRing.getInstance().setCurrentTextComponent(jtc);
                }
                catch (BadLocationException e) {
                    LOGGER.info("Bad location when yanking", e);
                }
            }
        }
    }

    public static class SetMarkCommandAction
    extends TextAction {
        private static int position = -1;
        private static JTextComponent jtc;

        public SetMarkCommandAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            jtc = this.getTextComponent(e);
            if (jtc != null) {
                position = jtc.getCaretPosition();
            }
        }

        public static boolean isMarked(JTextComponent jt) {
            return jtc == jt && position != -1;
        }

        public static void reset() {
            jtc = null;
            position = -1;
        }

        public static int getCaretPosition() {
            return position;
        }
    }

    public static class KillLineAction
    extends TextAction {
        public KillLineAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null) {
                try {
                    int start = jtc.getCaretPosition();
                    int end = Utilities.getRowEnd(jtc, start);
                    if (start == end && jtc.isEditable()) {
                        Document doc = jtc.getDocument();
                        doc.remove(end, 1);
                    } else {
                        jtc.setSelectionStart(start);
                        jtc.setSelectionEnd(end);
                        String selectedText = jtc.getSelectedText();
                        if (selectedText != null) {
                            KillRing.getInstance().add(selectedText);
                        }
                        jtc.cut();
                    }
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class KillRegionAction
    extends TextAction {
        public KillRegionAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            EmacsKeyBindings.doCopyOrCut(jtc, false);
        }
    }

    public static class KillRingSaveAction
    extends TextAction {
        public KillRingSaveAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            EmacsKeyBindings.doCopyOrCut(jtc, true);
        }
    }

    public static class BackwardKillWordAction
    extends TextAction {
        public BackwardKillWordAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null) {
                try {
                    int offs = jtc.getCaretPosition();
                    jtc.setSelectionEnd(offs);
                    offs = Utilities.getPreviousWord(jtc, offs);
                    jtc.setSelectionStart(offs);
                    String selectedText = jtc.getSelectedText();
                    if (selectedText != null) {
                        KillRing.getInstance().add(selectedText);
                    }
                    jtc.cut();
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }

    public static class KillWordAction
    extends TextAction {
        public KillWordAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent jtc = this.getTextComponent(e);
            if (jtc != null) {
                try {
                    int offs = jtc.getCaretPosition();
                    jtc.setSelectionStart(offs);
                    offs = EmacsKeyBindings.getWordEnd(jtc, offs);
                    jtc.setSelectionEnd(offs);
                    String selectedText = jtc.getSelectedText();
                    if (selectedText != null) {
                        KillRing.getInstance().add(selectedText);
                    }
                    jtc.cut();
                }
                catch (BadLocationException ble) {
                    jtc.getToolkit().beep();
                }
            }
        }
    }
}

