/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.help;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.BuildInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialogViewModel
extends AbstractViewModel {
    private static final String HOMEPAGE_URL = "https://www.jabref.org";
    private static final String DONATION_URL = "https://donations.jabref.org";
    private static final String LIBRARIES_URL = "https://github.com/JabRef/jabref/blob/master/external-libraries.txt";
    private static final String GITHUB_URL = "https://github.com/JabRef/jabref";
    private static final String LICENSE_URL = "https://github.com/JabRef/jabref/blob/master/LICENSE.md";
    private final String changelogUrl;
    private final String versionInfo;
    private final ReadOnlyStringWrapper environmentInfo = new ReadOnlyStringWrapper();
    private final Logger logger = LoggerFactory.getLogger(AboutDialogViewModel.class);
    private final ReadOnlyStringWrapper heading = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper authors = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper developers = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper license = new ReadOnlyStringWrapper();
    private final ReadOnlyBooleanWrapper isDevelopmentVersion = new ReadOnlyBooleanWrapper();
    private final DialogService dialogService;
    private final ReadOnlyStringWrapper developmentVersion = new ReadOnlyStringWrapper();
    private final ClipBoardManager clipBoardManager;

    public AboutDialogViewModel(DialogService dialogService, ClipBoardManager clipBoardManager, BuildInfo buildInfo) {
        this.dialogService = Objects.requireNonNull(dialogService);
        this.clipBoardManager = Objects.requireNonNull(clipBoardManager);
        String[] version = buildInfo.getVersion().getFullVersion().split("--");
        this.heading.set("JabRef " + version[0]);
        if (version.length == 1) {
            this.isDevelopmentVersion.set(false);
        } else {
            this.isDevelopmentVersion.set(true);
            String dev = Lists.newArrayList(version).stream().filter(string -> !string.equals(version[0])).collect(Collectors.joining("--"));
            this.developmentVersion.set(dev);
        }
        this.developers.set(buildInfo.getDevelopers());
        this.authors.set(buildInfo.getAuthors());
        this.license.set(Localization.lang("License", new String[0]) + ":");
        this.changelogUrl = buildInfo.getVersion().getChangelogUrl();
        this.versionInfo = String.format("JabRef %s%n%s %s %s %nJava %s", buildInfo.getVersion(), BuildInfo.OS, BuildInfo.OS_VERSION, BuildInfo.OS_ARCH, BuildInfo.JAVA_VERSION);
    }

    public String getDevelopmentVersion() {
        return this.developmentVersion.get();
    }

    public ReadOnlyStringProperty developmentVersionProperty() {
        return this.developmentVersion.getReadOnlyProperty();
    }

    public boolean isIsDevelopmentVersion() {
        return this.isDevelopmentVersion.get();
    }

    public ReadOnlyBooleanProperty isDevelopmentVersionProperty() {
        return this.isDevelopmentVersion.getReadOnlyProperty();
    }

    public ReadOnlyStringProperty authorsProperty() {
        return this.authors.getReadOnlyProperty();
    }

    public String getAuthors() {
        return this.authors.get();
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public ReadOnlyStringProperty developersProperty() {
        return this.developers.getReadOnlyProperty();
    }

    public String getDevelopers() {
        return this.developers.get();
    }

    public ReadOnlyStringProperty headingProperty() {
        return this.heading.getReadOnlyProperty();
    }

    public String getHeading() {
        return this.heading.get();
    }

    public ReadOnlyStringProperty licenseProperty() {
        return this.license.getReadOnlyProperty();
    }

    public String getLicense() {
        return this.license.get();
    }

    public String getEnvironmentInfo() {
        return this.environmentInfo.get();
    }

    public void copyVersionToClipboard() {
        this.clipBoardManager.setClipboardContents(this.versionInfo);
        this.dialogService.notify(Localization.lang("Copied version to clipboard", new String[0]));
    }

    public void openJabrefWebsite() {
        this.openWebsite(HOMEPAGE_URL);
    }

    public void openExternalLibrariesWebsite() {
        this.openWebsite(LIBRARIES_URL);
    }

    public void openGithub() {
        this.openWebsite(GITHUB_URL);
    }

    public void openChangeLog() {
        this.openWebsite(this.changelogUrl);
    }

    public void openLicense() {
        this.openWebsite(LICENSE_URL);
    }

    public void openDonation() {
        this.openWebsite(DONATION_URL);
    }

    private void openWebsite(String url) {
        try {
            JabRefDesktop.openBrowser(url);
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Could not open website.", new String[0]), e);
            this.logger.error("Could not open default browser.", e);
        }
    }
}

