/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.filelist;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.gui.filelist.ConfirmCloseFileListEntryEditor;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileListEntryEditor {
    private static final Pattern REMOTE_LINK_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Logger LOGGER = LoggerFactory.getLogger(FileListEntryEditor.class);
    private final JTextField link = new JTextField();
    private final JTextField description = new JTextField();
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JComboBox<ExternalFileType> types;
    private final JProgressBar prog = new JProgressBar(0);
    private final JLabel downloadLabel = new JLabel(Localization.lang("Downloading...", new String[0]));
    private JDialog diag;
    private JabRefFrame frame;
    private boolean showSaveDialog;
    private ConfirmCloseFileListEntryEditor externalConfirm;
    private LinkedFile entry;
    private BibDatabaseContext databaseContext;
    private final ActionListener browsePressed = e -> {
        String fileText = this.link.getText().trim();
        Optional<Path> file = FileHelper.expandFilename(this.databaseContext, fileText, Globals.prefs.getFileDirectoryPreferences());
        Path workingDir = file.orElse(Paths.get(Globals.prefs.get("workingDirectory"), new String[0]));
        String fileName = Paths.get(fileText, new String[0]).getFileName().toString();
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(workingDir).withInitialFileName(fileName).build();
        FXDialogService ds = new FXDialogService();
        Optional path = this.showSaveDialog ? DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileSaveDialog(fileDialogConfiguration)) : DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileOpenDialog(fileDialogConfiguration));
        path.ifPresent(newFile -> {
            Globals.prefs.put("workingDirectory", newFile.toString());
            List<Path> fileDirectories = this.databaseContext.getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences());
            newFile = FileUtil.shortenFileName(newFile, fileDirectories);
            this.link.setText(newFile.toString());
            this.link.requestFocus();
        });
    };
    private boolean okPressed;
    private boolean okDisabledExternally;
    private boolean openBrowseWhenShown;
    private boolean dontOpenBrowseUntilDisposed;

    public FileListEntryEditor(LinkedFile entry, boolean showProgressBar, boolean showOpenButton, BibDatabaseContext databaseContext, boolean showSaveDialog) {
        this(entry, showProgressBar, showOpenButton, databaseContext);
        this.showSaveDialog = showSaveDialog;
    }

    public FileListEntryEditor(LinkedFile entry, boolean showProgressBar, boolean showOpenButton, BibDatabaseContext databaseContext) {
        this.entry = entry;
        this.databaseContext = databaseContext;
        ActionListener okAction = e -> {
            if (!this.ok.isEnabled()) {
                return;
            }
            if (this.externalConfirm != null) {
                this.storeSettings(entry);
                if (!this.externalConfirm.confirmClose(entry)) {
                    return;
                }
            }
            this.diag.dispose();
            this.storeSettings(this.entry);
            this.okPressed = true;
        };
        this.types = new JComboBox();
        this.types.addItemListener(itemEvent -> {
            if (!this.okDisabledExternally) {
                this.ok.setEnabled(this.types.getSelectedItem() != null);
            }
        });
        FormLayout fileDialog = new FormLayout("left:pref, 4dlu, fill:400dlu, 4dlu, fill:pref, 4dlu, fill:pref", "p, 8dlu, p, 8dlu, p");
        FormBuilder builder = FormBuilder.create().layout(fileDialog);
        builder.add(Localization.lang("Link", new String[0]), new Object[0]).xy(1, 1);
        builder.add(this.link).xy(3, 1);
        final JButton browseBut = new JButton(Localization.lang("Browse", new String[0]));
        browseBut.addActionListener(this.browsePressed);
        builder.add(browseBut).xy(5, 1);
        JButton open = new JButton(Localization.lang("Open", new String[0]));
        if (showOpenButton) {
            builder.add(open).xy(7, 1);
        }
        builder.add(Localization.lang("Description", new String[0]), new Object[0]).xy(1, 3);
        builder.add(this.description).xyw(3, 3, 5);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.add(Localization.lang("File type", new String[0]), new Object[0]).xy(1, 5);
        builder.add(this.types).xyw(3, 5, 5);
        if (showProgressBar) {
            builder.appendRows("2dlu, p", new Object[0]);
            builder.add(this.downloadLabel).xy(1, 7);
            builder.add(this.prog).xyw(3, 7, 3);
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addRelatedGap();
        bb.addButton((JComponent)this.ok);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ok.addActionListener(okAction);
        this.link.addActionListener(okAction);
        this.description.addActionListener(okAction);
        open.addActionListener(e -> this.openFile());
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileListEntryEditor.this.diag.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        this.link.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }
        });
        this.diag = new JDialog();
        this.diag.setTitle(Localization.lang("Select files", new String[0]));
        this.diag.setModal(true);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        this.diag.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent event) {
                if (FileListEntryEditor.this.openBrowseWhenShown && !FileListEntryEditor.this.dontOpenBrowseUntilDisposed) {
                    FileListEntryEditor.this.dontOpenBrowseUntilDisposed = true;
                    SwingUtilities.invokeLater(() -> FileListEntryEditor.this.browsePressed.actionPerformed(new ActionEvent(browseBut, 0, "")));
                }
            }

            @Override
            public void windowClosed(WindowEvent event) {
                FileListEntryEditor.this.dontOpenBrowseUntilDisposed = false;
            }
        });
        this.setValues(entry);
    }

    private void checkExtension() {
        if (this.types.getSelectedIndex() == -1 && !this.link.getText().trim().isEmpty()) {
            Optional<ExternalFileType> type;
            if (REMOTE_LINK_PATTERN.matcher(this.link.getText()).matches() && (type = ExternalFileTypes.getInstance().getExternalFileTypeByExt("html")).isPresent()) {
                this.types.setSelectedItem(type.get());
                return;
            }
            String theLink = this.link.getText().trim();
            ExternalFileTypes.getInstance().getExternalFileTypeForName(theLink).ifPresent(this.types::setSelectedItem);
        }
    }

    private void openFile() {
        ExternalFileType type = (ExternalFileType)this.types.getSelectedItem();
        if (type != null) {
            try {
                JabRefDesktop.openExternalFileAnyFormat(this.databaseContext, this.link.getText(), Optional.of(type));
            }
            catch (IOException e) {
                LOGGER.error("File could not be opened", e);
            }
        }
    }

    public void setExternalConfirm(ConfirmCloseFileListEntryEditor eC) {
        this.externalConfirm = eC;
    }

    public void setOkEnabled(boolean enabled) {
        this.okDisabledExternally = !enabled;
        this.ok.setEnabled(enabled);
    }

    public JProgressBar getProgressBar() {
        return this.prog;
    }

    public JLabel getProgressBarLabel() {
        return this.downloadLabel;
    }

    public void setEntry(LinkedFile entry) {
        this.entry = entry;
        this.setValues(entry);
    }

    public void setVisible(boolean visible, boolean openBrowse) {
        boolean bl = this.openBrowseWhenShown = openBrowse && Globals.prefs.getBoolean("allowFileAutoOpenBrowse");
        if (visible) {
            this.okPressed = false;
        }
        String title = this.showSaveDialog ? Localization.lang("Save file", new String[0]) : Localization.lang("Select files", new String[0]);
        this.diag.setTitle(title);
        this.diag.setVisible(visible);
    }

    public boolean isVisible() {
        return this.diag != null && this.diag.isVisible();
    }

    private void setValues(LinkedFile entry) {
        this.description.setText(entry.getDescription());
        this.link.setText(entry.getLink());
        Set<ExternalFileType> list = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
        this.types.setModel(new DefaultComboBoxModel<ExternalFileType>(list.toArray(new ExternalFileType[list.size()])));
        this.types.setSelectedIndex(-1);
        Optional<ExternalFileType> fileType = ExternalFileTypes.getInstance().fromLinkedFile(entry, false);
        if (fileType.isPresent() && !(fileType.get() instanceof UnknownExternalFileType)) {
            this.types.setSelectedItem(fileType.get());
        } else if (entry.getLink() != null && !entry.getLink().isEmpty()) {
            this.checkExtension();
        }
    }

    private void storeSettings(LinkedFile listEntry) {
        String descriptionText = this.description.getText().trim();
        String fileLink = "";
        try {
            List<String> dirs = this.databaseContext.getFileDirectories(Globals.prefs.getFileDirectoryPreferences());
            if (dirs.isEmpty()) {
                fileLink = this.link.getText().trim();
            } else {
                boolean found = false;
                for (String dir : dirs) {
                    String flPath;
                    String canPath = new File(dir).getCanonicalPath();
                    File fl = new File(this.link.getText().trim());
                    if (!fl.isAbsolute() || (flPath = fl.getCanonicalPath()).length() <= canPath.length() || !flPath.startsWith(canPath)) continue;
                    fileLink = fl.getCanonicalPath().substring(canPath.length() + 1);
                    found = true;
                    break;
                }
                if (!found) {
                    fileLink = this.link.getText().trim();
                }
            }
        }
        catch (IOException ex) {
            fileLink = this.link.getText().trim();
        }
        ExternalFileType type = (ExternalFileType)this.types.getSelectedItem();
        listEntry.setDescription(descriptionText);
        listEntry.setFileType(type.getName());
        listEntry.setLink(fileLink);
    }

    public boolean okPressed() {
        return this.okPressed;
    }
}

