/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.EntryLinkList;
import org.jabref.model.entry.ParsedEntryLink;

public class LinkedEntriesEditorViewModel
extends AbstractEditorViewModel {
    private final BibDatabaseContext databaseContext;
    private final ListProperty<ParsedEntryLink> linkedEntries;

    public LinkedEntriesEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, BibDatabaseContext databaseContext, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.databaseContext = databaseContext;
        this.linkedEntries = new SimpleListProperty(FXCollections.observableArrayList());
        BindingsHelper.bindContentBidirectional(this.linkedEntries, this.text, EntryLinkList::serialize, newText -> EntryLinkList.parse(newText, databaseContext.getDatabase()));
    }

    public Collection<ParsedEntryLink> complete(AutoCompletionBinding.ISuggestionRequest request) {
        Collection<?> bibEntries = super.complete(request);
        return bibEntries.stream().map(ParsedEntryLink::new).collect(Collectors.toList());
    }

    public ListProperty<ParsedEntryLink> linkedEntriesProperty() {
        return this.linkedEntries;
    }

    public StringConverter<ParsedEntryLink> getStringConverter() {
        return new StringConverter<ParsedEntryLink>(){

            public String toString(ParsedEntryLink linkedEntry) {
                if (linkedEntry == null) {
                    return "";
                }
                return linkedEntry.getKey();
            }

            public ParsedEntryLink fromString(String key) {
                return LinkedEntriesEditorViewModel.this.databaseContext.getDatabase().getEntryByKey(key).map(ParsedEntryLink::new).orElse(null);
            }
        };
    }

    public void jumpToEntry(ParsedEntryLink parsedEntryLink) {
    }
}

