/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.BibEntrySuggestionProvider;
import org.jabref.gui.autocompleter.JournalsSuggestionProvider;
import org.jabref.gui.autocompleter.PersonNameSuggestionProvider;
import org.jabref.gui.autocompleter.WordSuggestionProvider;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;

public class SuggestionProviders {
    private final Map<String, AutoCompleteSuggestionProvider<?>> providers = new HashMap();

    public SuggestionProviders() {
    }

    public SuggestionProviders(AutoCompletePreferences preferences, JournalAbbreviationLoader abbreviationLoader) {
        Objects.requireNonNull(preferences);
        List<String> completeFields = preferences.getCompleteFields();
        for (String field2 : completeFields) {
            AutoCompleteSuggestionProvider<?> autoCompleter = this.initalizeSuggestionProvider(field2, preferences, abbreviationLoader);
            this.providers.put(field2, autoCompleter);
        }
    }

    public AutoCompleteSuggestionProvider<?> getForField(String fieldName) {
        return this.providers.get(fieldName);
    }

    public void indexDatabase(BibDatabase database) {
        for (BibEntry entry : database.getEntries()) {
            this.indexEntry(entry);
        }
    }

    public void indexEntry(BibEntry bibEntry) {
        for (AutoCompleteSuggestionProvider<?> autoCompleter : this.providers.values()) {
            autoCompleter.indexEntry(bibEntry);
        }
    }

    private AutoCompleteSuggestionProvider<?> initalizeSuggestionProvider(String fieldName, AutoCompletePreferences preferences, JournalAbbreviationLoader abbreviationLoader) {
        if (InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.PERSON_NAMES)) {
            return new PersonNameSuggestionProvider(fieldName);
        }
        if (InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.SINGLE_ENTRY_LINK)) {
            return new BibEntrySuggestionProvider();
        }
        if (InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.JOURNAL_NAME) || "publisher".equals(fieldName)) {
            return new JournalsSuggestionProvider(fieldName, preferences, abbreviationLoader);
        }
        return new WordSuggestionProvider(fieldName);
    }
}

