/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.BufferedDataRow;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.SettingsContext;
import io.netty.buffer.ByteBuf;
import io.netty.util.ResourceLeakDetector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class QueryCommandImpl
extends CommandImpl
implements QueryCommand {
    private String command;
    private List<QueryCommand.ResultBatch> resultBatches;
    private QueryCommand.ResultBatch resultBatch;
    private long queryTimeout;
    private SettingsContext parsingContext;
    private int maxFieldLength;

    QueryCommandImpl(String command) {
        this.command = command;
        this.maxFieldLength = Integer.MAX_VALUE;
    }

    @Override
    public void setQueryTimeout(long timeout) {
        this.queryTimeout = timeout;
    }

    @Override
    public List<QueryCommand.ResultBatch> getResultBatches() {
        return this.resultBatches;
    }

    @Override
    public void execute(ProtocolImpl protocol) throws IOException {
        this.resultBatch = new QueryCommand.ResultBatch();
        this.resultBatches = new ArrayList<QueryCommand.ResultBatch>();
        this.parsingContext = new SettingsContext(protocol.getContext());
        this.parsingContext.setSetting("field.varying.length.max", this.maxFieldLength);
        Listener listener = new Listener(protocol.getContext());
        protocol.setListener(listener);
        ByteBuf msg = protocol.channel.alloc().buffer();
        try {
            protocol.writeQuery(msg, this.command);
            protocol.writeSync(msg);
        }
        catch (Throwable t) {
            msg.release();
            throw t;
        }
        protocol.send(msg);
        this.enableCancelTimer(protocol, this.queryTimeout);
        this.waitFor(listener);
        if (ResourceLeakDetector.getLevel().compareTo(ResourceLeakDetector.Level.SIMPLE) > 0 && this.resultBatches != null) {
            for (QueryCommand.ResultBatch resultBatch : this.resultBatches) {
                resultBatch.touch();
            }
        }
    }

    @Override
    public QueryCommand.Status getStatus() {
        return QueryCommand.Status.Completed;
    }

    @Override
    public void setMaxFieldLength(int maxFieldLength) {
    }

    @Override
    public void setMaxRows(int maxRows) {
    }

    private class Listener
    extends BaseProtocolListener {
        Context context;

        Listener(Context context) {
            this.context = context;
        }

        @Override
        public boolean isComplete() {
            return !QueryCommandImpl.this.resultBatches.isEmpty() || QueryCommandImpl.this.error != null || QueryCommandImpl.this.exception != null;
        }

        @Override
        public void rowDescription(List<ResultField> resultFields) {
            QueryCommandImpl.this.resultBatch.setFields(resultFields);
            QueryCommandImpl.this.resultBatch.resetResults(true);
        }

        @Override
        public void rowData(ByteBuf buffer) throws IOException {
            QueryCommandImpl.this.resultBatch.addResult(BufferedDataRow.parse(buffer, QueryCommandImpl.this.resultBatch.getFields(), QueryCommandImpl.this.parsingContext));
        }

        @Override
        public void commandComplete(String command, Long rowsAffected, Long oid) {
            QueryCommandImpl.this.resultBatch.setCommand(command);
            QueryCommandImpl.this.resultBatch.setRowsAffected(rowsAffected);
            QueryCommandImpl.this.resultBatch.setInsertedOid(oid);
            QueryCommandImpl.this.resultBatches.add(QueryCommandImpl.this.resultBatch);
            QueryCommandImpl.this.resultBatch = new QueryCommand.ResultBatch();
        }

        @Override
        public synchronized void error(Notice error) {
            QueryCommandImpl.this.error = error;
            this.notifyAll();
        }

        @Override
        public synchronized void exception(Throwable cause) {
            QueryCommandImpl.this.setException(cause);
            this.notifyAll();
        }

        @Override
        public void notice(Notice notice) {
            QueryCommandImpl.this.addNotice(notice);
        }

        @Override
        public synchronized void ready(TransactionStatus txStatus) {
            this.notifyAll();
        }
    }
}

