/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime;

import com.impossibl.postgres.datetime.DateTimeFormat;
import com.impossibl.postgres.datetime.FormatUtils;
import com.impossibl.postgres.datetime.instants.Instant;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ISOTimeFormat
implements DateTimeFormat {
    Parser parser = new Parser();
    Printer printer = new Printer();
    static final String GMT_ID = "GMT";

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public Printer getPrinter() {
        return this.printer;
    }

    static class Printer
    implements DateTimeFormat.Printer {
        Printer() {
        }

        @Override
        public String format(Instant instant) {
            String microsString;
            TimeZone zone = instant.getZone();
            if (zone == null) {
                zone = TimeZone.getTimeZone("UTC");
            }
            Calendar cal = Calendar.getInstance(zone);
            cal.setTimeInMillis(TimeUnit.MICROSECONDS.toMillis(instant.getMicrosUTC()));
            int hour = cal.get(11);
            int minute = cal.get(12);
            int second = cal.get(13);
            int micros = (int)(instant.getMicrosLocal() - TimeUnit.MILLISECONDS.toMicros(TimeUnit.MICROSECONDS.toMillis(instant.getMicrosLocal())));
            String zeros = "000000000";
            String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
            String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
            String secondString = second < 10 ? "0" + second : Integer.toString(second);
            if (micros == 0) {
                microsString = "0";
            } else {
                microsString = Integer.toString(micros);
                microsString = zeros.substring(0, 6 - microsString.length()) + microsString;
                char[] microsChar = new char[microsString.length()];
                microsString.getChars(0, microsString.length(), microsChar, 0);
                int truncIndex = 5;
                while (microsChar[truncIndex] == '0') {
                    --truncIndex;
                }
                microsString = new String(microsChar, 0, truncIndex + 1);
            }
            StringBuilder timestampBuf = new StringBuilder(20 + microsString.length());
            timestampBuf.append(hourString);
            timestampBuf.append(":");
            timestampBuf.append(minuteString);
            timestampBuf.append(":");
            timestampBuf.append(secondString);
            timestampBuf.append(".");
            timestampBuf.append(microsString);
            if (instant.getZone() != null) {
                long zoneOff = TimeUnit.MILLISECONDS.toHours(instant.getZoneOffsetMillis());
                if (zoneOff > 0L) {
                    timestampBuf.append("+");
                }
                timestampBuf.append(zoneOff);
            }
            return timestampBuf.toString();
        }
    }

    static class Parser
    implements DateTimeFormat.Parser {
        Parser() {
        }

        @Override
        public int parse(String date, int offset, Map<String, Object> pieces) {
            try {
                int[] parseResult = new int[1];
                offset = FormatUtils.parseInt(date, offset, parseResult);
                FormatUtils.checkOffset(date, offset, ':');
                pieces.put("HOURS", parseResult[0]);
                offset = FormatUtils.parseInt(date, offset + 1, parseResult);
                FormatUtils.checkOffset(date, offset, '\u0000');
                pieces.put("MINUTES", parseResult[0]);
                if (offset < date.length()) {
                    FormatUtils.checkOffset(date, offset, ':');
                    offset = FormatUtils.parseInt(date, offset + 1, parseResult);
                    FormatUtils.checkOffset(date, offset, '\u0000');
                    pieces.put("SECONDS", parseResult[0]);
                    if (offset < date.length() && date.charAt(offset) == '.') {
                        FormatUtils.checkOffset(date, offset, '.');
                        int nanosStart = offset + 1;
                        offset = FormatUtils.parseInt(date, nanosStart, parseResult);
                        FormatUtils.checkOffset(date, offset, '\u0000');
                        int nanoDigits = offset - nanosStart;
                        if (nanoDigits > 9) {
                            return ~nanosStart;
                        }
                        int nanos = parseResult[0] * (int)Math.pow(10.0, 9 - nanoDigits);
                        pieces.put("NANOSECONDS", nanos);
                    }
                }
                if (offset < date.length()) {
                    String timeZoneId = null;
                    char timeZoneIndicator = date.charAt(offset);
                    if (timeZoneIndicator == '+' || timeZoneIndicator == '-') {
                        timeZoneId = ISOTimeFormat.GMT_ID + date.substring(offset);
                    } else if (timeZoneIndicator == 'Z') {
                        timeZoneId = ISOTimeFormat.GMT_ID;
                    }
                    if (timeZoneId != null) {
                        pieces.put("ZONE", timeZoneId);
                    }
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                // empty catch block
            }
            return offset;
        }
    }
}

