/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.AbstractCalculation;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SizeInRange
extends AbstractCalculation<Boolean>
implements ListEventListener {
    private final EventList source;
    private final int min;
    private final int max;

    public SizeInRange(EventList source, int min2, int max) {
        super(new Boolean(source.size() >= min2 && source.size() <= max));
        if (min2 > max) {
            throw new IllegalArgumentException("min must be less than max");
        }
        this.source = source;
        this.source.addListEventListener(this);
        this.min = min2;
        this.max = max;
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        Boolean oldValue = (Boolean)this.getValue();
        int size = listChanges.getSourceList().size();
        this.setValue(new Boolean(size >= this.min && size <= this.max));
        Boolean newValue = (Boolean)this.getValue();
        this.fireValueChange(oldValue, newValue);
    }
}

